package pms.shape;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.net.*;
import java.util.*;

import pms.tools.*;

public class LineFile extends ShapeFile {

  public Rectangle2D.Double getBounds(int r) throws IOException {

    Rectangle2D.Double bounds = null;

    DataInput recordStream = readShapeRecord(r, 0);
    int shapeType = recordStream.readInt();

    if (shapeType == NULL_SHAPE) {
      System.err.println("Got a null shape at record " + r);
      return null;
    }

    bounds = readBounds(recordStream);

    return bounds;  
  }

  public Object getShape(int r) throws IOException {

    DataInput recordStream = readShapeRecord(r, 36);
    if (recordStream == null) return null;

    int numParts = LittleEndian.toInt(recordStream.readInt());
    int numPoints = LittleEndian.toInt(recordStream.readInt());
      
    int[] partOffsets = new int[numParts + 1];
    for (int i = 0; i < numParts; i++)
    partOffsets[i] = LittleEndian.toInt(recordStream.readInt());
    partOffsets[numParts] = numPoints;

    path.reset();

    int currentPart = 0;
    for (int i = 0; i < numPoints; i++) {

      float x = (float) LittleEndian.toDouble(recordStream.readLong());
      float y = (float) LittleEndian.toDouble(recordStream.readLong());

      if (i == partOffsets[currentPart]) {
        path.moveTo(x, y);
        currentPart++;
      } else {
        path.lineTo(x, y);
      }
    }

    return path;
  }

  public Object getShape(int r, AffineTransform transform) throws IOException {

    getShape(r);
    path.transform(transform);

    return path;
  }

  public Integer identify(double x, double y, double tolerance)
    throws IOException {

    Integer result = null;

    return result;
  }

  public Object getCoords(Area viewPort) { return null; }

  protected GeneralPath path = new GeneralPath(GeneralPath.WIND_EVEN_ODD);
}
