/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.shape;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;

import pms.tools.*;

public class FileTesselation extends Tesselation {

  private RandomAccessFile index;
  private RandomAccessFile main;
  private String path;

  public static final int INDEX_HEADER_LENGTH = 48;

  public FileTesselation(String path) throws IOException {

    open(path, "r");
  }

  public FileTesselation(String path, String perm) throws IOException {

    open(path, perm);
  }

  protected void open(String path, String perm) throws IOException {

    path = StringTools.setExtension(path, "tsx");
    this.path = path;

    index = new RandomAccessFile(path, perm);
    readHeader();

    main = new RandomAccessFile(
      StringTools.setExtension(path, "tes"), perm);
  }

  public RandomAccessFile getIndexFile() {
    return index;
  }

  public RandomAccessFile getMainFile() {
    return main;
  }

  private void readHeader() throws IOException {

    double left = index.readDouble();
    double top = index.readDouble();
    double width = index.readDouble();
    double height = index.readDouble();

    extent = new Rectangle2D.Double(left, top, width, height);
    cellSize = index.readDouble();
    rows = index.readInt();
    cols = index.readInt();

  }

  public int[] getCell(int col, int row) throws IOException {

    int[] cell = new int[0];

    int indexOffset = 
      INDEX_HEADER_LENGTH + ((row * cols) + col) * 8;

    //  if (Debug.verbose)
    //  System.err.println("Seeking to: " + col + "," + row + 
    //  " at " + indexOffset);
    
    index.seek(indexOffset);
    int cellOffset = index.readInt();
    int length = index.readInt();
  
    // if (Debug.verbose)
    //  System.err.println("Get cell: " + col + "," + row + 
    //  " has length " + length );

    cell = new int[length];
    
    main.seek(cellOffset);

    for (int i = 0; i < cell.length; i++) {
      cell[i] = main.readInt();
    }

    return cell;
  }

  public MemoryTesselation create() {

    return new MemoryTesselation(extent, cellSize, cols, rows);
  }

  public void close() throws IOException {

    main.close();
    index.close();
  }

  
  public static void main(String[] args) {

    try {

      FileTesselation tess = new FileTesselation(args[0]);
      System.out.println(tess);

      int[] lastCell = tess.getCell(
        tess.getColumns() - 1, tess.getRows() - 1);

      System.out.println("Successfully read last index cell");

    } catch (Exception e) {
      e.printStackTrace();
      System.exit(0);
    }

  }

}



