/**

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.server;

import java.awt.*;
import java.io.*;
import java.util.*;

import javax.servlet.http.*;

import pms.*;
import pms.tools.*;
import pms.template.*;

import com.acme.jpm.encoders.GifEncoder;

public class Symbol extends HttpServlet {

  public void doGet(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {

    String targetPath = getServletContext().getRealPath("");
    String layerPath = request.getParameter("LAYER");
    layerPath = StringTools.resolvePath(targetPath, layerPath);
    LayerProperties layerProps = LayerProperties.retrieve(layerPath);

    String index = request.getParameter("INDEX");
    Legend legend = layerProps.getLegend();
    Image symbol = legend.symbols[Integer.parseInt(index)];

    ContentBuffer out = new ContentBuffer();
    GifEncoder encoder = new GifEncoder(symbol, out);
    encoder.encode();
    out.close();

    response.setHeader("Content-type", getResponseType());
    response.setIntHeader("Content-length", out.size());

    out.writeTo(response.getOutputStream());
  }

  public String getResponseType() {

    return "image/gif";
  }
}
