/**

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.server;

import java.io.*;
import java.util.*;

import javax.servlet.http.*;

import pms.*;
import pms.tools.*;
import pms.template.*;

public class MapImage extends HttpServlet {

  public void doPost(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {
    doGet(request, response);
  }

  public void doGet(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {

    String targetPath = getServletContext().getRealPath("");
    HashMap queryParams = RequestTools.getParameters(request);

    CartaProperties props = new CartaProperties(targetPath, queryParams);
    Carta carta = new Carta(props);
    carta.render();

    ContentBuffer out = new ContentBuffer();
    carta.writeImage(out);
    out.close();

    carta.flush();
    Debug.printMemory();

    response.setHeader("Content-type", getResponseType());
    response.setIntHeader("Content-length", out.size());

    out.writeTo(response.getOutputStream());
  }

  public String getResponseType() {

    return "image/gif";
  }
}



