/**

Copyright (C) 2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.server;

import java.awt.*;
import java.io.*;
import java.net.URLDecoder;
import java.sql.*;
import java.util.*;
import java.util.zip.*;

import javax.servlet.ServletException;
import javax.servlet.http.*;

import pms.*;
import pms.table.*;
import pms.tools.*;
import pms.template.*;

import org.apache.log4j.Category;

/**
 * Request generator for automated remote control of a map display.
 *
 * This Servlet builds a large pool of requests for looping over a set
 * number of map displays.
 **/
public class MapAppletRobot extends HttpServlet {

  private static Category log = 
    Category.getInstance(MapApplet.class.getName());

  private MapApplet mapApplet;

  double coords[][];
  int index;

  // collect the coordinates for all TRI facilities
  public void init() throws ServletException {

    mapApplet = new MapApplet();
    mapApplet.init();

    String countQuery = "SELECT COUNT(*) FROM REL_SEARCH_FAC";
    String coordQuery = "SELECT PROJECT_LON, PROJECT_LAT FROM REL_SEARCH_FAC";

    try {

      Connection connection = ConnectionManager.getConnection();
      Statement statement = connection.createStatement();

      ResultSet rs = statement.executeQuery(countQuery);
      rs.next();
      int count = rs.getInt(1);
      rs.close();

      coords = new double[count][2];

      rs = statement.executeQuery(coordQuery);
      index = 0;
      while (rs.next()) {
	coords[index][0] = rs.getDouble(1);
	coords[index][1] = rs.getDouble(2);
	index++;
      }
      rs.close();
      index = 0;

      statement.close();
      connection.close();

    } catch (SQLException e) {
      log.info(e);
    }
  }

  public void doPost(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {
    doGet(request, response);
  }

  public void doGet(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {

    String targetPath = getServletContext().getRealPath("");

    HashMap queryParams = RequestTools.getParameters(request);

    CartaProperties props = new CartaProperties(targetPath, queryParams);
    // recenter on the next facility
    double cx = coords[index][0];
    double cy = coords[index][1];
    index++;
    props.getExtent().center(cx, cy);

    mapApplet.doResponse(response, props, targetPath);
  }
}
