/**

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.server;

import java.util.*;
import java.sql.*;
import java.io.*;

import javax.servlet.http.*;

import org.apache.log4j.Category;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;

import pms.table.ConnectionManager;

/*
 * Set all initialization parameters to this Servlet as system properties.
 * This should be configured to load first in the deployment descriptor
 * for the application.
 **/

public class Init extends HttpServlet {

  private static final String logPropsFileName = "WEB-INF/log4j.properties";

  private static Category log = Category.getInstance(Init.class.getName());

  public void init() {

    initLog();
    initSystemProperties();
    logSystemProperties();
    logEnvironment();
    initDatabaseConnection();
  }

  private void initLog() {

    String logPropsPath = getServletContext().getRealPath(logPropsFileName);
    File logPropsFile = new File(logPropsPath);

    if (logPropsFile.exists()) {
      System.err.println("Configuring error log with " + logPropsFile);
      PropertyConfigurator.configure(logPropsPath);
    } else {
      System.err.println("Configuring error log using defaults");
      BasicConfigurator.configure();
    }

    log.info("Logging started.");
  }

  private void initSystemProperties() {

    Properties p = new Properties(System.getProperties());

    Enumeration names = getInitParameterNames();

    while (names.hasMoreElements()) {

      String name = (String) names.nextElement();
      String value = getInitParameter(name);
      log.info("Setting " + name + " to " + value);
      p.put(name, value);
    }

    System.setProperties(p);
  }

  private void logSystemProperties() {
    
    Properties p = System.getProperties();
    for (Iterator i = p.keySet().iterator(); i.hasNext();) {

      String property = (String) i.next();
      String value = (String) p.get(property);
      log.info(property + " = " + value);
    }
  }

  private void logEnvironment() {

    try {

      log.info("Process Environment:");

      Process p = Runtime.getRuntime().exec("env");

      InputStream i = p.getInputStream();
      
      BufferedReader reader = new BufferedReader(new InputStreamReader(i));

      String line;

      while ((line = reader.readLine()) != null) {

	log.info(line);
      }

    } catch (IOException e) {
      log.info("Could not read environment: " + e);
    }
  }
    
  private void initDatabaseConnection() {

    try {

      // try a pooled JDBC connection
      ConnectionManager.main(null);

    } catch (SQLException e) {
      log.info(e);
    }
  }
}




