/**

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.server;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.servlet.ServletContext;
import javax.servlet.http.*;

import pms.*;
import pms.tools.*;
import pms.template.*;

public class FormPage extends HttpServlet {

  public void doPost(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {
    doGet(request, response);
  }

  public void doGet(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {

    ContentBuffer out = buildPage(getServletContext(), request, response);

    response.setHeader("Content-type", getResponseType());
    response.setIntHeader("Content-length", out.size());

    out.writeTo(response.getOutputStream());
  }

  ContentBuffer buildPage(ServletContext context,
			  HttpServletRequest request, 
			  HttpServletResponse response) throws IOException {

    targetPath = context.getRealPath("");
    String actionParam = request.getParameter("ACTION");
    if (actionParam == null) actionParam = "";

    HashMap queryParams = RequestTools.getParameters(request);

    publisher = new TemplatePublisher(this);

    CartaProperties props = new CartaProperties(targetPath, queryParams);
    Report[] reports = null;

    if (actionParam.equals("IDENTIFY")) {
      Carta carta = new Carta(props);
      reports = carta.identify();
      templateParams.put("WARNING", addReportLinks(reports));
    }

    int[] scales = props.getScaleLevels();
    int scaleLevel = props.getScaleLevel();
    int inLevel = (scaleLevel < 2) ? 1: scaleLevel - 1;
    templateParams.put("IN_LEVEL", Integer.toString(inLevel));
    int outLevel = (scaleLevel >= scales.length) ? scales.length : 
      scaleLevel + 1;
    templateParams.put("OUT_LEVEL", Integer.toString(outLevel));

    int scale = props.getScale();

    Legend[] legends = props.getLegends();
    templateParams.put("LEGEND", addLegends(legends, scale));

    templateParams.put("TITLE", props.getTitle());
    templateParams.put("VIEW", props.getViewPath());
    templateParams.put("SIZE", props.getWidth() + "," + props.getHeight());
    templateParams.put("EXTENT", props.getExtentParam());

    templateParams.put("LEVELS", addLevels(scales, scaleLevel));

    ContentBuffer out = new ContentBuffer();
    PrintStream printOut = new PrintStream(out);
    
    publisher.write("Resources/FormPage", templateParams, printOut);

    printOut.println("</BODY></HTML>");
    printOut.close();
    out.close();

    return out;
  }

  private String addLevels(int[] scales, int scaleLevel) throws IOException {

    ContentBuffer out = new ContentBuffer();
    PrintStream printOut = new PrintStream(out);

    for (int i = scales.length; i > 0; i--) {
      if (i == scaleLevel)
        templateParams.put("ARROW", "<IMG SRC=\"resources/arrow.gif\">"); 
      templateParams.put("LEVEL", Integer.toString(i));
      templateParams.put("LABEL", "level" + i);
      templateParams.put("IMAGE", "level" + i + "_u.gif");
      publisher.write("Resources/ScaleLevel", templateParams, printOut);
      templateParams.remove("ARROW");
    }

    printOut.close();
    out.close();

    return out.toString();
  }

  private String addLegends(Legend[] legends, int scale) throws IOException {

    ContentBuffer out = new ContentBuffer();
    PrintStream printOut = new PrintStream(out);

    for (int i = 0; i < legends.length; i++) {

      Legend legend = legends[i];
      if (legend == null) continue;
      if (! legend.layerProps.getVisibility(scale)) continue;
      String[] labels = legend.labels;

      String layerPath = 
        StringTools.getRelativePath(targetPath, legend.layerProps.getPath());
      templateParams.put("LAYER", layerPath);

      templateParams.put("TITLE", legend.layerProps.getTitle());
      publisher.write("Resources/LegendTitle", templateParams, printOut);

      for (int j = 0; j < labels.length; j++) {
        templateParams.put("INDEX", Integer.toString(j));
        templateParams.put("LABEL", labels[j]);
        publisher.write("Resources/LegendSymbol", templateParams, printOut);
      }
    }

    printOut.close();
    out.close();

    return out.toString();
  }

  private String addReportLinks(Report[] reports) throws IOException {

    if (reports == null) 
      return "No feature found at the location you specified.";

    if (reports.length == 0) 
      return "No reports available for the feature you selected.";

    ContentBuffer out = new ContentBuffer();
    PrintStream printOut = new PrintStream(out);

    publisher.write("Resources/ReportHeader", templateParams, printOut);

    for (int i = 0; i < reports.length; i++) {
      templateParams.put("URL", reports[i].url.toString());
      templateParams.put("LABEL", reports[i].label);
      publisher.write("Resources/Report", templateParams, printOut);
    }

    printOut.close();
    out.close();

    return out.toString();
  }

  public String getResponseType() {

    return "text/html";
  }

  // TO DO: not thread safe!!!

  private HashMap templateParams = new HashMap();
  private TemplatePublisher publisher;
  private String targetPath;
}









