/**

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.server;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.servlet.http.*;

import pms.*;
import pms.tools.*;
import pms.template.*;

public class Describe extends HttpServlet {

  public void doPost(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {
    doGet(request, response);
  }

  public void doGet(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {

    targetPath = getServletContext().getRealPath("");
    String pathParam = request.getParameter("PATH");
    String absPath = StringTools.resolvePath(targetPath, pathParam);
    String extension = StringTools.getExtension(pathParam);

    ContentBuffer out = new ContentBuffer();
    PrintStream printOut = new PrintStream(out);
    publisher = new TemplatePublisher(this);

    if (extension.equals("view")) {
    
      ViewProperties viewProps = ViewProperties.retrieve(absPath);

      ArrayList layerPaths = viewProps.getLayerPaths();
      templateParams.put("LAYERS", addLayers(layerPaths));

      templateParams.put("TITLE", viewProps.getTitle());
      templateParams.put("PATH", absPath);

      publisher.write("Resources/DescribeView", templateParams, printOut); 
    }

    printOut.close();
    out.close();

    response.setHeader("Content-type", getResponseType());
    response.setIntHeader("Content-length", out.size());

    out.writeTo(response.getOutputStream());
  }

  private String addLayers(ArrayList layerPaths) throws IOException {

    ContentBuffer out = new ContentBuffer();
    PrintStream printOut = new PrintStream(out);

    for (Iterator i = layerPaths.iterator(); i.hasNext();) {
      String layerPath = (String) i.next();
      LayerProperties layerProps = LayerProperties.retrieve(layerPath);

      templateParams.put("TITLE", layerProps.getTitle());
      templateParams.put("DESCRIPTION", layerProps.getDescription());
      templateParams.put("PATH", 
        StringTools.getRelativePath(targetPath, layerPath));
      templateParams.put("MIN_SCALE", 
        StringTools.intToString(layerProps.getMinScale()));
      templateParams.put("MAX_SCALE", " " + 
        StringTools.intToString(layerProps.getMaxScale()));

      publisher.write("Resources/LayerSummary", templateParams, printOut); 
    }

    printOut.close();
    out.close();

    return out.toString();
  }

  public String getResponseType() {

    return "text/html";
  }

  private HashMap templateParams = new HashMap();
  private TemplatePublisher publisher;
  private String targetPath;
}
