/**

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.server;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.servlet.ServletException;
import javax.servlet.http.*;

import pms.*;
import pms.template.*;
import pms.tools.*;

public class AppletPage extends HttpServlet {

  private FormPage formPage;

  public void init() throws ServletException {

    formPage = new FormPage();
    formPage.init();
  }

  public void doPost(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {
    doGet(request, response);
  }

  public void doGet(HttpServletRequest request, 
		    HttpServletResponse response) throws IOException {

    ContentBuffer formContent = formPage.buildPage(getServletContext(),
						   request, response);

    ContentBuffer out = new ContentBuffer();
    PrintStream printOut = new PrintStream(out);

    HashMap templateParams = new HashMap();
    templateParams.put("CODEBASE", request.getContextPath());    
    templateParams.put("VIEW", request.getParameter("VIEW"));    
    templateParams.put("EXTENT", request.getParameter("EXTENT"));
    templateParams.put("SIZE", request.getParameter("SIZE"));

    String mode = request.getParameter("ROBOT");
    if (mode == null) mode = "FALSE";
    templateParams.put("MODE", mode);

    TemplatePublisher publisher = new TemplatePublisher(this);

    String sizeParam = (String) request.getParameter("APPLET_SIZE");
    try {
      StringTokenizer s = new StringTokenizer(sizeParam, ",");
      templateParams.put("WIDTH", s.nextToken());
      templateParams.put("HEIGHT", s.nextToken());
    } catch (Exception e) {
      throw new IOException("Failed to parse size parameter: " + sizeParam);
    }

    templateParams.put("FORM", formContent.toString());
    publisher.write("Resources/AppletPage", templateParams, printOut);
    printOut.close();
    out.close();

    response.setHeader("Content-type", getResponseType());
    response.setIntHeader("Content-length", out.size());

    out.writeTo(response.getOutputStream());
  }

  public String getResponseType() {

    return "text/html";
  }
}


