/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.io.*;
import java.net.*;
import java.util.*;

import pms.tools.ImageLoader;

public class ViewFrame {

  public static void drawArrows(BufferedImage image, Graphics2D g) 
    throws IOException {

    if (n == null) loadArrows();

    boolean dispose = false;
    if (g == null) {
      g = image.createGraphics();
      dispose = true;
    }

    int midX = (image.getWidth() / 2) - 7;
    int midY = (image.getHeight() / 2) - 7;

    g.drawImage(nw, 5, 5, loader);
    g.drawImage(w, 5, midY, loader);
    g.drawImage(sw, 5, image.getHeight() - 19, loader);
    g.drawImage(s, midX, image.getHeight() - 19, loader);
    g.drawImage(se, image.getWidth() - 19, image.getHeight() - 19, loader);
    g.drawImage(e, image.getWidth() - 19, midY, loader);
    g.drawImage(ne, image.getWidth() - 19, 5, loader);
    g.drawImage(n, midX, 5, loader);

    if (dispose) g.dispose();
  }

  private static void loadArrows() throws IOException {

    Class thisClass = (new ViewFrame()).getClass();

    n = loader.createImage(thisClass.getResource("Resources/n.gif"));
    s = loader.createImage(thisClass.getResource("Resources/s.gif"));
    w = loader.createImage(thisClass.getResource("Resources/w.gif"));
    e = loader.createImage(thisClass.getResource("Resources/e.gif"));
    ne = loader.createImage(thisClass.getResource("Resources/ne.gif"));
    nw = loader.createImage(thisClass.getResource("Resources/nw.gif"));
    se = loader.createImage(thisClass.getResource("Resources/se.gif"));
    sw = loader.createImage(thisClass.getResource("Resources/sw.gif"));
  }

  private static ImageLoader loader = new ImageLoader();
  private static Image n, s, e, w, ne, nw, se, sw;
}
