package pms;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.io.*;
import java.net.*;
import java.util.*;

import org.apache.log4j.Category;

import pms.tools.*;

public class View {

  private static Category log = Category.getInstance(Carta.class.getName());

  public View(String path) throws IOException {

    props = ViewProperties.retrieve(path);
  }

  public BufferedImage render(Extent geoExtent) throws IOException {

    Debug.initTimeElapsed();
    image = new BufferedImage(
      geoExtent.getDisplayWidth(), geoExtent.getDisplayHeight(), 
      BufferedImage.TYPE_INT_ARGB);

    Graphics2D g = image.createGraphics();
    Debug.printTimeElapsed("Time to prepare graphics buffer (View.render)");

    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                        RenderingHints.VALUE_ANTIALIAS_OFF);
    g.setRenderingHint(RenderingHints.KEY_RENDERING,
                        RenderingHints.VALUE_RENDER_QUALITY);

    g.setColor(props.getBackgroundColor());
    g.fillRect(0, 0, image.getWidth(), image.getHeight());

    Labeler labeler = new Labeler(geoExtent.getViewRect());

    try {

      for (Iterator i = props.getLayerPaths().iterator(); i.hasNext();) {
        Layer layer = new Layer((String) i.next());
 
        if (layer.render(g, geoExtent, labeler))
          layers.add(layer);

	Debug.printTimeElapsed("Time to render " + 
			       layer.getProperties().getTitle() + 
			       " (View.render)");
      }
      labeler.draw(g, 20);

      Debug.printTimeElapsed("Time to draw labels (View.render)");

    } catch (IOException e) {
      g.dispose();
      throw e;
    }

    g.dispose();

    return image;
  }

  public ArrayList getLayers() {

    return layers;
  }

  public Report[] identify(int scale, double x, double y, double tolerance) 
    throws IOException {

    ArrayList layerPaths = props.getLayerPaths();

    for (int i = layerPaths.size(); i > 0; i--) {
      Layer layer = new Layer((String) layerPaths.get(i - 1));
      Report[] reports = layer.identify(scale, x, y, tolerance);
      if (reports != null) return reports;
    }

    return null;
  }

  private BufferedImage image;
  private ViewProperties props;
  private ArrayList layers = new ArrayList();
}

