/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms;

import java.awt.*;
import java.io.*;
import java.util.*;

import pms.shape.*;

public abstract class Symbol {

  static Symbol create(int shapeType) throws FormatException {
    
    Symbol symbol = null;

    switch (shapeType) {

      case ShapeFile.POINT:
      case ShapeFile.POINT_FLOAT:
        symbol = new PointSymbol();
        break;
      case ShapeFile.ARC:
      case ShapeFile.ARC_FLOAT:
        symbol =  new LineSymbol();
        break;
      case ShapeFile.POLYGON:
      case ShapeFile.POLYGON_FLOAT:
        symbol =  new PolygonSymbol();
        break;
      default:
        throw new FormatException(
          "Unable to symbolize shape type " + shapeType);
    }

    return symbol;
  }

  static Symbol create(int shapeType, Properties props, HashMap map) 
    throws FormatException {

    Symbol symbol = create(shapeType);
    symbol.setParams(props, map);

    return symbol;
  }

  static Symbol createDefault(int shapeType) throws FormatException {

    Symbol symbol = create(shapeType);
    symbol.setDefaultParams();

    return symbol;
  }

  static Color parseColor(String rgb) throws FormatException {

    try {

      StringTokenizer s = new StringTokenizer(rgb, ",");

      int red = Integer.parseInt(s.nextToken().trim());
      int green = Integer.parseInt(s.nextToken().trim());
      int blue = Integer.parseInt(s.nextToken().trim());

      return new Color(red, green, blue);

    } catch (Exception e) {
      throw new FormatException("Unable to parse RGB settings: " + rgb);
    }
  }

  public abstract void setParams(Properties props, HashMap map) 
    throws FormatException;
  public abstract void setDefaultParams();
  public abstract void render(Object shape, Graphics2D g);
  public abstract Image getLegendSymbol();
}
