/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms;

import java.io.*;
import java.net.*;
import java.util.*;

import pms.table.*;

public class SQLProperties {

  public SQLProperties(LayerProperties props, HashMap params) 
    throws IOException {
    
    this.props = props;

    tableName =
      props.getOneString("SQL", params, "TABLE_NAME", null, true);
    fromKey =
      props.getOneString("SQL", params, "FROM_KEY", null, true);
    toKey =
      props.getOneString("SQL", params, "TO_KEY", null, true);

    String testValue =
      props.getOneString("SQL", params, "TEST_VALUE", null, true);

    peekTable(testValue);
    addField("SQL", toKey);
  }

  public void addField(String mapName, String field) 
    throws FormatException {

    if (field == null) return;

    if (wantList.indexOf(field) == -1) {
      peekAttribute(mapName, field);
      wantList.add(field);
    }
  }

  public void peekTable(String testValue) throws IOException {

    QueryFactory queryFactory = new QueryFactory();

    ArrayList keyValues = new ArrayList();
    keyValues.add(testValue);

    queryFactory.execute(null, tableName, toKey, keyValues);
    columns = queryFactory.store(null, null);
    queryFactory.close();
  }

  private void peekAttribute(String mapName, String field)
    throws FormatException {

    field = field.toUpperCase();
    Integer column = (Integer) columns.get(field);
    if (column == null)
      throw new FormatException(props.getPath(), 
        mapName, "Field " + field + " not found in database table");
  }

  public Query getQuery(DBaseFile keyFile, ArrayList selection)
    throws IOException {

    int keyColumn = keyFile.getColumn(fromKey);
    Query query = new Query(keyFile, keyColumn);

    query.setStatement(wantList, tableName, toKey);
    query.setRecords(selection);

    return query;
  }

  LayerProperties props;

  String tableName;
  String fromKey;
  String toKey;

  ArrayList wantList = new ArrayList();
  HashMap columns;
}
