package pms;

import java.io.*;
import java.net.*;
import java.util.*;

import pms.table.*;

public class ReportProperties {

  public ReportProperties(LayerProperties props, HashMap params) 
    throws FormatException {

    baseURL = 
      props.getOneString("REPORT", params, "BASE_URL", null, true);
    try {
      new URL(baseURL);
    } catch (MalformedURLException e) {
      throw new FormatException(
        props.getPath(), "REPORT", "Could not parse base URL: " + baseURL);
    }

    labelPrefix = 
      props.getOneString("REPORT", params, "LABEL_PREFIX", "-", false);
    labelField = 
      props.getOneString("REPORT", params, "LABEL_FIELD", "-", false);

    props.peekAttribute("REPORT", labelField, true);

    ArrayList paramBlocks = 
      props.getAllMaps("REPORT", params, "PARAM", false);
    if (paramBlocks != null) {
      for (Iterator j = paramBlocks.iterator(); j.hasNext();) {

        HashMap paramBlock = (HashMap) j.next();
        String paramName = 
          props.getOneString("REPORT", paramBlock, "PARAM_NAME", null, true);
        String fieldName = 
          props.getOneString("REPORT", paramBlock, "FIELD_NAME", null, true);

        props.peekAttribute("REPORT", fieldName, true);

        fieldNames.add(fieldName);
        paramNames.add(paramName);
      }
    }

    parseParam();
  }

  public String getParam() {

    return param;
  }

  private void parseParam() {

    param = labelPrefix + "+" + labelField + "+" + baseURL;

    for (int i = 0; i < fieldNames.size(); i++) {

      param += "+" + (String) paramNames.get(i);
      param += "+" + (String) fieldNames.get(i);
    }
  }

  public Report getReport(Layer layer, int r) throws IOException {

    String location = baseURL;
    for (int i = 0; i < fieldNames.size(); i++) {

      location += (i == 0) ? "?" : "&";
      location += (String) paramNames.get(i);

      String fieldName = (String) fieldNames.get(i);
      Attribute attribute = layer.getAttribute(fieldName);
      String paramValue = attribute.getValue(r);
      location += "=" + URLEncoder.encode(paramValue);
    }

    URL url = null;
    try {
      url = new URL(location);
    } catch (MalformedURLException e) {
      throw new FormatException("Could not build report URL: " + location);
    }

    String label = (labelPrefix.equals("-")) ? "" : labelPrefix + " ";
    if (labelField != null) {
      Attribute attribute = layer.getAttribute(labelField);
      label += attribute.getValue(r);
    }

    return new Report(label, url);
  }

  private String labelPrefix;
  private String labelField;
  private String baseURL;

  private String param;

  private ArrayList fieldNames = new ArrayList();
  private ArrayList paramNames = new ArrayList();
}
