/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms;

import java.io.*;
import java.util.*;

import pms.tools.*;

public class Properties {

  protected HashMap parseFile(String path) throws IOException {

    this.path = StringTools.resolvePath(null, path);
    ArrayList array = new ArrayList();
    Properties.read(path, array);

    HashMap fileMap = new HashMap();
    for (Iterator i = array.iterator(); i.hasNext();) {
      String line = (String) i.next();
      if (line.charAt(0) == '[')
        parseBlock("", line, i, fileMap);
    }

    return fileMap;
  }

  public HashMap getOneMap(String mapName, HashMap map, 
    String key, boolean required) throws FormatException {

    ArrayList list = (ArrayList) map.get(key);
    if ((list == null) || list.isEmpty()) {
      if (! required) {
        return null;
      } else {
        throw new FormatException(
         path, mapName, "Required block " + key + " missing");
      }
    }

    Object object = list.get(0);
    if (object == null) return null;
    if (! (object instanceof HashMap))
      throw new FormatException(
        path, mapName, "Block key " + key + " used as parameter key");

    return (HashMap) object;
  }

  public ArrayList getAllMaps(String mapName, HashMap map, 
    String key, boolean required) throws FormatException {

    ArrayList list = (ArrayList) map.get(key);
    if (list == null) {
      if (! required) {
        return null;
      } else {
        throw new FormatException(
          path, mapName, "Required block key " + key + " missing");
      }
    }

    for (Iterator i = list.iterator(); i.hasNext();) {
      if (! (i.next() instanceof HashMap))
        throw new FormatException(
          path, mapName, "Block key " + key + " used as parameter key");
    }

    return list;
  }

  public String getOneString(String mapName, HashMap map, 
    String key, String fallback, boolean required) throws FormatException {

    ArrayList list = (ArrayList) map.get(key);
    if (list == null) {
      if (! required) {
        return fallback;
      } else {
        throw new FormatException(
          path, mapName, "Required parameter key " + key + " missing");
      }
    }
    Object object = list.get(0);
    if (! (object instanceof String))
      throw new FormatException(
        path, mapName, "Parameter key " + key + " used as block key");
    return (String) object;
  }

  public ArrayList getAllStrings(String mapName, HashMap map, 
    String key, boolean required) throws FormatException {

    ArrayList list = (ArrayList) map.get(key);
    if (list == null) {
      if (! required) {
        return null;
      } else {
        throw new FormatException(
          path, mapName, "Required parameter key " + key + " missing");
      }
    }

    for (Iterator i = list.iterator(); i.hasNext();) {
      if (! (i.next() instanceof String))
        throw new FormatException(
          path, mapName, "Parameter key " + key + " used as block key");
    }

    return list;
  }

  private ArrayList getList(HashMap map, String key) 
    throws FormatException {

    ArrayList list = (ArrayList) map.get(key);

    if (list == null) {
      list = new ArrayList();
      map.put(key, list);
    }
    return list;
  }

  private void parsePair(String mapName, String line, HashMap map) 
    throws FormatException {

    int eq = line.indexOf('=');
    if (eq == -1)
      throw new FormatException(
        path, mapName, "Could not parse key-value pair: " + line);
   
    if (eq == line.length() - 1) return;
    String key = line.substring(0, eq).trim().toUpperCase();
    String value = line.substring(eq + 1).trim();

    ArrayList list = getList(map, key);
    list.add(value);
  }

  private boolean parseBlock(String mapName, String blockHead, 
    Iterator i, HashMap map) throws FormatException {

    String blockType = 
      StringTools.trim(blockHead, '[', ']').trim().toUpperCase();

    if (blockType.equals("END")) return false;
    if (! i.hasNext()) 
      throw new FormatException(path, mapName, "Unexpected EOF");
    
    HashMap submap = new HashMap();
    ArrayList blocks = getList(map, blockType);
    blocks.add(submap);
    while (i.hasNext()) {
      String line = (String) i.next();
      if (line.charAt(0) == '[') {
        if (! parseBlock(blockType, line, i, submap)) break;
      } else {
        parsePair(blockType, line, submap);
      }
    }
    return true;
  }

  public static void read(String path, ArrayList array) throws IOException {
    
    BufferedReader in = new BufferedReader(new FileReader(path));

    String line;
    while ((line = in.readLine()) != null) {

      line = line.trim();
      if (line.length() == 0) continue;
      if (line.charAt(0) == '#') continue;

      if (line.charAt(0) == '%') {
        String includePath = StringTools.resolvePath(path, line.substring(1));
        read(includePath, array);
      } else {
        array.add(line);
      }
    }
    in.close();
  }

  public String getPath() {
    return path;
  }

  protected String path = "(no file)";
}
