/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.util.*;

public class PolygonSymbol extends LineSymbol {

  public void setParams(Properties props, HashMap map) 
    throws FormatException {

    String fillColorParam = props.getOneString(
      "POLYGON_SYMBOL", map, "FILL_COLOR", null, false); 
    if (fillColorParam != null)
      fillColor = Symbol.parseColor(fillColorParam);

    super.setParams(props, map);
  }

  public void setDefaultParams() {

    fillColor = new Color(255, 255, 204);
 
    super.setDefaultParams();
  }

  public void render(Object shape, Graphics2D g) {

    if (fillColor != null) {
      g.setColor(fillColor);
      g.fill((Shape) shape);
    }

    super.render(shape, g);
  }

  public Image getLegendSymbol() {

    if (legendSymbol == null)
      createLegendSymbol();

    return legendSymbol;
  }

  private void createLegendSymbol() {

    legendSymbol =
      new BufferedImage(20, 20, BufferedImage.TYPE_INT_ARGB);
    Graphics2D graphics = legendSymbol.createGraphics();

    Rectangle box = new Rectangle(2, 2, 16, 16);
    render(box, graphics);
    if ((! drawBack) && (! drawFore)) {
      graphics.setColor(Color.black);
      graphics.drawRect(2, 2, 16, 16);
    }

    graphics.dispose();
  }

  private BufferedImage legendSymbol;
  private Color fillColor;
}






