package pms;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.io.IOException;
import java.util.*;

import pms.tools.*;

public class PointSymbol extends Symbol {

  public void setParams(Properties props, HashMap map) 
    throws FormatException {

    String path = props.getOneString(
      "POINT_SYMBOL", map, "ICON", null, true);
    path = StringTools.resolvePath(props.getPath(), path);
    try {
      icon = loader.createImage(path);   
    } catch (IOException e) {
      throw new FormatException("Could not load image from " + path);
    }

    setOffsets();
    isRenderable = true;
  }

  public void setDefaultParams() {

    icon = new BufferedImage(4, 4, BufferedImage.TYPE_INT_ARGB);
   
    setOffsets();
  }

  private void setOffsets() {
 
    dx = icon.getWidth(loader) / 2;
    dy = icon.getHeight(loader) / 2;
  }

  public void render(Object shape, Graphics2D g) {

    if (icon == null || ! isRenderable) return;
    
    Point2D.Float p = (Point2D.Float) shape;
    g.drawImage(icon, (int) p.x - dx, (int) p.y - dy, loader);
  }

  public Image getLegendSymbol() {

    return icon;
  }

  private ImageLoader loader = new ImageLoader();;
  private Image icon;
  private boolean isRenderable = false;
  private int dx, dy;
}





