/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;

public class LineSymbol extends Symbol {

  public void setParams(Properties props, HashMap map) 
    throws FormatException {

    String foreStrokeParam = props.getOneString(
      "LINE_SYMBOL", map, "FORE_STROKE", null, false); 
    if (foreStrokeParam != null)
      foreStroke = parseStroke(foreStrokeParam);

    String foreStrokeColorParam = props.getOneString(
      "LINE_SYMBOL", map, "FORE_STROKE_COLOR", null, false); 
    if (foreStrokeColorParam != null)
      foreStrokeColor = Symbol.parseColor(foreStrokeColorParam);

    if ((foreStroke != null) && (foreStrokeColor != null))
      drawFore = true;

    String backStrokeParam = props.getOneString(
      "LINE_SYMBOL", map, "BACK_STROKE", null, false); 
    if (backStrokeParam != null)
      backStroke = parseStroke(backStrokeParam);

    String backStrokeColorParam = props.getOneString(
      "LINE_SYMBOL", map, "BACK_STROKE_COLOR", null, false); 
    if (backStrokeColorParam != null)
      backStrokeColor = Symbol.parseColor(backStrokeColorParam);

    if ((backStroke != null) && (backStrokeColor != null))
      drawBack = true;
  }

  public void setDefaultParams() {

    foreStroke = new BasicStroke();
    foreStrokeColor = new Color(0, 0, 0);
    drawFore = true;

    drawBack = false;
  }

  public void render(Object shape, Graphics2D g) {

    if (drawBack) {
      g.setColor(backStrokeColor);
      g.setStroke(backStroke);
      g.draw((Shape) shape);
    }

    if (drawFore) {
      g.setColor(foreStrokeColor);
      g.setStroke(foreStroke);
      g.draw((Shape) shape);
    }
  }

  public Image getLegendSymbol() {

    return null;
  }

  private BasicStroke parseStroke(String args) throws FormatException {

    try {

      StringTokenizer s = new StringTokenizer(args, ",");

      float width = Float.parseFloat(s.nextToken().trim());
      Class stroke = (new BasicStroke()).getClass();
      int cap = stroke.getField(s.nextToken().trim()).getInt(null);
      int join = stroke.getField(s.nextToken().trim()).getInt(null);
      float miter = Float.parseFloat(s.nextToken().trim());

      if (! s.hasMoreTokens())
        return new BasicStroke(width, cap, join, miter);

      float[] dash = new float[s.countTokens()];
      for (int i = 0; i < dash.length; i++)
        dash[i] = Float.parseFloat(s.nextToken().trim());

      return new BasicStroke(width, cap, join, miter, dash, 0);

    } catch (Exception e) {
      throw new FormatException("Unable to parse stroke: " + args);
    }
  }

  protected boolean drawFore = false;
  protected boolean drawBack = false;

  private BasicStroke foreStroke;
  private Color foreStrokeColor;
  private BasicStroke backStroke;
  private Color backStrokeColor;
}
