package pms;

import java.awt.*;
import java.awt.image.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.util.*;

public class Labeler {

  /** 
    Inset the extent to avoid labels at the very edge of the image
   **/
  public Labeler(Rectangle extent) {

    extent.x -= Label.PAD;
    extent.y -= Label.PAD;
    extent.width += Label.PAD * 2;
    extent.height += Label.PAD * 2;
    this.extent = extent;
  }

  /** 
    Add a label anchored at the specified point with a specified priority
  **/
  public void add(Label label, int priority) {

    ranking.put(new Integer(Integer.MAX_VALUE - priority), label);
  }

  /**
    Draw up to max number of labels to a graphics context
  **/
  public void draw(Graphics2D g, int max) {
  
    if (ranking.size() < max) max = ranking.size();

    // Set up the mask to detect overlapping labels
    mask = new Label[max];
    maskCount = 0;
    iterator = ranking.values().iterator();

    FontRenderContext frc = g.getFontRenderContext();

    while ((maskCount < max) && iterator.hasNext()) {
      Label label = (Label) iterator.next();
      label.setMask(mask);
      label.getVisibleExtents(extent, frc);
      place(label);
    }

    try {
      for (int i = 0; i < maskCount; i++)
        mask[i].draw(g);
    } catch (ArrayIndexOutOfBoundsException e) {
      e.printStackTrace();
    }
  }

  /**
    Attempts to place labels while reshuffling already placed labels
    if necessary
  **/
  private void place(Label label) {

    while (label.nextExtent()) {
      Label overlappingLabel = label.getOverlappingLabel();
      if (overlappingLabel != null) {
        if (overlappingLabel.freeExtent(label.getExtent())) {
          overlappingLabel = null;
        }
      }
      if (overlappingLabel == null) {
        try {
          mask[maskCount++] = label;
        } catch (ArrayIndexOutOfBoundsException e) {
          e.printStackTrace();
        }
        break;
      }
    }
  }

  private Rectangle extent;
  // Store labels in the mask in priority order
  private TreeMap ranking = new TreeMap();
  private Hashtable fonts = new Hashtable();
  private Label[] mask;
  private int maskCount;
  private Iterator iterator;

  private static Font defaultFont = new Font("sansserif", Font.PLAIN, 10);
}
