/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms;

import java.awt.*;
import java.awt.font.*;

public interface Label {

  public void setLocation(Object shape);
  public void setText(String text, Font font);
  public void setMask(Label[] mask);

  public Label getOverlappingLabel();
  public boolean freeExtent(Rectangle extent);
  public void getVisibleExtents(Rectangle extent, FontRenderContext frc);

  public Rectangle getExtent();  
  public boolean nextExtent();

  public void draw(Graphics g);

  public static int PAD = 5;
}
