package pms;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

import javax.swing.*;

import pms.tools.*;

public class ImageLayer {

  public ImageLayer(String path) {
    
    image = new ImageIcon(StringTools.setExtension(path, "gif")).getImage();
    world = new ImageProperties(StringTools.setExtension(path, "image"));
  }

  public void draw(Graphics g, Extent geoExtent) {
    
    // clip the portion of the image that matches the extent
    Extent imageExtent = world.getExtent();

    // use the geoExtent's affine transform to map the image extent
    // to pixel space
    //   int clipX
    // draw it scaled to fit the graphics context
    Rectangle clipBnd = g.getClipBounds();
    g.drawImage(image, clipBnd.x, clipBnd.y, 
      clipBnd.width, clipBnd.height, loader);
  }

  Image image;
  ImageLoader loader = new ImageLoader();
  ImageProperties world;
}

  
