/** 

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms;

import java.io.*;
import java.util.*;

import pms.tools.*;

public class ChartProperties {

  public ChartProperties(LayerProperties props, HashMap params) 
    throws FormatException {

    chartType = 
      props.getOneString("CHART", params, "CHART_TYPE", null, true);
    legendType = 
      props.getOneString("CHART", params, "LEGEND_TYPE", null, true);
    title = 
      props.getOneString("CHART", params, "TITLE", "-", false);
    subtitlePrefix = 
      props.getOneString("CHART", params, "SUBTITLE_PREFIX", "-", false);

    subtitleField = 
      props.getOneString("CHART", params, "SUBTITLE_FIELD", "-", false);
    if (subtitleField != null)
      props.peekAttribute("CHART", subtitleField, true);

    maxScaleHint = 
      props.getOneString("CHART", params, "MAX_SCALE_HINT", "0", false);
    maxScaleHint = Integer.toString(StringTools.toInt(maxScaleHint));

    ArrayList classBlocks = props.getAllMaps("CHART", params, "CLASS", true);

    for (Iterator i = classBlocks.iterator(); i.hasNext();) {

      HashMap classBlock = (HashMap) i.next();

      String field = 
        props.getOneString("CLASS", classBlock, "FIELD", null, true);
      props.peekAttribute("CHART", field, true);
    
      String label = 
        props.getOneString("CLASS", classBlock, "LABEL", "-", false);
      String color = 
        props.getOneString("CLASS", classBlock, "COLOR", "0,0,0", false);

      fields.add(field);
      labels.add(label);
      colors.add(color);
    }

    parseParam();
  }

  public String getParam() {

    return param;
  }

  private void parseParam() {

    param = chartType + "|" + legendType + "|" + maxScaleHint + "|" +
      title + "|" + subtitlePrefix + "|" + subtitleField;

    for (int i = 0; i < fields.size(); i++) {

      param += "|" + fields.get(i) + "|" + labels.get(i) + "|" + colors.get(i);
    }
  }

  private String chartType;
  private String legendType;
  private String title;
  private String subtitlePrefix;
  private String subtitleField;
  private String maxScaleHint;

  private String param = null;

  private ArrayList labels = new ArrayList();
  private ArrayList colors = new ArrayList();
  private ArrayList fields = new ArrayList();

  public final static String[] chartTypes = { "BAR", "PIE" };
  public final static String[] chartLegendTypes = { "CHART", "KEY" };
}
