/** 

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms;

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.net.*;
import java.util.*;

import org.apache.log4j.Category;

import pms.tools.*;
import com.acme.jpm.encoders.GifEncoder;

public class Carta {

  private static Category log = Category.getInstance(Carta.class.getName());

  public void writeImage(OutputStream out) throws IOException {

    Debug.assertNotNull("Carta.writeImage()", "out", out);
    GifEncoder encoder = new GifEncoder(image, out);
    encoder.encode();
  }

  public BufferedImage getImage() {
    return image;
  }

  public Carta(CartaProperties props) {

    this.props = props;
  }

  public Carta(String path) throws IOException {

    props = new CartaProperties(path);
  }

  public void render() throws IOException {

    view = new View(props.getAbsoluteViewPath());   
    Extent geoExtent = props.getExtent();
    log.info("Rendering " + geoExtent);
    image = view.render(geoExtent);
  }

  public ArrayList getLayers() {

    return view.getLayers();
  }

  public Report[] identify() throws IOException {

    view = new View(props.getAbsoluteViewPath());   
    Extent geoExtent = props.getExtent();

    double x = geoExtent.x + geoExtent.width / 2;
    double y = geoExtent.y - geoExtent.height / 2;
    double tolerance = geoExtent.getPixelSize() * 25;

    return view.identify(geoExtent.getScale(), x, y, tolerance);
  }

  public void flush() {
    image.flush();
  }
    
  public static void main(String[] args) {

    Debug.checkVersion("1.2");
    checkArgs(args);

    for (int i = 0; i < 1; i++) {
      renderToFile(args[0], args[1]);
    }

    System.exit(0);
  }

  public static void renderToFile(String propsFile, String outFile) {

    try {

      Debug.printMemory(); Debug.printTimeElapsed();

      Carta carta = new Carta(propsFile);
      Debug.printTimeElapsed();
      carta.render();
      Debug.printTimeElapsed();

      FileOutputStream out = new FileOutputStream(outFile);
      carta.writeImage(out);
      out.close();

      carta.flush();

      Debug.printMemory(); Debug.printTimeElapsed(); 

    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  public static void checkArgs(String[] args) {

    if (args.length < 2) {
      System.err.println(
        "Usage: java Map.Carta [parameters file] [output file]");
      System.exit(0);
    }
  }

  private BufferedImage image;
  private View view;
  private CartaProperties props;
}
