#!/bin/sh
#
# $Id: runopt.sh,v 1.1 2001/06/24 21:11:58 karl Exp $

# Shell script to startup an instrumented server for profiling

DISPLAY='an2:1.0'
export DISPLAY

TOMCAT_HOME=/home/karl/tools/jakarta-tomcat-3.2.1
JAVA_HOME=/usr/java
ORACLE_HOME=/opt/oracle/product/8.1.7

CLASSPATH=$ORACLE_HOME/jdbc/lib/jndi.zip:$ORACLE_HOME/jdbc/lib/classes12.zip
CLASSPATH=${CLASSPATH}:${JAVA_HOME}/lib/tools.jar
CLASSPATH=${CLASSPATH}:${JAVA_HOME}/jre/lib/rt.jar

LD_LIBRARY_PATH="$ORACLE_HOME/lib:$ORACLE_HOME/ctx/lib"
export LD_LIBRARY_PATH

for i in ${TOMCAT_HOME}/lib/* ; do
  if [ "$CLASSPATH" != "" ]; then
    CLASSPATH=${CLASSPATH}:$i
  else
    CLASSPATH=$i
  fi
done

# Backdoor classpath setting for development purposes when all classes
# are compiled into a /classes dir and are not yet jarred.
if [ -d ${TOMCAT_HOME}/classes ]; then
  CLASSPATH=${TOMCAT_HOME}/classes:${CLASSPATH}
fi

export CLASSPATH

#This is the path to OptimizeIt directory
OPTITDIR=/home/karl/tools/OptimizeItDemo

#Increase the GCOP value if you get some "GCOP buffer too small" errors
#(size is in Mb)
GCOPSIZE=1

#Port number used by OptimizeIt (1470 is default)
PORT=1470

LD_LIBRARY_PATH=${LD_LIBRARY_PATH:-.}:${OPTITDIR}/lib
export LD_LIBRARY_PATH
OI_PATH=$PATH
export OI_PATH

JAVA=$JAVA_HOME/bin/java

COMMAND="$JAVA -Xrunoii -DAUDIT=jni -DOPTITDIR=${OPTITDIR} -DOIDEMO=demo-463-522-667"

CLASSPATH=${CLASSPATH}:${OPTITDIR}/lib/optit.jar

$COMMAND -Dtomcat.home=${TOMCAT_HOME} -classpath $CLASSPATH intuitive.audit.Audit -port $PORT org.apache.tomcat.startup.Tomcat "$@"




