import java.awt.*;

public class TitleBar extends Rectangle {

  public TitleBar(Container container) {

    fm = container.getFontMetrics(font);

    x = 10;
    width = container.size().width - x - 10;

    y = 10;
    height = 10 + fm.getHeight() + 10;

    baseline = y + 10 + fm.getAscent();
  }

  public void paint(Graphics g) {

    int left = x + (width / 2) - (fm.stringWidth(title) / 2);

    g.setColor(Color.black);
    g.setFont(font);
    g.drawString(title, left, baseline);

  }

  public void setTitle(String title) {

    this.title = title;
  }

  private String title = "";

  private Font font = new Font("SansSerif", Font.BOLD, 14);
  private FontMetrics fm;
  private int baseline;
}
