import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class SymbolCache {

  public static void setApplet(Applet app) {

    applet = app;

    URL codeBase = applet.getCodeBase();

    try {
      baseUrl = new URL(codeBase.getProtocol(), codeBase.getHost(),
        codeBase.getPort(), codeBase.getFile());
    } catch (MalformedURLException e) {
      e.printStackTrace();
    }

    tracker = new MediaTracker(applet);
  }

  public static Image getSymbol(String layerPath, int index) 
    throws IOException {
    
    String spec = "Symbol?LAYER=" + layerPath + "&INDEX=" + index;
    
    Image symbol = (Image) cache.get(spec);

    if (symbol == null) {

      URL symbolUrl = null;

      try {
        symbolUrl = new URL(baseUrl, spec);
      } catch (MalformedURLException e) {
        e.printStackTrace();
      }

      System.err.println("Not cached. Loading " + symbolUrl);
      symbol = applet.getImage(symbolUrl);
      if (symbol != null) {
	tracker.addImage(symbol, 0);
	cache.put(spec, symbol);
      } else {
	throw new IOException("Failed to load symbol" + symbolUrl);
      }
    }

    return symbol;
  }

  public static void loadSymbols() {

    try {
      tracker.waitForAll();
    } catch (InterruptedException e) {}
    tracker = new MediaTracker(applet);
  }

  private static Applet applet;
  private static MediaTracker tracker;
  private static URL baseUrl;
  private static Hashtable cache = new Hashtable();
}
