import java.awt.*;

public class StatusBar extends Rectangle {

  public StatusBar(Container container) {

    fm = container.getFontMetrics(font);

    x = 10;
    width = container.size().width - x - 10;

    height = 10 + fm.getAscent() + fm.getDescent() + 10;
    y = container.size().height - 10 - height;

    baseline = y + 10 + fm.getAscent();
  }

  public void paint(Graphics g) {

    int left = x + (width / 2) - (fm.stringWidth(status) / 2);

    g.setColor(Color.black);
    g.setFont(font);
    g.drawString(status, left, baseline);

    g.drawRect(x, y, width, height);
  }

  public void setStatus(String status) {

    this.status = status;
  }

  private String status = "";

  private Font font = new Font("SansSerif", Font.PLAIN, 12);
  private FontMetrics fm;
  private int baseline;
}
