import java.awt.*;
import java.util.*;

/**

Format of the parameter string:

[ left[%], top[%] ] ; [ right[%], bottom[%] ]

Numbers may be specified as absolute pixel values or as percentages.
In both cases the origin is the top-left corner of the container.

If one of the corners is omitted, the preferred size of the component
is used and the component is anchored at the specified point.

If an empty string is passed as the parameter, the component is not
laid out.

**/

public class RatioLayout {

  public RatioLayout(int inset) {

    this.inset = inset;
  }

  public void addLayoutComponent(String param, Rectangle comp) {

    params.addElement(param.trim());
    components.addElement(comp);
  }

  public void removeLayoutComponent(Rectangle comp) {

    int i = components.indexOf(comp);
    if (i != -1) {
      params.removeElementAt(i);
      components.removeElementAt(i);
    }
  }

  public void layoutContainer(Container target) {

    dimen = target.size();
    dimen.width -= inset * 2;
    dimen.height -= inset * 2;

    for (int i = 0; i < params.size(); i++) {

      Rectangle comp = (Rectangle) components.elementAt(i);
      String param = (String) params.elementAt(i);
      if (param.equals("")) continue;
      layoutComponent(param, comp);
    }
  }

  private void layoutComponent(String param, Rectangle comp) {

    StringTokenizer st = new StringTokenizer(param, " \t;,");
    int left = -1, top = -1, right = -1, bottom = -1;

    if (! param.startsWith(";")) {
      left = getAbs(st.nextToken(), dimen.width) + inset;
      top = getAbs(st.nextToken(), dimen.height) + inset;
    }
    if (! param.endsWith(";")) {
      right = getAbs(st.nextToken(), dimen.width) - inset;
      bottom = getAbs(st.nextToken(), dimen.height) - inset;
    }

    if (left == -1) left = right - comp.width + inset;
    if (top == -1) top = bottom - comp.height + inset;
    if (right == -1) right = left + comp.width - inset;
    if (bottom == -1) bottom = top + comp.height - inset;

    comp.reshape(left + inset, top + inset, right - left, bottom - top);
  }
    
  private int getAbs(String token, int denom) {

    int abs;

    if (token.endsWith("%")) {
      token = token.substring(0, token.length() - 1);
      float pct = (float) Integer.parseInt(token) / (float) 100;
      abs = (int) (pct * denom);
    } else {
      abs = Integer.parseInt(token);
    }
      
    return abs;
  }

  private Vector params = new Vector(10);
  private Vector components = new Vector(10);
  private int inset = 0;
  private Dimension dimen;
}
