import java.awt.*;
import java.io.*;
import java.util.*;

public class PolygonLayer extends Layer {

  public PolygonLayer(Hashtable params) throws IOException {

    super(params);
  }

  public void readFeature(DataInputStream in) throws IOException {

    int rings = in.readShort();

    Polygon[] polys = new Polygon[rings];
    Rectangle[] bnds = new Rectangle[rings];

    for (int i = 0; i < rings; i++) {
    
      Point min = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
      Point max = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);

      int vertices = in.readShort();
      int[] xcoords = new int[vertices];
      int[] ycoords = new int[vertices];
      for (int j = 0; j < vertices; j++) {

        xcoords[j] = in.readShort();
        ycoords[j] = in.readShort();
        if (xcoords[j] < min.x) min.x = xcoords[j];
        if (ycoords[j] < min.y) min.y = ycoords[j];
        if (xcoords[j] > max.x) max.x = xcoords[j];
        if (ycoords[j] > max.y) max.y = ycoords[j];
      }
      int w = max.x - min.x;
      int h = max.y - min.y;
      if (w * h < 100) continue;
      polys[i] = new Polygon(xcoords, ycoords, vertices);
      bnds[i] = new Rectangle(min.x, min.y, max.x - min.x, max.y - min.y);
    }

    String[] rec = readAttributes(in);
    addFeature(polys, bnds, rec);
  }

  public void addFeature(Polygon[] polys, Rectangle[] bnds, String[] rec) {

    for (int i = 0; i < polys.length; i++) {
      if (polys[i] == null) continue;
      polygons.put(polys[i], rec);
      bounds.put(polys[i], bnds[i]);
    }
  }

  public boolean getFeatureAt(int x, int y) {

    for (Enumeration e = bounds.keys(); e.hasMoreElements();) {

      Polygon poly = (Polygon) e.nextElement();
      Rectangle bound = (Rectangle) bounds.get(poly);

      if (bound.inside(x, y)) {
        if (poly.inside(x, y)) {
          record = (String[]) polygons.get(poly);
          return true;
        }
      }
    }
    return false;
  }

  private Hashtable polygons = new Hashtable();
  private Hashtable bounds = new Hashtable();
}




