import java.awt.*;
import java.io.*;
import java.util.*;

public class PointLayer extends Layer {

  public PointLayer(Hashtable params) throws IOException {

    super(params);
  }  

  public void readFeature(DataInputStream in) throws IOException {

    int x = in.readShort();
    int y = in.readShort();
    String[] rec = readAttributes(in);

    index.add(x, y, rec);
  }

  public boolean getFeatureAt(int x, int y) {

    record = index.search(x, y);

    return (record == null) ? false : true;
  }

  private PointIndex index = new PointIndex();
}
