import java.awt.*;
import java.io.*;
import java.util.*;

public class PointIndex {

  private Hashtable xy = new Hashtable();
  private Hashtable yx = new Hashtable();
  private String[] record;

  private static int radius = 10;
 
  public void add(int x, int y, String[] record) {

    if (record == null) return;

    Integer X = new Integer(x);
    Integer Y = new Integer(y);

    Hashtable col;
    col = (Hashtable) xy.get(X);
    if (col == null) {
      col = new Hashtable();
      xy.put(X, col); 
    }
    col.put(Y, record);

    Hashtable row;
    row = (Hashtable) yx.get(Y); 
    if (row == null) {
      row = new Hashtable();
      yx.put(Y, row); 
    }
    row.put(X, "");
  }

  public String[] search(int x, int y) {
  
    int sign = 1;
  
    if (lookup(x,y)) { return record; }
  
    for (int i = 1; i <= radius; i++) {
      
      Hashtable row = (Hashtable) yx.get(new Integer(y));
      if (row != null) {
        for (int j = 1; j <= i; j++) {
          x += 1 * sign;
          if (lookup(x,y)) { return record; }
        }
      } else { 
        x += i * sign; 
      }
  
      Hashtable col = (Hashtable) xy.get(new Integer(x));
      if (col != null) {
        for (int j = 1; j <= i; j++) {
          y += 1 * sign;
          if (lookup(x,y)) { return record; }
        }
      } else { 
        y += i * sign; 
      }
  
      sign *= -1;
    }
  
    Hashtable row = (Hashtable) yx.get(new Integer(y));
    if (row != null) {
      for (int j = 1; j <= radius; j++) {
        x += 1 * sign;
        if (lookup(x,y)) { return record; }
      }
    }
  
    return null;
  }
  
  private boolean lookup(int px, int py) {

    Integer x = new Integer(px);
    Integer y = new Integer(py);
  
    record = null;
  
    Hashtable col = (Hashtable) xy.get(x);
    if (col == null) { return false; }
  
    record = (String[]) col.get(y);
    if (record == null) { return false; }
  
    return true;
  }
}
