/**
 * Defines objects that report messages to the user for display in the
 * applet status bar.  
 *
 * The applet is the final recipient of all messages, but some objects
 * that report messages may not have a reference to the applet object.
 * This interface addresses that problem by allowing messengers to
 * be chained together, passing messages along the chain to the applet.
 **/
public interface Messenger {

  public void setMessage(String message, int type);

  public static int PROGRESS = 0;
  public static int SUCCESS = 1;
  public static int ERROR = 2;
}
