import java.awt.*;
import java.io.IOException;
import java.util.*;

public class MapView extends Rectangle {

  public MapView(Container container, 
    int top, double xFactor, double yFactor) {

    Dimension d = container.size();

    x = 10;
    width = (int) (d.width * xFactor) - 10; 

    y = top;
    height = (int) (d.height * yFactor);
  }

  public void paint(Graphics g) {

    if (image != null)
      g.drawImage(image, x, y, container);
    g.setColor(Color.black);
    g.drawRect(x, y, width, height);
  }

  public void setImage(Image image) {

    this.image = image;
  }

  public PolygonLayer getPanLayer() throws IOException {
    
    panLayer = new PolygonLayer(new Hashtable());
    Vector fields = new Vector();
    fields.addElement("direction");
    fields.addElement("param");
    panLayer.setFields(fields);
    panLayer.setLabelField("direction");
    panLayer.setHint("Click now to move map");

    Polygon[] polygons = new Polygon[1];
    Rectangle[] bounds = new Rectangle[1];

    int mx = width / 2 - 7;
    int[] xp = { 5, 5, 5, mx, width - 19, width - 19, width - 19, mx };
    int my = height / 2 - 7;
    int[] yp = { 5, my, height - 19, height - 19, height - 19, my, 5, 5 };
    String[] dp = { "Northwest", "West", "Southwest", "South", "Southeast",
		    "East", "Northeast", "North" };
    String[] pp = { "-0.65,0.65", "-0.65,0", "-0.65,-0.65", "0,-0.65",
		    "0.65,-0.65", "0.65,0", "0.65,0.65", "0,0.65" };
  
    for (int i = 0; i < 8; i++) {
      bounds[0] = new Rectangle(xp[i], yp[i], 14, 14);
      polygons[0] = rectToPoly(bounds[0]);
      String[] record = { dp[i], pp[i] };
      panLayer.addFeature(polygons, bounds, record);
    }
    return panLayer;
  }

  public String getPanParam() {

    return panLayer.getValue(1);
  }

  private Polygon rectToPoly(Rectangle r) {
  
    int[] xp = { r.x, r.x, r.x + r.width, r.x + r.width };
    int[] yp = { r.y, r.y + r.height, r.y + r.height, r.y };

    return new Polygon(xp, yp, 4);
  }

  PolygonLayer panLayer;
  Container container;
  Image image;
}
