import java.awt.*;
import java.util.*;

public class LegendView extends Rectangle {

  public LegendView(Container container, int top, 
    int bottom, double xFactor) {

    this.container = container;
    Dimension d = container.size();

    x = (int) (d.width * xFactor) + 10;
    width = d.width - x - 10; 

    y = top;
    height = bottom - top;

    titleFont = Locale.getFont(2);
    classFont = Locale.getFont(3);
    titleFM = container.getFontMetrics(titleFont);
    classFM = container.getFontMetrics(classFont);
  }

  public void paint(Graphics g) {

    if (buffer != null)
      g.drawImage(buffer, x, y, container);

    g.setColor(Color.black);
    g.drawRect(x, y, width, height);

  }

  public void setLayers(Layer[] layers) {

    buffer = container.createImage(width, height);
    g = buffer.getGraphics();

    g.setColor(Color.white);
    g.fillRect(0, 0, width, height);
    g.setColor(Color.black);

    int top = 10;

    for (int i = 0; i < layers.length; i++) {
      if (layers[i] == null) continue;
      top = drawLayer(layers[i], top);
    }
 
    g.dispose();
  }

  private int drawLayer(Layer layer, int top) {

    if (layer == null) System.err.println("Layer is null");

    top = drawTitle(layer.getTitle(), layer.getSubtitle(), top);

    Vector classes = layer.getClasses();
    if (classes == null) System.err.println(
      "Classes is null: " + layer.getPath());

    if (classes.isEmpty()) return top;

    Vector symbols = layer.getSymbols();

    calcClassHeight(symbols);

    int left = 10;
    int classRows = (int) Math.ceil((float) classes.size() / (float) 2);

    int classWidth = (width - 10 * 2) / 2;
    int classTop = top;
    
    for (int i = 0; i < classes.size(); i++) {
      
      if ((i > 0) && (i % classRows == 0)) {
        top = classTop;
        left += classWidth;
      }

      top += classHeight;
      drawClass((Image) symbols.elementAt(i), (String) classes.elementAt(i), 
        left, top);
    }

    return top + classHeight * classRows;
  }

  private int drawTitle(String title, String subtitle, int top) {

    g.setFont(titleFont);

    if ((title != null) && (! title.equals(""))) {
      g.drawString(title, 10, top + titleFM.getAscent());
      top += titleFM.getHeight() * 1.5;
    }

    return top;
  }

  private void drawClass(Image symbol, String label, int left, int bottom) {

    int baseline = bottom - classFM.getDescent();

    g.setFont(classFont);
    g.drawString(label, left + symbol.getWidth(container) + 10, baseline);

    if (symbol == null) return;

    int symTop = bottom - symbol.getHeight(container);
    g.drawImage(symbol, left, symTop, container);
  }

  private void calcClassHeight(Vector symbols) {

    classHeight = 0;

    for (Enumeration e = symbols.elements(); e.hasMoreElements();) {

      int symHeight = ((Image) e.nextElement()).getHeight(container);
      if (symHeight > classHeight)
        classHeight = symHeight;
    }

    classHeight = Math.max(classFM.getHeight(), classHeight);
  }

  private Container container;
  private Image buffer;

  private Font titleFont;
  private FontMetrics titleFM;
  private Font classFont;
  private FontMetrics classFM;

  private int classHeight;

  private Graphics g;
}
