import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class Layer {

  public static Layer create(Hashtable params) throws IOException {

    String type = (String) params.get("TYPE");
    if (type == null) return new Layer(params);
    
    Layer layer = null;
    type = type.toUpperCase();

    if (type.equals("POINT"))
      layer = new PointLayer(params);
    else if (type.equals("POLYGON"))
      layer = new PolygonLayer(params);
    else layer = new Layer(params);

    return layer;
  }

  public Layer(Hashtable params) throws IOException {

    this.params = params;

    String classParam = (String) params.get("CLASSES");

    System.err.println("Class params: " + classParam);

    if (classParam != null) {

      int index = 0;
      StringTokenizer s = new StringTokenizer(classParam, "|");
      while (s.hasMoreTokens()) {

        classes.addElement(s.nextToken());
        symbols.addElement(SymbolCache.getSymbol(getPath(), index++));
      }
    }
  }

  public String getLabel() {

    return ((record != null) && (labelCol > -1)) ? 
      labelPrefix + " " + record[labelCol] : null;
  }

  public boolean getFeatureAt(int x, int y) {

    return false;
  }

  public String getPath() {

    return (String) params.get("PATH");
  }

  public Vector getClasses() {

    return classes;
  }

  public Vector getSymbols() {

    return symbols;
  }

  public String getTitle() {

    return (String) params.get("TITLE");
  }

  public String getSubtitle() {

    return (String) params.get("SUBTITLE");
  }

  public String getValue(int index) {

    return (record != null) ? record[index] : null;
  }

  public String[] getRecord() {

    return record;
  }

  public void setChart(ChartView chartView) {

    if (chartType == null) return;
    if (record == null) return;
    double[] values = (double[]) chartValues.get(record);
    if (values == null) return;
    String chartSubtitle = chartSubtitlePrefix;
    if (chartSubtitleCol > -1)
      chartSubtitle += " " + Tools.titleCase(record[chartSubtitleCol]);

    chartView.setChart(chartTitle, chartSubtitle, chartClassLabels,
      chartClassColors, values, chartType, chartLegendType, chartMaxScaleHint);
  }

  public boolean setReports(Popup reportMenu) {

    String reportParams = (String) params.get("REPORTS");
    if (reportParams == null) return false;
   
    StringTokenizer s = new StringTokenizer(reportParams, "|");

    while (s.hasMoreTokens()) {

      StringTokenizer t = new StringTokenizer(s.nextToken(), "+");

      String prefix = t.nextToken();
      if (prefix.equals("-")) prefix = "";
      String labelField = t.nextToken();
      int labelCol = fields.indexOf(labelField);
      if (labelCol == -1) continue;
      String label = prefix + " " + record[labelCol];

      String url = parseReportURL(t);
      if (url == null) continue;
      reportMenu.addItem(label, MapApplet.SHOW_REPORT, url);
    }
    return true;
  }

  private String parseReportURL(StringTokenizer t) {

    String url = t.nextToken() + "?";

    while (t.hasMoreTokens()) {
      String queryField = t.nextToken();
      String tableField = t.nextToken();
      int tableCol = fields.indexOf(tableField);
      if (tableCol == -1) return null;
      url += queryField + "=" + record[tableCol];
      if (t.hasMoreTokens()) url += "&";
    }

    return url;
  }

  public void setFields(String header) {

    StringTokenizer s = new StringTokenizer(header, "|");

    while (s.hasMoreTokens())
      fields.addElement(s.nextToken());

    String labelParam = (String) params.get("LABEL");
    if (labelParam != null) {

      s = new StringTokenizer(labelParam, "|");

      labelPrefix = s.nextToken();
      if (labelPrefix.equals("-")) labelPrefix = "";

      String labelField = s.nextToken();
      if (labelField != null)
        labelCol = fields.indexOf(labelField);
    }

    parseChart();
  }

  public String getHint() {

    return hint;
  }

  public void setHint(String hint) {

    this.hint = hint;
  }

  public void setFields(Vector fields) {

    this.fields = fields;
  }

  public void setLabelField(String labelField) {
    labelCol = fields.indexOf(labelField);
  }

  private void parseChart() {

    String chartParam = (String) params.get("CHART");
    if (chartParam == null) return;
    
    StringTokenizer s = new StringTokenizer(chartParam, "|");

    chartType = s.nextToken();
    chartLegendType = s.nextToken();
    chartMaxScaleHint = Double.valueOf(s.nextToken()).doubleValue();

    chartTitle = s.nextToken();

    chartSubtitlePrefix = s.nextToken();
    if (chartSubtitlePrefix.equals("-"))
      chartSubtitlePrefix = "";

    String chartSubtitleField = s.nextToken();
    if (! chartSubtitleField.equals("-"))
      chartSubtitleCol = fields.indexOf(chartSubtitleField);

    int count = s.countTokens() / 3; 
    
    chartClassCols = new int[count];
    chartClassLabels = new String[count];
    chartClassColors = new Color[count];

    for (int i = 0; i < count; i++) {

      String classField = s.nextToken();
      chartClassCols[i] = fields.indexOf(classField);
      chartClassLabels[i] = s.nextToken();
      chartClassColors[i] = parseColor(s.nextToken());
    }
  }

  private void parseChartValues(String[] rec) {

    double[] values = new double[chartClassCols.length];

    for (int i = 0; i < values.length; i++) {
      String val = rec[chartClassCols[i]];
      if (val.equals("null")) val = "0";
      values[i] = Double.valueOf(val).doubleValue();
    }

    chartValues.put(rec, values);
  }

  public void readFeature(DataInputStream in) throws IOException {}

  protected String[] readAttributes(DataInputStream in) throws IOException {

    String attribs = in.readLine();
    StringTokenizer s = new StringTokenizer(attribs, "|");
    String[] rec = new String[s.countTokens()];

    for (int i = 0; s.hasMoreTokens(); i++) {
      rec[i] = s.nextToken();
    }

    if (chartType != null)
      parseChartValues(rec);

    return rec;
  }

  private Color parseColor(String rgb) {

    StringTokenizer s = new StringTokenizer(rgb, ",");
    int red = Integer.parseInt(s.nextToken());
    int green = Integer.parseInt(s.nextToken());
    int blue = Integer.parseInt(s.nextToken());

    return new Color(red, green, blue);
  }

  private Hashtable params = null;

  protected String hint = "Click now for popup menu";
  protected Vector fields = new Vector();

  protected String[] record = null;
  protected int labelCol = -1;
  protected String labelPrefix = "";

  private Vector classes = new Vector();
  private Vector symbols = new Vector();

  private String chartTitle;
  private String chartSubtitlePrefix;
  private int chartSubtitleCol = -1;
  private String chartType;
  private String chartLegendType;
  private double chartMaxScaleHint;

  private int[] chartClassCols;
  private String[] chartClassLabels;
  private Color[] chartClassColors;

  private Hashtable chartValues = new Hashtable();
}
