import java.awt.*;
import java.util.*;

public class Label extends Popup {

  public Label(Component component) {

    super(component, null);
  }
  
  protected void setItemColors(int index) {

    Item item = (Item) items.elementAt(index);
    item.unhighlightFillColor = Color.white;
  }

  public void setHintItem(int index) {

    hintItem = (Item) items.elementAt(index);
    hintItem.unhighlightFillColor = new Color(204,204,204);
  }

  public void setHint(String hint) {

    hintItem.label = hint;
    arrange();
  }

  public void paint(Graphics g) {

    if (! visible) return;

    for (Enumeration e = items.elements(); e.hasMoreElements();) {
      Item item = (Item) e.nextElement();
      item.paint(g);
    }

    g.setColor(Color.black);
    g.drawRect(x, y, width, height);
  }

  private Item hintItem;
}

