import java.awt.*;
import java.util.*;

public class DropDown extends Popup {

  public DropDown(Component component, Messenger messenger, 
    int x, int y, String label) {

    super(component, messenger);

    headItem.label = label;
    anchor = new Point(x, y);
    
    initHeadItem();
    arrange();
  }
  
  public boolean show(int x, int y, boolean constrain) {

    if (constrain && (constraint != null) && (! constraint.contains(x, y))) {
      visible = false;
      return false;
    }

    visible = true;

    return true;
  }

  protected void setItemColors(int index) {

    Item item = (Item) items.elementAt(index);
    item.unhighlightFillColor = Color.white;
  }

  public void paint(Graphics g) {

    drawBezel(headBounds, g);
    g.setColor(Color.black);
    g.drawLine(headBounds.x - 1, headBounds.y - 1, 
      headBounds.x - 1, headBounds.y - 1 + headBounds.height);
    g.drawLine(headBounds.x - 1, headBounds.y - 1, 
      headBounds.x - 1 + headBounds.width, headBounds.y - 1);

    int tmpX = x;
    x = headBounds.x;
    headItem.paint(g);
    drawArrow(g);
    x = tmpX;

    if (! visible) return;

    for (Enumeration e = items.elements(); e.hasMoreElements();) {
      Item item = (Item) e.nextElement();
      item.paint(g);
    }

    g.setColor(Color.black);
    g.drawRect(x, y, width, height);
  }

  protected void arrange() {

    super.arrange();

    setAnchor(anchor.x, anchor.y);
  }

  private void initHeadItem() {

    int headWidth = fm.stringWidth(headItem.label) + fm.getMaxAdvance() * 3;
    headItem.bounds.setBounds(0, 0 - itemHeight, headWidth, itemHeight);

    headBounds = new Rectangle();
    headBounds.x = (anchor.x + headWidth < component.size().width) ?
      anchor.x : anchor.x - headWidth;
    headBounds.y = anchor.y - itemHeight;
    headBounds.width = headWidth;
    headBounds.height = itemHeight;

    headItem.unhighlightFillColor = Color.white;

    setConstraint(headBounds);

    calcArrow();
  }

  private void calcArrow() {

    arrowBounds = new Rectangle(
      headBounds.x + headBounds.width - itemHeight + 1, 
      headBounds.y + 2, itemHeight - 2, itemHeight - 3);

    xArrow[0] = (arrowBounds.x + (arrowBounds.x + arrowBounds.width)) / 2;
    yArrow[0] = arrowBounds.y + arrowBounds.height - 5;

    xArrow[1] = arrowBounds.x + arrowBounds.width - 4;
    yArrow[1] = arrowBounds.y + 5;

    xArrow[2] = arrowBounds.x + 4;
    yArrow[2] = arrowBounds.y + 5;
  }

  private void drawArrow(Graphics g) {

    drawBezel(arrowBounds, g);
    g.setColor(lightBezelColor);
    g.fillRect(arrowBounds.x, arrowBounds.y, 
      arrowBounds.width, arrowBounds.height);

    g.setColor(Color.black);
    g.fillPolygon(xArrow, yArrow, 3);
  }

  private Item headItem = new Item();
  private Rectangle headBounds;
  private Rectangle arrowBounds;
  private int[] xArrow = new int[3];
  private int[] yArrow = new int[3];
}
