/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.xml.XMLWatchdog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMConfigurator
extends BasicConfigurator
implements Configurator {
    static final String CONFIGURATION_TAG = "log4j:configuration";
    static final String OLD_CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String DISABLE_OVERRIDE_ATTR = "disableOverride";
    static final String DISABLE_ATTR = "disable";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DOMConfigurator.class$("java.lang.String")) : class$java$lang$String};
    static final String dbfKey = "javax.xml.parsers.DocumentBuilderFactory";
    Hashtable appenderBag = new Hashtable();
    Properties props;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$spi$ErrorHandler;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;

    protected Appender findAppenderByReference(Element element) {
        String string = this.subst(element.getAttribute(REF_ATTR));
        Appender appender = (Appender)this.appenderBag.get(string);
        if (appender != null) {
            return appender;
        }
        Document document = element.getOwnerDocument();
        Element element2 = null;
        NodeList nodeList = document.getElementsByTagName(APPENDER_TAG);
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem(NAME_ATTR);
            if (string.equals(node2.getNodeValue())) {
                element2 = (Element)node;
                break;
            }
            ++n;
        }
        if (element2 == null) {
            LogLog.error("No appender named [" + string + "] could be found.");
            return null;
        }
        appender = this.parseAppender(element2);
        this.appenderBag.put(string, appender);
        return appender;
    }

    protected Appender parseAppender(Element element) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        LogLog.debug("Class name: [" + string + ']');
        try {
            Object obj = Class.forName(string).newInstance();
            Appender appender = (Appender)obj;
            PropertySetter propertySetter = new PropertySetter(appender);
            appender.setName(this.subst(element.getAttribute(NAME_ATTR)));
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    if (element2.getTagName().equals(PARAM_TAG)) {
                        this.setParameter(element2, propertySetter);
                    } else if (element2.getTagName().equals(LAYOUT_TAG)) {
                        appender.setLayout(this.parseLayout(element2));
                    } else if (element2.getTagName().equals(FILTER_TAG)) {
                        this.parseFilters(element2, appender);
                    } else if (element2.getTagName().equals(ERROR_HANDLER_TAG)) {
                        this.parseErrorHandler(element2, appender);
                    } else if (element2.getTagName().equals(APPENDER_REF_TAG)) {
                        String string2 = this.subst(element2.getAttribute(REF_ATTR));
                        if (appender instanceof AppenderAttachable) {
                            AppenderAttachable appenderAttachable = (AppenderAttachable)((Object)appender);
                            LogLog.debug("Attaching appender named [" + string2 + "] to appender named [" + appender.getName() + "].");
                            appenderAttachable.addAppender(this.findAppenderByReference(element2));
                        } else {
                            LogLog.error("Requesting attachment of appender named [" + string2 + "] to appender named [" + appender.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
                        }
                    }
                }
                ++n2;
            }
            propertySetter.activate();
            return appender;
        }
        catch (Exception exception) {
            LogLog.error("Could not create an Appender. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseErrorHandler(Element element, Appender appender) {
        ErrorHandler errorHandler = (ErrorHandler)OptionConverter.instantiateByClassName(this.subst(element.getAttribute(CLASS_ATTR)), class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = DOMConfigurator.class$("org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler, null);
        if (errorHandler != null) {
            PropertySetter propertySetter = new PropertySetter(errorHandler);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                String string;
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1 && (string = (element2 = (Element)node).getTagName()).equals(PARAM_TAG)) {
                    this.setParameter(element2, propertySetter);
                }
                ++n2;
            }
            propertySetter.activate();
            appender.setErrorHandler(errorHandler);
        }
    }

    protected void parseFilters(Element element, Appender appender) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        Filter filter = (Filter)OptionConverter.instantiateByClassName(string, class$org$apache$log4j$spi$Filter == null ? (class$org$apache$log4j$spi$Filter = DOMConfigurator.class$("org.apache.log4j.spi.Filter")) : class$org$apache$log4j$spi$Filter, null);
        if (filter != null) {
            PropertySetter propertySetter = new PropertySetter(filter);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                String string2;
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1 && (string2 = (element2 = (Element)node).getTagName()).equals(PARAM_TAG)) {
                    this.setParameter(element2, propertySetter);
                }
                ++n2;
            }
            propertySetter.activate();
            appender.addFilter(filter);
        }
    }

    protected void parseCategory(Element element, Hierarchy hierarchy) {
        Object object;
        Category category;
        String string = this.subst(element.getAttribute(NAME_ATTR));
        String string2 = this.subst(element.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(string2)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Category.");
            category = hierarchy.getInstance(string);
        } else {
            LogLog.debug("Desired category sub-class: [" + string2 + ']');
            try {
                object = Class.forName(string2);
                Method method = ((Class)object).getMethod("getInstance", ONE_STRING_PARAM);
                category = (Category)method.invoke(null, string);
            }
            catch (Exception exception) {
                LogLog.error("Could not retrieve category [" + string + "]. Reported error follows.", exception);
                return;
            }
        }
        object = category;
        synchronized (object) {
            boolean bl = OptionConverter.toBoolean(this.subst(element.getAttribute(ADDITIVITY_ATTR)), true);
            LogLog.debug("Setting [" + category.getName() + "] additivity to [" + bl + "].");
            category.setAdditivity(bl);
            this.parseChildrenOfCategoryElement(element, category, false);
        }
    }

    protected void parseRoot(Element element, Hierarchy hierarchy) {
        Category category;
        Category category2 = category = hierarchy.getRoot();
        synchronized (category2) {
            this.parseChildrenOfCategoryElement(element, category, true);
        }
    }

    protected void parseChildrenOfCategoryElement(Element element, Category category, boolean bl) {
        PropertySetter propertySetter = new PropertySetter(category);
        category.removeAllAppenders();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals(APPENDER_REF_TAG)) {
                    Element element3 = (Element)node;
                    Appender appender = this.findAppenderByReference(element3);
                    String string2 = this.subst(element3.getAttribute(REF_ATTR));
                    if (appender != null) {
                        LogLog.debug("Adding appender named [" + string2 + "] to category [" + category.getName() + "].");
                    } else {
                        LogLog.debug("Appender named [" + string2 + "] not found.");
                    }
                    category.addAppender(appender);
                } else if (string.equals(PRIORITY_TAG)) {
                    this.parsePriority(element2, category, bl);
                } else if (string.equals(PARAM_TAG)) {
                    this.setParameter(element2, propertySetter);
                }
            }
            ++n2;
        }
        propertySetter.activate();
    }

    protected Layout parseLayout(Element element) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        LogLog.debug("Parsing layout of class: \"" + string + "\"");
        try {
            Object obj = Class.forName(string).newInstance();
            Layout layout = (Layout)obj;
            PropertySetter propertySetter = new PropertySetter(layout);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                String string2;
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1 && (string2 = (element2 = (Element)node).getTagName()).equals(PARAM_TAG)) {
                    this.setParameter(element2, propertySetter);
                }
                ++n2;
            }
            propertySetter.activate();
            return layout;
        }
        catch (Exception exception) {
            LogLog.error("Could not create the Layout. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseRenderer(Element element, Hierarchy hierarchy) {
        String string = this.subst(element.getAttribute(RENDERING_CLASS_ATTR));
        String string2 = this.subst(element.getAttribute(RENDERED_CLASS_ATTR));
        this.addRenderer(hierarchy, string2, string);
    }

    protected void parsePriority(Element element, Category category, boolean bl) {
        String string = category.getName();
        if (bl) {
            string = ROOT_TAG;
        }
        String string2 = this.subst(element.getAttribute(VALUE_ATTR));
        LogLog.debug("Priority value for " + string + " is  [" + string2 + "].");
        if ("inherited".equals(string2)) {
            if (bl) {
                LogLog.error("Root priority cannot be inherited. Ignoring directive.");
            } else {
                category.setPriority(null);
            }
        } else {
            String string3 = this.subst(element.getAttribute(CLASS_ATTR));
            if (EMPTY_STR.equals(string3)) {
                category.setPriority(Priority.toPriority(string2));
            } else {
                LogLog.debug("Desired Priority sub-class: [" + string3 + ']');
                try {
                    Class<?> clazz = Class.forName(string3);
                    Method method = clazz.getMethod("toPriority", ONE_STRING_PARAM);
                    Priority priority = (Priority)method.invoke(null, string2);
                    category.setPriority(priority);
                }
                catch (Exception exception) {
                    LogLog.error("Could not create priority [" + string2 + "]. Reported error follows.", exception);
                    return;
                }
            }
        }
        LogLog.debug(string + " priority set to " + category.getPriority());
    }

    protected void setParameter(Element element, PropertySetter propertySetter) {
        String string = this.subst(element.getAttribute(NAME_ATTR));
        String string2 = element.getAttribute(VALUE_ATTR);
        string2 = this.subst(OptionConverter.convertSpecialChars(string2));
        propertySetter.setProperty(string, string2);
    }

    public static void configure(Element element) {
        DOMConfigurator dOMConfigurator = new DOMConfigurator();
        dOMConfigurator.parse(element, Category.getDefaultHierarchy());
    }

    public static void configureAndWatch(String string) {
        DOMConfigurator.configureAndWatch(string, 60000L);
    }

    public static void configureAndWatch(String string, long l) {
        XMLWatchdog xMLWatchdog = new XMLWatchdog(string);
        xMLWatchdog.setDelay(l);
        xMLWatchdog.start();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doConfigure(String string, Hierarchy hierarchy) {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        this.doConfigure(fileInputStream, hierarchy);
        Object var6_4 = null;
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            LogLog.error("Could not close [" + string + "].", iOException);
        }
        return;
        {
            catch (IOException iOException) {
                LogLog.error("Could not open [" + string + "].", iOException);
                Object var6_5 = null;
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    LogLog.error("Could not close [" + string + "].", iOException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                LogLog.error("Could not close [" + string + "].", iOException);
            }
            throw throwable;
        }
    }

    public void doConfigure(URL uRL, Hierarchy hierarchy) {
        try {
            this.doConfigure(uRL.openStream(), hierarchy);
        }
        catch (IOException iOException) {
            LogLog.error("Could not open [" + uRL + "].", iOException);
        }
    }

    public void doConfigure(InputStream inputStream, Hierarchy hierarchy) throws FactoryConfigurationError {
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            LogLog.debug("System property is :" + OptionConverter.getSystemProperty(dbfKey, null));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug("DocumentBuilderFactory is: " + documentBuilderFactory.getClass().getName());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            Exception exception = factoryConfigurationError.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", exception);
            throw factoryConfigurationError;
        }
        try {
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(inputStream);
            Class<?> clazz = this.getClass();
            URL uRL = clazz.getResource("/org/apache/log4j/xml/log4j.dtd");
            if (uRL == null) {
                LogLog.error("Could not find [log4j.dtd]. Used [" + clazz.getClassLoader() + "] class loader in the search.");
            } else {
                LogLog.debug("URL to log4j.dtd is [" + uRL.toString() + "].");
                inputSource.setSystemId(uRL.toString());
            }
            Document document = documentBuilder.parse(inputSource);
            this.parse(document.getDocumentElement(), hierarchy);
        }
        catch (Exception exception) {
            LogLog.error("Could not parse input stream [" + inputStream + "].", exception);
        }
    }

    public static void configure(String string) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(string, Category.getDefaultHierarchy());
    }

    public static void configure(URL uRL) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(uRL, Category.getDefaultHierarchy());
    }

    protected void parse(Element element, Hierarchy hierarchy) {
        String string = element.getTagName();
        if (!string.equals(CONFIGURATION_TAG)) {
            if (string.equals(OLD_CONFIGURATION_TAG)) {
                LogLog.warn("The <configuration> element has been deprecated.");
                LogLog.warn("Use the <log4j:configuration> element instead.");
            } else {
                LogLog.error("DOM element is - not a <log4j:configuration> element.");
                return;
            }
        }
        String string2 = this.subst(element.getAttribute(INTERNAL_DEBUG_ATTR));
        LogLog.debug("debug attribute= \"" + string2 + "\".");
        if (!string2.equals(EMPTY_STR) && !string2.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string2, true));
        } else {
            LogLog.debug("Ignoring debug attribute.");
        }
        String string3 = this.subst(element.getAttribute(CONFIG_DEBUG_ATTR));
        if (!string3.equals(EMPTY_STR) && !string3.equals("null")) {
            LogLog.warn("The \"configDebug\" attribute is deprecated.");
            LogLog.warn("Use the \"debug\" attribute instead.");
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string3, true));
        }
        String string4 = this.subst(element.getAttribute(DISABLE_OVERRIDE_ATTR));
        LogLog.debug("Disable override=\"" + string4 + "\".");
        if (!string4.equals(EMPTY_STR) && !string4.equals("null")) {
            hierarchy.overrideAsNeeded(string4);
        }
        String string5 = this.subst(element.getAttribute(DISABLE_ATTR));
        LogLog.debug("Disable =\"" + string5 + "\".");
        if (!EMPTY_STR.equals(string5) && !"null".equals(string5)) {
            hierarchy.disable(string5);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string6 = element2.getTagName();
                if (string6.equals(CATEGORY)) {
                    this.parseCategory(element2, hierarchy);
                } else if (string6.equals(ROOT_TAG)) {
                    this.parseRoot(element2, hierarchy);
                } else if (string6.equals(RENDERER_TAG)) {
                    this.parseRenderer(element2, hierarchy);
                }
            }
            ++n2;
        }
    }

    protected String subst(String string) {
        try {
            return OptionConverter.substVars(string, this.props);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogLog.warn("Could not perform variable substitution.", illegalArgumentException);
            return string;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

