/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.ObjectRenderer;

public class BasicConfigurator {
    public static final String DISABLE_OVERRIDE_KEY = "log4j.disableOverride";
    public static final String DISABLE_KEY = "log4j.disable";
    public static final String INHERITED = "inherited";
    static /* synthetic */ Class class$org$apache$log4j$or$ObjectRenderer;

    protected BasicConfigurator() {
    }

    protected void addRenderer(Hierarchy hierarchy, String string, String string2) {
        LogLog.debug("Rendering class: [" + string2 + "], Rendered class: [" + string + "].");
        ObjectRenderer objectRenderer = (ObjectRenderer)OptionConverter.instantiateByClassName(string2, class$org$apache$log4j$or$ObjectRenderer == null ? (class$org$apache$log4j$or$ObjectRenderer = BasicConfigurator.class$("org.apache.log4j.or.ObjectRenderer")) : class$org$apache$log4j$or$ObjectRenderer, null);
        if (objectRenderer == null) {
            LogLog.error("Could not instantiate renderer [" + string2 + "].");
            return;
        }
        try {
            Class<?> clazz = Class.forName(string);
            hierarchy.rendererMap.put(clazz, objectRenderer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLog.error("Could not find class [" + string + "].", classNotFoundException);
        }
    }

    public static void disable(String string) {
        Category.getDefaultHierarchy().disable(string);
    }

    public static void disable(Priority priority) {
    }

    public static void disableAll() {
        Category.getDefaultHierarchy().disable(Priority.FATAL);
    }

    public static void disableDebug() {
        Category.getDefaultHierarchy().disable(Priority.DEBUG);
    }

    public static void disableInfo() {
        Category.getDefaultHierarchy().disable(Priority.INFO);
    }

    public static void enableAll() {
        Category.getDefaultHierarchy().disable(Priority.INFO);
    }

    public static void configure() {
        Category category = Category.getRoot();
        category.addAppender(new ConsoleAppender(new PatternLayout("%r [%t] %p %c %x - %m%n")));
    }

    public static void configure(Appender appender) {
        Category category = Category.getRoot();
        category.addAppender(appender);
    }

    public static void resetConfiguration() {
        Category.defaultHierarchy.resetConfiguration();
    }

    public static void resetConfiguration(Hierarchy hierarchy) {
        hierarchy.resetConfiguration();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = OptionConverter.getSystemProperty(DISABLE_OVERRIDE_KEY, null);
        if (string != null) {
            Category.defaultHierarchy.setDisableOverride(string);
        } else {
            String string2 = OptionConverter.getSystemProperty(DISABLE_KEY, null);
            if (string2 != null) {
                Category.defaultHierarchy.disable(string2);
            }
        }
    }
}

