:: COPYOUT.BAT
::
:: Copies CHANGED files for the dbf2info utility package from a source directory
:: to a target directory.  For COPYOUT, this would be from d:\c\dbf2info to
:: d:\c-mirror\dbf2info.  COPYIN calls this with direction reversed.
::
@echo off
::
:: Make sure we got the args we need.
::
if "%1" == "" goto USAGE
if "%2" == "" goto USAGE
::
:: Make sure target directory exists.
::
if not exist %1\nul echo %1 does not exist.
if not exist %1\nul goto EXIT
::
:: Make sure source directory exists.
::
if not exist %2\nul echo %2 does not exist.
if not exist %2\nul goto EXIT
::
:: Do the main files.
::
echo Updating dbf2info files in %2 from %1...
call cmpcp %1\copyout        %2\copyout
call cmpcp %1\copyin         %2\copyin
call cmpcp %1\copyout.bat    %2\copyout.bat
call cmpcp %1\copyin.bat     %2\copyin.bat
call cmpcp %1\clip           %2\clip
call cmpcp %1\clip.unx       %2\clip.unx
call cmpcp %1\makefile       %2\makefile
call cmpcp %1\bcc\makefile   %2\bcc\makefile

call cmpcp %1\readme         %2\readme
call cmpcp %1\changes        %2\changes
call cmpcp %1\dbf2info.htm   %2\dbf2info.htm

call cmpcp %1\asc2info.c     %2\asc2info.c
call cmpcp %1\asc2info.hlp   %2\asc2info.hlp
call cmpcp %1\info2asc.c     %2\info2asc.c
call cmpcp %1\info2asc.hlp   %2\info2asc.hlp
call cmpcp %1\dbf2info.c     %2\dbf2info.c
call cmpcp %1\dbf2info.hlp   %2\dbf2info.hlp
call cmpcp %1\info2dbf.c     %2\info2dbf.c
call cmpcp %1\info2dbf.hlp   %2\info2dbf.hlp

call cmpcp %1\dbfitems.c     %2\dbfitems.c
call cmpcp %1\dbfitems.hlp   %2\dbfitems.hlp
call cmpcp %1\dbflist.c      %2\dbflist.c
call cmpcp %1\dbflist.hlp    %2\dbflist.hlp
call cmpcp %1\dbflook.c      %2\dbflook.c
call cmpcp %1\dbflook.hlp    %2\dbflook.hlp

call cmpcp %1\infoitem.c     %2\infoitem.c
call cmpcp %1\infoitem.hlp   %2\infoitem.hlp
call cmpcp %1\infolist.c     %2\infolist.c
call cmpcp %1\infolist.hlp   %2\infolist.hlp
call cmpcp %1\infolook.c     %2\infolook.c
call cmpcp %1\infolook.hlp   %2\infolook.hlp

call cmpcp %1\infodir.c      %2\infodir.c
call cmpcp %1\infodir.hlp    %2\infodir.hlp
call cmpcp %1\infodel.c      %2\infodel.c
call cmpcp %1\infodel.hlp    %2\infodel.hlp

call cmpcp %1\dbftouch.c     %2\dbftouch.c
call cmpcp %1\swaptest.c     %2\swaptest.c
goto EXIT
::
:USAGE
::
echo Usage: copyout [frompath] [topath]
echo eg, copyout d:\c\dbf2info d:\c-mirror\dbf2info
goto exit
::
:EXIT
::
