/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.UserDataSetHints;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.NullDataSet;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public final class PlotWith2DAxes
extends PlotWithAxes {
    private StackedSeriesLookup ssl = null;
    private int iMarginPercent = 0;
    private Bounds boPlotWithMargin = BoundsImpl.create(0.0, 0.0, 100.0, 100.0);

    public PlotWith2DAxes(IDisplayServer _ids, ChartWithAxes _cwa, RunTimeContext _rtc) throws IllegalArgumentException, ChartException {
        this.cwa = _cwa;
        this.ids = _ids;
        this.rtc = _rtc;
        this.ssl = new StackedSeriesLookup(_rtc);
        this.dPointToPixel = (double)this.ids.getDpiResolution() / 72.0;
        this.buildAxes();
    }

    final void buildAxes() throws IllegalArgumentException, ChartException {
        Axis[] axa = this.cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        if (!axPrimaryBase.isSetOrientation()) {
            axPrimaryBase.setOrientation(Orientation.HORIZONTAL_LITERAL);
        }
        this.validateAxis(axPrimaryBase);
        Axis axPrimaryOrthogonal = this.cwa.getPrimaryOrthogonalAxis(axPrimaryBase);
        if (!axPrimaryOrthogonal.isSetOrientation()) {
            axPrimaryOrthogonal.setOrientation(Orientation.VERTICAL_LITERAL);
        }
        this.validateAxis(axPrimaryOrthogonal);
        Axis[] axaOverlayOrthogonal = this.cwa.getOrthogonalAxes(axPrimaryBase, false);
        this.aax = new AllAxes(this.cwa.getPlot().getClientArea().getInsets().scaledInstance(this.dPointToPixel));
        this.insCA = this.aax.getInsets();
        boolean isTransposed = this.cwa.isTransposed();
        this.aax.swapAxes(isTransposed);
        OneAxis oaxPrimaryBase = new OneAxis(axPrimaryBase);
        oaxPrimaryBase.set(this.getOrientation(1), this.transposeLabelPosition(1, PlotWith2DAxes.getLabelPosition(axPrimaryBase.getLabelPosition())), this.transposeLabelPosition(1, PlotWith2DAxes.getLabelPosition(axPrimaryBase.getTitlePosition())), axPrimaryBase.isSetCategoryAxis() && axPrimaryBase.isCategoryAxis(), axPrimaryBase.getScale().isTickBetweenCategories());
        oaxPrimaryBase.setGridProperties(axPrimaryBase.getMajorGrid().getLineAttributes(), axPrimaryBase.getMinorGrid().getLineAttributes(), axPrimaryBase.getMajorGrid().getTickAttributes(), axPrimaryBase.getMinorGrid().getTickAttributes(), this.transposeTickStyle(1, PlotWith2DAxes.getTickStyle(axPrimaryBase, 0)), this.transposeTickStyle(1, PlotWith2DAxes.getTickStyle(axPrimaryBase, 1)), axPrimaryBase.getScale().getMinorGridsPerUnit());
        oaxPrimaryBase.set(axPrimaryBase.getLabel(), axPrimaryBase.getTitle());
        oaxPrimaryBase.set(PlotWith2DAxes.getIntersection(axPrimaryBase));
        oaxPrimaryBase.set(axPrimaryBase.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryBase);
        OneAxis oaxPrimaryOrthogonal = new OneAxis(axPrimaryOrthogonal);
        oaxPrimaryOrthogonal.set(this.getOrientation(2), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? axPrimaryOrthogonal.getLabelPosition() : axPrimaryOrthogonal.getLabelPosition())), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? axPrimaryOrthogonal.getTitlePosition() : axPrimaryOrthogonal.getTitlePosition())), axPrimaryOrthogonal.isSetCategoryAxis() && axPrimaryOrthogonal.isCategoryAxis(), axPrimaryOrthogonal.getScale().isTickBetweenCategories());
        oaxPrimaryOrthogonal.setGridProperties(axPrimaryOrthogonal.getMajorGrid().getLineAttributes(), axPrimaryOrthogonal.getMinorGrid().getLineAttributes(), axPrimaryOrthogonal.getMajorGrid().getTickAttributes(), axPrimaryOrthogonal.getMinorGrid().getTickAttributes(), this.transposeTickStyle(2, !isTransposed ? PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 0) : PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 0)), this.transposeTickStyle(2, !isTransposed ? PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 1) : PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 1)), axPrimaryOrthogonal.getScale().getMinorGridsPerUnit());
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLabel(), axPrimaryOrthogonal.getTitle());
        oaxPrimaryOrthogonal.set(PlotWith2DAxes.getIntersection(axPrimaryOrthogonal));
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryOrthogonal);
        this.aax.initOverlays(axaOverlayOrthogonal.length, this.getOrientation(2));
        int i = 0;
        while (i < axaOverlayOrthogonal.length) {
            if (!axaOverlayOrthogonal[i].isSetOrientation()) {
                axaOverlayOrthogonal[i].setOrientation(Orientation.VERTICAL_LITERAL);
            }
            this.validateAxis(axaOverlayOrthogonal[i]);
            OneAxis oaxOverlayOrthogonal = new OneAxis(axaOverlayOrthogonal[i]);
            oaxOverlayOrthogonal.set(this.getOrientation(2), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? axaOverlayOrthogonal[i].getLabelPosition() : axaOverlayOrthogonal[i].getLabelPosition())), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? axaOverlayOrthogonal[i].getTitlePosition() : axaOverlayOrthogonal[i].getTitlePosition())), axaOverlayOrthogonal[i].isSetCategoryAxis() && axaOverlayOrthogonal[i].isCategoryAxis(), axaOverlayOrthogonal[i].getScale().isTickBetweenCategories());
            oaxOverlayOrthogonal.setGridProperties(axaOverlayOrthogonal[i].getMajorGrid().getLineAttributes(), axaOverlayOrthogonal[i].getMinorGrid().getLineAttributes(), axaOverlayOrthogonal[i].getMajorGrid().getTickAttributes(), axaOverlayOrthogonal[i].getMinorGrid().getTickAttributes(), this.transposeTickStyle(2, !isTransposed ? PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 0) : PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 0)), this.transposeTickStyle(2, !isTransposed ? PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 1) : PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 1)), axaOverlayOrthogonal[i].getScale().getMinorGridsPerUnit());
            oaxOverlayOrthogonal.set(axaOverlayOrthogonal[i].getLabel(), axaOverlayOrthogonal[i].getTitle());
            oaxOverlayOrthogonal.set(axaOverlayOrthogonal[i].getLineAttributes());
            oaxOverlayOrthogonal.set(PlotWith2DAxes.getIntersection(axaOverlayOrthogonal[i]));
            this.aax.defineOverlay(i, oaxOverlayOrthogonal);
            ++i;
        }
        this.ssl = StackedSeriesLookup.create(this.cwa, this.rtc);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object getMinMax(Axis ax, int iType) throws ChartException, IllegalArgumentException {
        sea = ax.getRuntimeSeries();
        iSeriesCount = sea.length;
        oMin /* !! */  = null;
        oMax /* !! */  = null;
        ps = PluginSettings.instance();
        iDSP = null;
        bAnyStacked = false;
        i = 0;
        while (i < iSeriesCount) {
            if (!sea[i].isStacked()) ** GOTO lbl15
            if (sea[i].canBeStacked()) {
                bAnyStacked = true;
            } else {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.unstackable.is.stacked"), new Object[]{sea[i]}));
lbl15:
                // 1 sources

                iDSP = ps.getDataSetProcessor(sea[i].getClass());
                ds = sea[i].getDataSet();
                oV1 = iDSP.getMinimum(ds);
                oV2 = iDSP.getMaximum(ds);
                if ((iType & 1) == 1) {
                    try {
                        if (oV1 != null) {
                            if (oMin /* !! */  == null) {
                                oMin /* !! */  = oV1;
                            } else {
                                dV1 = PlotWith2DAxes.asDouble(oV1);
                                if (Math.min(PlotWith2DAxes.asDouble((Object)oMin /* !! */ ), dV1) == dV1) {
                                    oMin /* !! */  = oV1;
                                }
                            }
                        }
                        if (oV2 == null) ** GOTO lbl57
                        if (oMax /* !! */  == null) {
                            oMax /* !! */  = oV2;
                        }
                        dV2 = PlotWith2DAxes.asDouble(oV2);
                        if (Math.max(PlotWith2DAxes.asDouble((Object)oMax /* !! */ ), dV2) != dV2) ** GOTO lbl57
                        oMax /* !! */  = oV2;
                    }
                    catch (ClassCastException v0) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.datetime.data.numerical.axis", Messages.getResourceBundle(this.rtc.getULocale()));
                    }
                } else if ((iType & 8) == 8) {
                    try {
                        if (oV1 != null) {
                            if (oMin /* !! */  == null) {
                                oMin /* !! */  = oV1;
                            } else {
                                cdtV1 = PlotWith2DAxes.asDateTime(oV1);
                                if (cdtV1.before((Object)(cdtMin = PlotWith2DAxes.asDateTime((Object)oMin /* !! */ )))) {
                                    oMin /* !! */  = cdtV1;
                                }
                            }
                        }
                        if (oV2 != null) {
                            if (oMax /* !! */  == null) {
                                oMax /* !! */  = oV2;
                            } else {
                                cdtV2 = PlotWith2DAxes.asDateTime(oV2);
                                if (cdtV2.after((Object)(cdtMax = PlotWith2DAxes.asDateTime((Object)oMax /* !! */ )))) {
                                    oMax /* !! */  = cdtV2;
                                }
                            }
                        }
                    }
                    catch (ClassCastException v1) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.numerical.data.datetime.axis", Messages.getResourceBundle(this.rtc.getULocale()));
                    }
                }
            }
lbl57:
            // 9 sources

            ++i;
        }
        if (bAnyStacked || ax.isPercent()) {
            if (ax.getType().getValue() == 3) {
                throw new IllegalArgumentException(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.stacked.datetime.axis.series"));
            }
            dPercentMax = 0.0;
            dPercentMin = 0.0;
            dAxisMin = 1.7976931348623157E308;
            dAxisMax = -1.7976931348623157E308;
            alSeriesGroupsPerAxis = this.ssl.getStackGroups(ax);
            dsi = new DataSetIterator[this.ssl.getSeriesCount(ax)];
            if (alSeriesGroupsPerAxis == null) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.internal.stack.series.setup", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            PlotWith2DAxes.logger.log(1, Messages.getString("info.processing.stacked.info", new Object[]{ax}, this.rtc.getULocale()));
            iDataSetCount = this.ssl.getUnitCount();
            k = 0;
            while (k < iDataSetCount) {
                iSeriesIndex = 0;
                i = 0;
                while (i < alSeriesGroupsPerAxis.size()) {
                    sg = alSeriesGroupsPerAxis.get(i);
                    alSeriesPerGroup = sg.getSeries();
                    iSeriesPerGroup = alSeriesPerGroup.size();
                    if (iSeriesPerGroup > 0 && !((ds = (se = alSeriesPerGroup.get(0)).getDataSet()) instanceof NullDataSet)) {
                        if (dsi[iSeriesIndex] == null) {
                            dsi[iSeriesIndex] = new DataSetIterator(ds);
                            dsi[iSeriesIndex].reverse(this.cwa.isReverseCategory());
                            if ((dsi[iSeriesIndex].getDataType() & 1) != 1) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.percent.stacked.non.numerical", Messages.getResourceBundle(this.rtc.getULocale()));
                            }
                        }
                        iDataSetCount = dsi[iSeriesIndex].size();
                        au = this.ssl.getSubUnit(sg, k);
                        j = 0;
                        while (j < iSeriesPerGroup) {
                            se = alSeriesPerGroup.get(j);
                            if (j > 0 && dsi[iSeriesIndex] == null) {
                                ds = se.getDataSet();
                                dsi[iSeriesIndex] = new DataSetIterator(ds);
                                dsi[iSeriesIndex].reverse(this.cwa.isReverseCategory());
                                if ((dsi[iSeriesIndex].getDataType() & 1) != 1) {
                                    throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.percent.stacked.non.numerical", Messages.getResourceBundle(this.rtc.getULocale()));
                                }
                            }
                            if ((oValue = dsi[iSeriesIndex].next()) != null) {
                                dValue = (Double)oValue;
                                au.computeTotal(dValue);
                            }
                            ++iSeriesIndex;
                            ++j;
                        }
                        if (ax.isPercent()) {
                            dAbsTotal = au.getPositiveTotal() - au.getNegativeTotal();
                            if (dAbsTotal != 0.0) {
                                dPercentMax = Math.max(au.getTotalMax() / dAbsTotal * 100.0, dPercentMax);
                                dPercentMin = Math.min(au.getTotalMin() / dAbsTotal * 100.0, dPercentMin);
                            }
                        } else {
                            dAxisMax = Math.max(au.getTotalMax(), dAxisMax);
                            dAxisMin = Math.min(au.getTotalMin(), dAxisMin);
                        }
                    }
                    ++i;
                }
                ++k;
            }
            if (ax.isPercent()) {
                if (dPercentMax > 100.0) {
                    dPercentMax = 100.0;
                }
                if (dPercentMin < -100.0) {
                    dPercentMin = -100.0;
                }
                if (dPercentMax == 0.0 && dPercentMin == 0.0) {
                    dPercentMax = 100.0;
                }
                dAxisMin = dPercentMin;
                dAxisMax = dPercentMax;
            }
            if ((iType & 4) == 4) {
                dAxisMin = 1.0;
            }
            if (dAxisMin != 1.7976931348623157E308) {
                oMin /* !! */  = new Double(dAxisMin);
            }
            if (dAxisMax != -1.7976931348623157E308) {
                oMax /* !! */  = new Double(dAxisMax);
            }
        }
        if (oMin /* !! */  == null && oMax /* !! */  == null) {
            if (iType == 8) {
                year = Calendar.getInstance().get(1);
                oMin /* !! */  = new CDateTime(year, 1, 1);
                oMax /* !! */  = new CDateTime(year, 12, 31);
            } else if ((iType & 1) == 1) {
                if ((iType & 32) == 32) {
                    oMin /* !! */  = new Double(0.0);
                    oMax /* !! */  = new Double(100.0);
                } else if ((iType & 4) == 4) {
                    oMin /* !! */  = new Double(1.0);
                    oMax /* !! */  = new Double(1000.0);
                } else {
                    oMin /* !! */  = new Double(-1.0);
                    oMax /* !! */  = new Double(1.0);
                }
            }
        }
        if (iType == 8) {
            try {
                dtMin = PlotWith2DAxes.asDateTime(oMin /* !! */ );
                dtMax = PlotWith2DAxes.asDateTime(oMax /* !! */ );
                return new Calendar[]{dtMin, dtMax};
            }
            catch (ClassCastException v2) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.numerical.data.datetime.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        if ((iType & 1) == 1) {
            try {
                dMin = PlotWith2DAxes.asDouble(oMin /* !! */ );
                dMax = PlotWith2DAxes.asDouble(oMax /* !! */ );
                if (dMin == dMax) {
                    if (dMin > 0.0) {
                        dMin = 0.0;
                    }
                    if (dMax < 0.0) {
                        dMax = 0.0;
                    }
                }
                return new double[]{dMin, dMax};
            }
            catch (ClassCastException v3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.datetime.data.numerical.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        return null;
    }

    public final void compute(Bounds bo) throws ChartException, IllegalArgumentException {
        bo = bo.scaledInstance(this.dPointToPixel);
        this.dSeriesThickness = (double)this.ids.getDpiResolution() / 72.0 * this.cwa.getSeriesThickness();
        this.dSeriesThickness = this.cwa.getPlot().getClientArea().isVisible() ? this.dSeriesThickness : 0.0;
        double dX = bo.getLeft() + this.insCA.getLeft();
        double dY = bo.getTop() + this.insCA.getTop();
        double dW = bo.getWidth() - this.insCA.getLeft() - this.insCA.getRight();
        double dH = bo.getHeight() - this.insCA.getTop() - this.insCA.getBottom();
        this.iDimension = PlotWith2DAxes.getDimension(this.cwa.getDimension());
        this.dXAxisPlotSpacing = (double)this.cwa.getPlot().getHorizontalSpacing() * this.dPointToPixel;
        this.dYAxisPlotSpacing = (double)this.cwa.getPlot().getVerticalSpacing() * this.dPointToPixel;
        if (this.iDimension == 1) {
            bo.setHeight(dH -= this.dSeriesThickness);
            bo.setTop(dY += this.dSeriesThickness);
            bo.setWidth(dW -= this.dSeriesThickness);
        }
        if (this.aax.getOverlayCount() > 0) {
            if (this.aax.areAxesSwapped()) {
                this.updateOverlayScales(this.aax, dX, dX + dW, dY, dH);
                dY = this.aax.getStart();
                dH = this.aax.getLength();
            } else {
                this.updateOverlayScales(this.aax, dY - dH, dY, dX, dW);
                dX = this.aax.getStart();
                dW = this.aax.getLength();
            }
        }
        Axis[] axa = this.cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis axPrimaryOrthogonal = this.cwa.getPrimaryOrthogonalAxis(axPrimaryBase);
        Scale sc = axPrimaryBase.getScale();
        AutoScale scPrimaryBase = null;
        OneAxis oaxPrimaryBase = this.aax.getPrimaryBase();
        int iAxisType = PlotWith2DAxes.getAxisType(axPrimaryBase);
        Object oaData = null;
        if (iAxisType == 16 || oaxPrimaryBase.isCategoryScale()) {
            oaData = this.getTypedDataSet(axPrimaryBase, iAxisType, 0);
        } else if ((iAxisType & 1) == 1) {
            oaData = this.getMinMax(axPrimaryBase, iAxisType);
        } else if ((iAxisType & 8) == 8) {
            oaData = this.getMinMax(axPrimaryBase, iAxisType);
        }
        DataSetIterator dsi = oaData instanceof DataSetIterator ? oaData : new DataSetIterator(oaData, iAxisType);
        oaData = null;
        double dStart = this.aax.areAxesSwapped() ? dY + dH : dX;
        double dEnd = this.aax.areAxesSwapped() ? dY : dStart + dW;
        int iDirection = 0;
        scPrimaryBase = AutoScale.computeScale(this.ids, oaxPrimaryBase, dsi, iAxisType, dStart, dEnd, sc, axPrimaryBase.getFormatSpecifier(), this.rtc, iDirection, 1.0, this.iMarginPercent);
        oaxPrimaryBase.set(scPrimaryBase);
        AutoScale scPrimaryOrthogonal = null;
        OneAxis oaxPrimaryOrthogonal = this.aax.getPrimaryOrthogonal();
        iAxisType = PlotWith2DAxes.getAxisType(axPrimaryOrthogonal);
        oaData = null;
        if ((iAxisType & 1) != 1 && (iAxisType & 8) != 8) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.orthogonal.axis.numerical.datetime", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        dsi = new DataSetIterator(this.getMinMax(axPrimaryOrthogonal, iAxisType), iAxisType);
        dsi.reverse(this.cwa.isReverseCategory());
        dStart = this.aax.areAxesSwapped() ? dX : dY + dH;
        dEnd = this.aax.areAxesSwapped() ? dX + dW : dY;
        sc = axPrimaryOrthogonal.getScale();
        scPrimaryOrthogonal = AutoScale.computeScale(this.ids, oaxPrimaryOrthogonal, dsi, iAxisType, dStart, dEnd, sc, oaxPrimaryBase.getModelAxis().getOrigin(), axPrimaryOrthogonal.getFormatSpecifier(), this.rtc, 0, 1.0, this.iMarginPercent);
        oaxPrimaryOrthogonal.set(scPrimaryOrthogonal);
        double dYAxisLocation = this.adjustHorizontal(dX, dW, this.aax);
        double dXAxisLocation = this.adjustVerticalDueToHorizontal(dY, dH, this.aax);
        iAxisType = PlotWith2DAxes.getAxisType(axPrimaryOrthogonal);
        oaData = this.getTypedDataSet(axPrimaryOrthogonal, iAxisType, 0);
        scPrimaryOrthogonal.setData(dsi);
        iAxisType = PlotWith2DAxes.getAxisType(axPrimaryBase);
        if (iAxisType != 16) {
            scPrimaryBase.setData(this.getTypedDataSet(axPrimaryBase, iAxisType, 0));
        }
        scPrimaryBase.resetShifts();
        scPrimaryOrthogonal.resetShifts();
        this.updateOverlayAxes(this.aax);
        this.growBaseAxis(this.aax, BoundsImpl.create(dX, dY, dW, dH));
        OneAxis axPH = this.aax.areAxesSwapped() ? this.aax.getPrimaryOrthogonal() : this.aax.getPrimaryBase();
        OneAxis axPV = this.aax.areAxesSwapped() ? this.aax.getPrimaryBase() : this.aax.getPrimaryOrthogonal();
        axPH.setAxisCoordinate(dXAxisLocation);
        axPV.setAxisCoordinate(dYAxisLocation);
        double[] daX = axPH.getScale().getEndPoints();
        double[] daY = axPV.getScale().getEndPoints();
        if (axPH.getScale().getDirection() == -1) {
            this.boPlotBackground.setLeft(daX[1] - this.insCA.getLeft());
            this.boPlotBackground.setWidth(daX[0] - daX[1] + this.insCA.getLeft() + this.insCA.getRight() + 1.0);
        } else {
            this.boPlotBackground.setLeft(daX[0] - this.insCA.getLeft());
            this.boPlotBackground.setWidth(daX[1] - daX[0] + this.insCA.getLeft() + this.insCA.getRight() + 1.0);
        }
        if (axPV.getScale().getDirection() == 1) {
            this.boPlotBackground.setTop(daY[0] - this.insCA.getTop());
            this.boPlotBackground.setHeight(daY[1] - daY[0] + this.insCA.getTop() + this.insCA.getBottom() + 1.0);
        } else {
            this.boPlotBackground.setTop(daY[1] - this.insCA.getTop());
            this.boPlotBackground.setHeight(daY[0] - daY[1] + this.insCA.getTop() + this.insCA.getBottom() + 1.0);
        }
        if (this.iDimension == 1) {
            this.boPlotBackground.delta(this.dSeriesThickness, -this.dSeriesThickness, 0.0, 0.0);
        }
        this.boPlotWithMargin = BoundsImpl.copyInstance(this.boPlotBackground);
        if (this.iMarginPercent > 0) {
            double factor;
            AutoScale scale = axPH.getScale();
            if ((scale.getMaxWithMargin() != null || scale.getMinWithMargin() != null) && (scale.getType() & 2) == 2) {
                factor = Math.abs(daX[1] - daX[0]) / (PlotWith2DAxes.asDouble(scale.getMaximum()) - PlotWith2DAxes.asDouble(scale.getMinimum()));
                if (scale.getMinWithMargin() != null) {
                    this.boPlotWithMargin.setLeft(this.boPlotWithMargin.getLeft() - factor * (PlotWith2DAxes.asDouble(scale.getMinimum()) - PlotWith2DAxes.asDouble(scale.getMinWithMargin())));
                }
                this.boPlotWithMargin.setWidth(factor * (PlotWith2DAxes.asDouble(scale.getMaxWithMargin() == null ? scale.getMaximum() : scale.getMaxWithMargin()) - PlotWith2DAxes.asDouble(scale.getMinWithMargin() == null ? scale.getMinimum() : scale.getMinWithMargin())) + this.insCA.getLeft() + this.insCA.getRight() + 1.0);
            }
            if (((scale = axPV.getScale()).getMaxWithMargin() != null || scale.getMinWithMargin() != null) && (scale.getType() & 2) == 2) {
                factor = Math.abs(daX[1] - daX[0]) / (PlotWith2DAxes.asDouble(scale.getMaximum()) - PlotWith2DAxes.asDouble(scale.getMinimum()));
                if (scale.getMaxWithMargin() != null) {
                    this.boPlotWithMargin.setTop(this.boPlotWithMargin.getTop() - factor * (PlotWith2DAxes.asDouble(scale.getMaxWithMargin()) - PlotWith2DAxes.asDouble(scale.getMaximum())));
                }
                this.boPlotWithMargin.setHeight(factor * (PlotWith2DAxes.asDouble(scale.getMaxWithMargin() == null ? scale.getMaximum() : scale.getMaxWithMargin()) - PlotWith2DAxes.asDouble(scale.getMinWithMargin() == null ? scale.getMinimum() : scale.getMinWithMargin())) + this.insCA.getTop() + this.insCA.getBottom() + 1.0);
            }
        }
    }

    public final Bounds getPlotBoundsWithMargin() {
        return this.boPlotWithMargin;
    }

    private final void growBaseAxis(AllAxes aax, Bounds bo) throws ChartException {
        OneAxis oaxBase = aax.getPrimaryBase();
        OneAxis oaxOrthogonal = aax.getPrimaryOrthogonal();
        AutoScale scBase = oaxBase.getScale();
        if (aax.getOverlayCount() <= 0) {
            return;
        }
        if (!aax.areAxesSwapped()) {
            if (oaxOrthogonal.getIntersectionValue().getType() != 1) {
                if (aax.anyOverlayPositionedAt(1)) {
                    scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 0, oaxBase.getLabelPosition(), aax);
                    double dRightThreshold = bo.getLeft() + bo.getWidth();
                    double dEnd = scBase.getEnd();
                    double dEndShift = scBase.getEndShift();
                    if (dEnd + dEndShift < dRightThreshold) {
                        scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 0, scBase.getStart(), dEnd += dEndShift, false, null);
                    }
                }
            } else if (oaxOrthogonal.getIntersectionValue().getType() != 2 && aax.anyOverlayPositionedAt(2)) {
                scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 0, oaxBase.getLabelPosition(), aax);
                double dLeftThreshold = bo.getLeft();
                double dStart = scBase.getStart();
                double dEndShift = scBase.getEndShift();
                double dStartShift = scBase.getStartShift();
                if (dStart - dStartShift > dLeftThreshold) {
                    double dEnd = scBase.getEnd() + dEndShift;
                    scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 0, dStart -= dStartShift, dEnd, false, null);
                }
            }
        } else if (oaxOrthogonal.getIntersectionValue().getType() != 1) {
            if (aax.anyOverlayPositionedAt(1)) {
                scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 1, oaxBase.getLabelPosition(), aax);
                double dTopThreshold = bo.getTop();
                double dEnd = scBase.getEnd();
                double dEndShift = Math.floor(scBase.getEndShift());
                if (dEnd - dEndShift > dTopThreshold) {
                    double dStart = scBase.getStart();
                    scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 1, dStart, dEnd -= dEndShift, false, null);
                }
            }
        } else if (oaxOrthogonal.getIntersectionValue().getType() != 2 && aax.anyOverlayPositionedAt(2)) {
            scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 1, oaxBase.getLabelPosition(), aax);
            double dBottomThreshold = bo.getTop() + bo.getHeight();
            double dStart = scBase.getStart();
            double dStartShift = scBase.getStartShift();
            if (dStart + dStartShift < dBottomThreshold) {
                double dEnd = scBase.getEnd();
                scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 1, dStart += dStartShift, dEnd, false, null);
            }
        }
    }

    private final void updateOverlayScales(AllAxes aax, double dAxisStart, double dAxisEnd, double dBlockStart, double dBlockLength) throws ChartException, IllegalArgumentException {
        Axis[] axa = ((ChartWithAxesImpl)this.cwa).getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis[] axaOrthogonal = ((ChartWithAxesImpl)this.cwa).getOrthogonalAxes(axPrimaryBase, false);
        AutoScale sc = null;
        OneAxis oaxOverlay = null;
        int iOverlayCount = aax.getOverlayCount();
        int iOrientation = aax.getOrientation();
        Series[] sea = this.cwa.getSeries(2);
        Map seriesRenderingHints = this.rtc.getSeriesRenderers();
        int i = 0;
        while (i < iOverlayCount) {
            double dDelta;
            int j = iOverlayCount - i - 1;
            oaxOverlay = aax.getOverlay(j);
            int iTickStyle = oaxOverlay.getCombinedTickStyle();
            int iTitleLocation = oaxOverlay.getTitlePosition();
            Label laAxisTitle = oaxOverlay.getTitle();
            int iAxisType = PlotWith2DAxes.getAxisType(axaOrthogonal[j]);
            Scale scModel = axaOrthogonal[j].getScale();
            sc = AutoScale.computeScale(this.ids, oaxOverlay, new DataSetIterator(this.getMinMax(axaOrthogonal[j], iAxisType), iAxisType), iAxisType, dAxisStart, dAxisEnd, scModel, axaOrthogonal[j].getFormatSpecifier(), this.rtc, 0, 1.0, this.iMarginPercent);
            oaxOverlay.set(sc);
            IntersectionValue iv = oaxOverlay.getIntersectionValue();
            double dStart = sc.getStart();
            double dEnd = sc.getEnd();
            sc.computeTicks(this.ids, oaxOverlay.getLabel(), oaxOverlay.getLabelPosition(), iOrientation, dStart, dEnd, true, null);
            if (!sc.isStepFixed()) {
                Object[] oaMinMax = sc.getMinMax();
                while (!sc.checkFit(this.ids, oaxOverlay.getLabel(), oaxOverlay.getLabelPosition())) {
                    if (!sc.zoomOut()) break;
                    sc.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    sc.computeTicks(this.ids, oaxOverlay.getLabel(), oaxOverlay.getLabelPosition(), iOrientation, dStart, dEnd, true, null);
                }
            }
            double dAxisLabelsThickness = sc.computeAxisLabelThickness(this.ids, oaxOverlay.getLabel(), iOrientation);
            double[] dDecorationThickness = new double[]{0.0, 0.0};
            int t = 0;
            while (t < sea.length) {
                IAxesDecorator iad;
                LegendItemRenderingHints lirh = (LegendItemRenderingHints)seriesRenderingHints.get(sea[t]);
                if (lirh != null && lirh.getRenderer() instanceof AxesRenderer && (iad = ((AxesRenderer)lirh.getRenderer()).getAxesDecorator(oaxOverlay)) != null) {
                    double[] thickness = iad.computeDecorationThickness(this.ids, oaxOverlay);
                    if (thickness[0] > dDecorationThickness[0]) {
                        dDecorationThickness[0] = thickness[0];
                    }
                    if (thickness[1] > dDecorationThickness[1]) {
                        dDecorationThickness[1] = thickness[1];
                    }
                }
                ++t;
            }
            double dAxisTitleThickness = 0.0;
            sc.resetShifts();
            if (iOrientation == 1) {
                double dX = 0.0;
                double dX1 = 0.0;
                double dX2 = 0.0;
                boolean bTicksLeft = (iTickStyle & 1) == 1;
                boolean bTicksRight = (iTickStyle & 2) == 2;
                double dAppliedYAxisPlotSpacing = this.dYAxisPlotSpacing;
                if (laAxisTitle.isVisible()) {
                    String sPreviousValue = laAxisTitle.getCaption().getValue();
                    laAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
                    dAxisTitleThickness = PlotWith2DAxes.computeBox(this.ids, iTitleLocation, laAxisTitle, 0.0, 0.0, ChartUtil.computeHeightOfOrthogonalAxisTitle(this.cwa, this.getDisplayServer())).getWidth();
                    laAxisTitle.getCaption().setValue(sPreviousValue);
                }
                if (iv.getType() == 2) {
                    dX = dBlockStart;
                    dX1 = dX -= dAppliedYAxisPlotSpacing;
                    dX2 = dX;
                    if (bTicksLeft) {
                        dX1 -= this.getTickSize();
                    }
                    if (oaxOverlay.getLabelPosition() == 1) {
                        dX1 -= Math.max(dAxisLabelsThickness, dDecorationThickness[0]);
                        dX2 += Math.max(bTicksRight ? this.getTickSize() : 0.0, dAppliedYAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 2) {
                        dX1 -= dDecorationThickness[0];
                        dX2 += Math.max((bTicksRight ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedYAxisPlotSpacing);
                    }
                    if (iTitleLocation == 1) {
                        dX1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 2) {
                        dX2 += dAxisTitleThickness;
                    }
                    if (dX1 < dBlockStart) {
                        double dDelta2 = dBlockStart - dX1;
                        dX1 = dBlockStart;
                        dX += dDelta2;
                        dX2 += dDelta2;
                    }
                    dBlockStart += dX2 - dX1;
                } else if (iv.getType() == 1) {
                    dX = dBlockStart + dBlockLength;
                    dX1 = dX += dAppliedYAxisPlotSpacing;
                    dX2 = dX;
                    if (bTicksRight) {
                        dX2 += this.getTickSize();
                    }
                    if (oaxOverlay.getLabelPosition() == 2) {
                        dX2 += Math.max(dAxisLabelsThickness, dDecorationThickness[1]);
                        dX1 -= Math.max(bTicksLeft ? this.getTickSize() : 0.0, dAppliedYAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 1) {
                        dX1 -= Math.max((bTicksLeft ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedYAxisPlotSpacing);
                        dX2 += dDecorationThickness[1];
                    }
                    if (iTitleLocation == 1) {
                        dX1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 2) {
                        dX2 += dAxisTitleThickness;
                    }
                    if (dX2 > dBlockStart + dBlockLength) {
                        double dDelta3 = dX2 - (dBlockStart + dBlockLength);
                        dX2 = dBlockStart + dBlockLength;
                        dX -= dDelta3;
                        dX1 -= dDelta3;
                    }
                }
                dBlockLength -= dX2 - dX1;
                dDelta = 0.0;
                if (iv.getType() == 2) {
                    dDelta = -this.insCA.getLeft();
                } else if (iv.getType() == 1) {
                    dDelta = this.insCA.getRight();
                }
                oaxOverlay.setAxisCoordinate(dX + dDelta);
                oaxOverlay.setTitleCoordinate(iTitleLocation == 1 ? dX1 + dDelta - 1.0 : dX2 + 1.0 - dAxisTitleThickness + dDelta);
            } else if (iOrientation == 0) {
                double dY;
                double dY1 = dY = 0.0;
                double dY2 = dY;
                boolean bTicksAbove = (iTickStyle & 1) == 1;
                boolean bTicksBelow = (iTickStyle & 2) == 2;
                double dAppliedXAxisPlotSpacing = this.dXAxisPlotSpacing;
                if (laAxisTitle.isVisible()) {
                    String sPreviousValue = laAxisTitle.getCaption().getValue();
                    laAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
                    dAxisTitleThickness = PlotWith2DAxes.computeBox(this.ids, iTitleLocation, laAxisTitle, 0.0, 0.0, ChartUtil.computeHeightOfOrthogonalAxisTitle(this.cwa, this.getDisplayServer())).getHeight();
                    laAxisTitle.getCaption().setValue(sPreviousValue);
                }
                if (iv.getType() == 1) {
                    dY = dBlockStart;
                    dY1 = dY -= dAppliedXAxisPlotSpacing;
                    dY2 = dY;
                    if (bTicksAbove) {
                        dY1 -= this.getTickSize();
                    }
                    if (oaxOverlay.getLabelPosition() == 4) {
                        dY1 -= Math.max(dAxisLabelsThickness, dDecorationThickness[0]);
                        dY2 += Math.max(bTicksBelow ? this.getTickSize() : 0.0, dAppliedXAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 8) {
                        dY1 -= dDecorationThickness[0];
                        dY2 += Math.max((bTicksBelow ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedXAxisPlotSpacing);
                    }
                    if (iTitleLocation == 4) {
                        dY1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 8) {
                        dY2 += dAxisTitleThickness;
                    }
                    if (dY1 < dBlockStart) {
                        double dDelta4 = dBlockStart - dY1;
                        dY1 = dBlockStart;
                        dY += dDelta4;
                        dY2 += dDelta4;
                    }
                    dBlockStart += dY2 - dY1;
                } else if (iv.getType() == 2) {
                    dY = dBlockStart + dBlockLength;
                    dY1 = dY += dAppliedXAxisPlotSpacing;
                    dY2 = dY;
                    if (bTicksBelow) {
                        dY2 += this.getTickSize();
                    }
                    if (oaxOverlay.getLabelPosition() == 8) {
                        dY2 += Math.max(dAxisLabelsThickness, dDecorationThickness[1]);
                        dY1 -= Math.max(bTicksAbove ? this.getTickSize() : 0.0, dAppliedXAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 4) {
                        dY1 -= Math.max((bTicksAbove ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedXAxisPlotSpacing);
                        dY2 += dDecorationThickness[1];
                    }
                    if (iTitleLocation == 4) {
                        dY1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 8) {
                        dY2 += dAxisTitleThickness;
                    }
                    if (dY2 > dBlockStart + dBlockLength) {
                        double dDelta5 = dY2 - (dBlockStart + dBlockLength);
                        dY2 = dBlockStart + dBlockLength;
                        dY -= dDelta5;
                        dY1 -= dDelta5;
                    }
                }
                dDelta = 0.0;
                if (iv.getType() == 1) {
                    dDelta = -this.insCA.getTop();
                } else if (iv.getType() == 2) {
                    dDelta = this.insCA.getBottom();
                }
                oaxOverlay.setAxisCoordinate(dY + dDelta);
                oaxOverlay.setTitleCoordinate(iTitleLocation == 4 ? dY1 + dDelta - 1.0 : dY2 + 1.0 - dAxisTitleThickness + dDelta);
                dBlockLength -= dY2 - dY1;
            }
            ++i;
        }
        aax.setBlockCordinates(dBlockStart, dBlockLength);
    }

    private final void updateOverlayAxes(AllAxes aax) throws ChartException, IllegalArgumentException {
        int iDirection = aax.getOrientation() == 0 ? 1 : -1;
        Axis[] axa = this.cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis[] axaOverlayOrthogonal = this.cwa.getOrthogonalAxes(axPrimaryBase, false);
        OneAxis axPrimary = aax.getPrimaryOrthogonal();
        AutoScale sc = axPrimary.getScale();
        int i = 0;
        while (i < aax.getOverlayCount()) {
            OneAxis axOverlay = aax.getOverlay(i);
            int iAxisType = axOverlay.getScale().getType();
            Label la = axOverlay.getLabel();
            AutoScale scOA = axOverlay.getScale();
            scOA.setEndPoints(scOA.getStart() - scOA.getStartShift() * (double)iDirection, scOA.getEnd() + scOA.getEndShift() * (double)iDirection);
            double dStart = sc.getStart();
            double dEnd = sc.getEnd();
            scOA.setEndPoints(dStart, dEnd);
            scOA.computeTicks(this.ids, la, axOverlay.getLabelPosition(), aax.getOrientation(), dStart, dEnd, false, null);
            if (!scOA.isStepFixed()) {
                Object[] oaMinMax = scOA.getMinMax();
                while (!scOA.checkFit(this.ids, la, axOverlay.getLabelPosition())) {
                    if (!scOA.zoomOut()) break;
                    scOA.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    scOA.computeTicks(this.ids, la, axOverlay.getLabelPosition(), aax.getOrientation(), dStart, dEnd, false, null);
                }
            }
            scOA.setData(this.getTypedDataSet(axaOverlayOrthogonal[i], iAxisType, 0));
            ++i;
        }
    }

    public final ISeriesRenderingHints getSeriesRenderingHints(SeriesDefinition sdOrthogonal, Series seOrthogonal) throws ChartException, IllegalArgumentException {
        int iTickCount;
        if (seOrthogonal == null || seOrthogonal.getClass() == SeriesImpl.class) {
            return null;
        }
        OneAxis oaxOrthogonal = this.findOrthogonalAxis(seOrthogonal);
        if (oaxOrthogonal == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 6, "exception.axis.series.link.broken", new Object[]{seOrthogonal}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        OneAxis oaxBase = this.aax.getPrimaryBase();
        SeriesDefinition sdBase = (SeriesDefinition)oaxBase.getModelAxis().getSeriesDefinitions().get(0);
        AutoScale scBase = oaxBase.getScale();
        AutoScale scOrthogonal = oaxOrthogonal.getScale();
        int iUnitCount = iTickCount = scBase.getTickCount();
        int iDirection = scBase.getDirection();
        double dUnitSize = iDirection == -1 || iDirection == 0 && this.aax.areAxesSwapped() ? -scBase.getUnitSize() : scBase.getUnitSize();
        scBase.getType();
        AxisTickCoordinates daTickCoordinates = scBase.getTickCordinates();
        Object oDataBase = null;
        DataSetIterator dsiDataBase = scBase.getData();
        DataSetIterator dsiDataOrthogonal = this.getTypedDataSet(seOrthogonal, oaxOrthogonal.getScale().getType());
        double dOrthogonalZero = 0.0;
        dOrthogonalZero = (scOrthogonal.getType() & 1) == 1 ? PlotWith2DAxes.getLocation(scOrthogonal, 0.0) : scOrthogonal.getStart();
        double dBaseZero = 0.0;
        dBaseZero = (scBase.getType() & 1) == 1 && !oaxBase.isCategoryScale() ? PlotWith2DAxes.getLocation(scBase, 0.0) : (oaxBase.isTickBwtweenCategories() ? scBase.getStart() : scBase.getStart() + scBase.getStartShift());
        if (scBase.getType() == 16 || oaxBase.isCategoryScale()) {
            --iUnitCount;
            if (oaxBase.isTickBwtweenCategories()) {
                --iUnitCount;
            }
        }
        double dX = 0.0;
        double dY = 0.0;
        int iBaseCount = dsiDataBase.size();
        int iOrthogonalCount = dsiDataOrthogonal.size();
        DataPointHints[] dpa = null;
        if (iBaseCount != iOrthogonalCount) {
            logger.log(1, Messages.getString("exception.base.orthogonal.inconsistent.count", new Object[]{new Integer(iBaseCount), new Integer(iOrthogonalCount)}, this.rtc.getULocale()));
        } else {
            dpa = new DataPointHints[iBaseCount];
            boolean bScatter = oaxBase.getScale().getType() != 16 && !oaxBase.isCategoryScale();
            DataPoint dp = seOrthogonal.getDataPoint();
            EList el = dp.getComponents();
            FormatSpecifier fsBase = null;
            FormatSpecifier fsOrthogonal = null;
            FormatSpecifier fsSeries = null;
            FormatSpecifier fsPercentile = null;
            int i = 0;
            while (i < el.size()) {
                DataPointComponent dpc = (DataPointComponent)el.get(i);
                DataPointComponentType dpct = dpc.getType();
                if (((Object)((Object)DataPointComponentType.BASE_VALUE_LITERAL)).equals((Object)dpct) && (fsBase = dpc.getFormatSpecifier()) == null) {
                    fsBase = sdBase.getFormatSpecifier();
                }
                if (((Object)((Object)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL)).equals((Object)dpct) && (fsOrthogonal = dpc.getFormatSpecifier()) == null && seOrthogonal.eContainer() instanceof SeriesDefinition) {
                    fsOrthogonal = ((SeriesDefinition)seOrthogonal.eContainer()).getFormatSpecifier();
                }
                if (((Object)((Object)DataPointComponentType.SERIES_VALUE_LITERAL)).equals((Object)dpct)) {
                    fsSeries = dpc.getFormatSpecifier();
                }
                if (((Object)((Object)DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL)).equals((Object)dpct)) {
                    fsPercentile = dpc.getFormatSpecifier();
                }
                ++i;
            }
            dsiDataBase.reset();
            dsiDataOrthogonal.reset();
            UserDataSetHints udsh = new UserDataSetHints(seOrthogonal.getDataSets());
            udsh.reset();
            double total = 0.0;
            boolean isZeroValue = true;
            int i2 = 0;
            while (i2 < iOrthogonalCount) {
                Object v = dsiDataOrthogonal.next();
                if (v instanceof Number) {
                    if (((Number)v).doubleValue() != 0.0) {
                        isZeroValue = false;
                    }
                    total += ((Number)v).doubleValue();
                } else if (v instanceof NumberDataElement) {
                    if (((NumberDataElement)v).getValue() != 0.0) {
                        isZeroValue = false;
                    }
                    total += ((NumberDataElement)v).getValue();
                }
                ++i2;
            }
            dsiDataOrthogonal.reset();
            i2 = 0;
            while (i2 < iBaseCount) {
                oDataBase = dsiDataBase.next();
                Object oDataOrthogonal = dsiDataOrthogonal.next();
                if (!bScatter) {
                    if (this.aax.areAxesSwapped()) {
                        dY = daTickCoordinates.getStart() + dUnitSize * (double)i2;
                        try {
                            dX = PlotWith2DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            dX = Double.NaN;
                        }
                        catch (ChartException chartException) {
                            dX = dOrthogonalZero;
                        }
                    } else {
                        dX = daTickCoordinates.getStart() + dUnitSize * (double)i2;
                        try {
                            dY = PlotWith2DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            dY = Double.NaN;
                        }
                        catch (ChartException chartException) {
                            dY = dOrthogonalZero;
                        }
                    }
                } else {
                    try {
                        dX = PlotWith2DAxes.getLocation(scBase, oDataBase);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dX = dBaseZero;
                    }
                    catch (ChartException chartException) {
                        dX = dBaseZero;
                    }
                    try {
                        dY = PlotWith2DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dX = Double.NaN;
                    }
                    catch (ChartException chartException) {
                        dY = dOrthogonalZero;
                    }
                    if (this.aax.areAxesSwapped()) {
                        double dTemp = dX;
                        dX = dY;
                        dY = dTemp;
                    }
                }
                Location lo = LocationImpl.create(dX, dY);
                double dLength = 0.0;
                if (!bScatter) {
                    dLength = dUnitSize;
                } else {
                    int j = 0;
                    while (j < iTickCount - 1) {
                        if (this.aax.areAxesSwapped()) {
                            if (dY <= daTickCoordinates.getCoordinate(j) && dY >= daTickCoordinates.getCoordinate(j + 1) || dY <= daTickCoordinates.getCoordinate(j + 1) && dY >= daTickCoordinates.getCoordinate(j)) {
                                dLength = daTickCoordinates.getCoordinate(j + 1) - daTickCoordinates.getCoordinate(j);
                                break;
                            }
                        } else if (dX <= daTickCoordinates.getCoordinate(j + 1) && dX >= daTickCoordinates.getCoordinate(j) || dX <= daTickCoordinates.getCoordinate(j) && dX >= daTickCoordinates.getCoordinate(j + 1)) {
                            dLength = daTickCoordinates.getCoordinate(j + 1) - daTickCoordinates.getCoordinate(j);
                            break;
                        }
                        ++j;
                    }
                }
                Double percentileValue = null;
                boolean bIsPercent = oaxOrthogonal.getModelAxis().isPercent();
                if (bIsPercent) {
                    AxisSubUnit au = this.ssl.getUnit(seOrthogonal, i2);
                    if (oDataOrthogonal instanceof Number) {
                        percentileValue = new Double(au.valuePercentage(((Number)oDataOrthogonal).doubleValue()) / 100.0);
                    } else if (oDataOrthogonal instanceof NumberDataElement) {
                        percentileValue = new Double(au.valuePercentage(((NumberDataElement)oDataOrthogonal).getValue()) / 100.0);
                    }
                } else if (total != 0.0) {
                    if (oDataOrthogonal instanceof Number) {
                        percentileValue = new Double(((Number)oDataOrthogonal).doubleValue() / total);
                    } else if (oDataOrthogonal instanceof NumberDataElement) {
                        percentileValue = new Double(((NumberDataElement)oDataOrthogonal).getValue() / total);
                    }
                } else if (isZeroValue) {
                    percentileValue = new Double(1.0 / (double)iOrthogonalCount);
                }
                dpa[i2] = new DataPointHints(oDataBase, oDataOrthogonal, seOrthogonal.getSeriesIdentifier(), (Object)percentileValue, seOrthogonal.getDataPoint(), fsBase, fsOrthogonal, fsSeries, fsPercentile, i2, lo, dLength, this.rtc);
                udsh.next(dpa[i2]);
                ++i2;
            }
        }
        return new SeriesRenderingHints(this, oaxBase.getAxisCoordinate(), scOrthogonal.getStart(), dOrthogonalZero, this.dSeriesThickness, daTickCoordinates, dpa, scBase, scOrthogonal, this.ssl, dsiDataBase, dsiDataOrthogonal);
    }

    public final StackedSeriesLookup getStackedSeriesLookup() {
        return this.ssl;
    }

    public void addMargin(int percent) {
        if (percent > 0) {
            this.iMarginPercent = percent;
        }
    }

    public final void initDynamicPlotBounds(Bounds bo) throws ChartException {
        if (bo.getWidth() * bo.getHeight() == 0.0) {
            Axis[] axa = this.cwa.getPrimaryBaseAxes();
            Axis axPrimaryBase = axa[0];
            Axis axPrimaryOrthogonal = this.cwa.getPrimaryOrthogonalAxis(axPrimaryBase);
            int iAxisType = PlotWith2DAxes.getAxisType(axPrimaryOrthogonal);
            DataSetIterator dsi = new DataSetIterator(this.getMinMax(axPrimaryOrthogonal, iAxisType), iAxisType);
            OneAxis oaxPrimaryOrthogonal = this.getAxes().getPrimaryOrthogonal();
            AutoScale scPrimaryOrthogonal = AutoScale.computeScale(this.ids, oaxPrimaryOrthogonal, dsi, iAxisType, 0.0, 0.0, axPrimaryOrthogonal.getScale(), axPrimaryBase.getOrigin(), axPrimaryOrthogonal.getFormatSpecifier(), this.rtc, 0, 1.0, this.iMarginPercent);
            double axisHeight = scPrimaryOrthogonal.computeAxisLabelThickness(this.ids, axPrimaryOrthogonal.getLabel(), this.getAxes().getOrientation()) * 72.0 / (double)this.ids.getDpiResolution() + 3.75;
            if (bo.getWidth() == 0.0) {
                bo.setWidth(axisHeight);
            } else {
                bo.setHeight(axisHeight);
            }
        } else if (bo.getWidth() * bo.getHeight() < 0.0) {
            double dBase = bo.getHeight() < 0.0 ? Math.abs(bo.getHeight()) : Math.abs(bo.getWidth());
            Series baseSeries = this.cwa.getSeries(1)[0];
            Object[] values = (Object[])baseSeries.getDataSet().getValues();
            int iDPCount = values.length;
            double dTotalWidth = dBase * (double)iDPCount;
            if (bo.getWidth() < 0.0) {
                bo.setWidth(dTotalWidth);
            } else {
                bo.setHeight(dTotalWidth);
            }
        }
    }
}

