/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.EllipsisHelper;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.RotatedRectangle;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.ScaleContext;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.AxisOrigin;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoScale
extends Methods
implements Cloneable {
    private final int iType;
    private Object oMinimum;
    private Object oMaximum;
    private Object oMinimumFixed;
    private Object oMaximumFixed;
    private Object oMinimumWithMargin = null;
    private Object oMaximumWithMargin = null;
    private Object oStep;
    private Integer oStepNumber;
    private Object oUnit;
    private double dStartShift;
    private double dEndShift;
    private double dZoomFactor = 1.0;
    private int iMarginPercent = 0;
    private double dStart;
    private double dEnd;
    private AxisTickCoordinates atcTickCoordinates;
    private LabelVisibleHelper labelVisHelper = null;
    private Map<Integer, String> hmComputedLabelText = null;
    private StaggeredHelper staggeredHelper = null;
    private DataSetIterator dsiData;
    private boolean bCategoryScale = false;
    private boolean bTickBetweenCategories = true;
    private boolean bLabelWithinAxes = false;
    private RunTimeContext rtc;
    private ScaleContext tmpSC;
    private ChartUtil.CacheDecimalFormat cacheNumFormat = new ChartUtil.CacheDecimalFormat();
    private ChartUtil.Cache<Integer, IDateFormatWrapper> cacheDateFormat = new ChartUtil.Cache<Integer, IDateFormatWrapper>(){

        @Override
        protected IDateFormatWrapper newValue(Integer iDateTimeUnit) {
            return DateFormatWrapperFactory.getPreferredDateFormat(iDateTimeUnit, AutoScale.this.rtc.getULocale());
        }
    };
    private static final int TICKS_MAX = 1000;
    private static final NumberFormat dfDoulbeNormalized = NumberFormat.getInstance((Locale)Locale.ENGLISH);
    private static int[] iaLinearDeltas;
    private static int[] iaLogarithmicDeltas;
    private static int[] iaCalendarUnits;
    private static int[] iaSecondDeltas;
    private static int[] iaMinuteDeltas;
    private static int[] iaHourDeltas;
    private static int[] iaDayDeltas;
    private static int[] iaMonthDeltas;
    private static int[][] iaCalendarDeltas;
    private boolean bIntegralZoom = true;
    private boolean bMinimumFixed = false;
    private boolean bMaximumFixed = false;
    private boolean bStepFixed = false;
    private int iScaleDirection = 0;
    private boolean bAxisLabelStaggered = false;
    private int iLabelShowingInterval = 0;
    private FormatSpecifier fs = null;
    private double dPrecision = 0.0;
    private int iMinUnit = 0;
    private static ILogger logger;

    static {
        try {
            ((DecimalFormat)dfDoulbeNormalized).applyPattern(".###############E0");
        }
        catch (ClassCastException classCastException) {}
        iaLinearDeltas = new int[]{1, 2, 5, 10};
        iaLogarithmicDeltas = new int[]{10};
        iaCalendarUnits = new int[]{13, 12, 11, 5, 2, 1};
        iaSecondDeltas = new int[]{1, 5, 10, 15, 20, 30};
        iaMinuteDeltas = new int[]{1, 5, 10, 15, 20, 30};
        iaHourDeltas = new int[]{1, 2, 3, 4, 12};
        iaDayDeltas = new int[]{1, 7, 14};
        iaMonthDeltas = new int[]{1, 2, 3, 4, 6};
        int[][] nArrayArray = new int[6][];
        nArrayArray[0] = iaSecondDeltas;
        nArrayArray[1] = iaMinuteDeltas;
        nArrayArray[2] = iaHourDeltas;
        nArrayArray[3] = iaDayDeltas;
        nArrayArray[4] = iaMonthDeltas;
        iaCalendarDeltas = nArrayArray;
        logger = Logger.getLogger("org.eclipse.birt.chart.engine/computation.withaxes");
    }

    AutoScale(int _iType) {
        this.iType = _iType;
    }

    public AutoScale(int _iType, Object _oMinimum, Object _oMaximum) {
        this.iType = _iType;
        this.oMinimum = _oMinimum;
        this.oMaximum = _oMaximum;
    }

    final void setFixed(boolean _bMinimum, boolean _bMaximum, boolean _bStep) {
        this.bMinimumFixed = _bMinimum;
        this.bMaximumFixed = _bMaximum;
        this.bStepFixed = _bStep;
    }

    public final void setDirection(int iValue) {
        this.iScaleDirection = iValue;
    }

    public int getDirection() {
        return this.iScaleDirection;
    }

    public final Object clone() {
        AutoScale sc = new AutoScale(this.iType, this.oMinimum, this.oMaximum);
        sc.oStep = this.oStep;
        sc.oStepNumber = this.oStepNumber;
        sc.dStart = this.dStart;
        sc.dEnd = this.dEnd;
        sc.oMaximumWithMargin = this.oMaximumWithMargin;
        sc.oMinimumWithMargin = this.oMinimumWithMargin;
        sc.iMarginPercent = this.iMarginPercent;
        sc.atcTickCoordinates = this.atcTickCoordinates;
        sc.dStartShift = this.dStartShift;
        sc.dEndShift = this.dEndShift;
        sc.dsiData = this.dsiData;
        sc.oUnit = this.oUnit;
        sc.bMaximumFixed = this.bMaximumFixed;
        sc.bMinimumFixed = this.bMinimumFixed;
        sc.oMaximumFixed = this.oMaximumFixed;
        sc.oMinimumFixed = this.oMinimumFixed;
        sc.bStepFixed = this.bStepFixed;
        sc.fs = this.fs;
        sc.rtc = this.rtc;
        sc.bIntegralZoom = this.bIntegralZoom;
        sc.bCategoryScale = this.bCategoryScale;
        sc.labelVisHelper = this.labelVisHelper;
        sc.iScaleDirection = this.iScaleDirection;
        sc.staggeredHelper = this.staggeredHelper;
        sc.bAxisLabelStaggered = this.bAxisLabelStaggered;
        sc.iLabelShowingInterval = this.iLabelShowingInterval;
        sc.bTickBetweenCategories = this.bTickBetweenCategories;
        sc.bLabelWithinAxes = this.bLabelWithinAxes;
        sc.iMinUnit = this.iMinUnit;
        sc.hmComputedLabelText = sc.hmComputedLabelText;
        sc.tmpSC = this.tmpSC;
        sc.dZoomFactor = this.dZoomFactor;
        sc.cacheNumFormat = this.cacheNumFormat;
        sc.cacheDateFormat = this.cacheDateFormat;
        sc.dPrecision = this.dPrecision;
        return sc;
    }

    public final boolean zoomIn() {
        block24: {
            block21: {
                double dStep;
                block22: {
                    double dStep2;
                    block23: {
                        if (this.bStepFixed) {
                            return false;
                        }
                        if (ChartUtil.mathEqual(0.0, ((Number)this.oStep).doubleValue())) {
                            return false;
                        }
                        if ((this.iType & 1) != 1) break block21;
                        if ((this.iType & 4) != 4) break block22;
                        dStep2 = AutoScale.asDouble(this.oStep);
                        if (!(Math.log(dStep2) / LOG_10 > 1.0)) break block23;
                        this.setStep(new Double(dStep2 / 10.0));
                        break block24;
                    }
                    int n = iaLogarithmicDeltas.length;
                    int i = n - 1;
                    while (i >= 0) {
                        if ((int)dStep2 == iaLogarithmicDeltas[i]) {
                            if (i > 0) {
                                this.setStep(new Double(iaLogarithmicDeltas[i - 1]));
                                return true;
                            }
                            return false;
                        }
                        --i;
                    }
                    return false;
                }
                if ((this.iType & 2) != 2) break block24;
                double oldStep = dStep = AutoScale.asDouble(this.oStep).doubleValue();
                if (this.bIntegralZoom) {
                    double dPower = Math.log(dStep) / LOG_10;
                    dPower = Math.floor(dPower);
                    dPower = Math.pow(10.0, dPower);
                    dStep /= dPower;
                    dStep = Math.round(dStep);
                    int n = iaLinearDeltas.length;
                    int i = 0;
                    while (i < n) {
                        if ((int)dStep == iaLinearDeltas[i]) {
                            if (i > 0) {
                                dStep = (double)iaLinearDeltas[i - 1] * dPower;
                                break;
                            }
                            dStep = (double)iaLinearDeltas[n - 2] * (dPower /= 10.0);
                            break;
                        }
                        ++i;
                    }
                    if (dStep == oldStep) {
                        dStep /= 2.0;
                    }
                    this.setStep(new Double(dStep));
                } else {
                    this.setStep(new Double(dStep /= 2.0));
                }
                if (((Number)this.oStep).doubleValue() < this.dPrecision) {
                    this.setStep(new Double(oldStep));
                    return false;
                }
                break block24;
            }
            if ((this.iType & 8) == 8) {
                int[] ia = null;
                int iStep = AutoScale.asInteger(this.oStep);
                int iUnit = AutoScale.asInteger(this.oUnit);
                int icu = 0;
                while (icu < iaCalendarUnits.length) {
                    if (iUnit == iaCalendarUnits[icu]) {
                        ia = iaCalendarDeltas[icu];
                        if (ia == null) {
                            if (--iStep == 0) {
                                this.setStep(new Integer(iaMonthDeltas[iaMonthDeltas.length - 1]));
                                this.oUnit = new Integer(2);
                            }
                        } else {
                            int i = 0;
                            while (i < ia.length) {
                                if (ia[i] == iStep) break;
                                ++i;
                            }
                            if (i == 0) {
                                if (icu <= this.iMinUnit) {
                                    return false;
                                }
                                ia = iaCalendarDeltas[icu - 1];
                                i = ia.length;
                                this.oUnit = new Integer(iaCalendarUnits[icu - 1]);
                            }
                            this.setStep(new Integer(ia[i - 1]));
                            break;
                        }
                    }
                    ++icu;
                }
            }
        }
        return true;
    }

    public final boolean zoomOut() {
        block23: {
            block20: {
                block21: {
                    double dStep;
                    block22: {
                        if (this.bStepFixed || this.getTickCordinates().size() < 3) {
                            return false;
                        }
                        if (((Number)this.oStep).doubleValue() >= Double.MAX_VALUE) {
                            return false;
                        }
                        if ((this.iType & 1) != 1) break block20;
                        if ((this.iType & 4) != 4) break block21;
                        dStep = AutoScale.asDouble(this.oStep);
                        if (!(Math.log(dStep) / LOG_10 >= 1.0)) break block22;
                        this.setStep(new Double(dStep * 10.0));
                        break block23;
                    }
                    int n = iaLogarithmicDeltas.length;
                    int i = 0;
                    while (i < n) {
                        if ((int)dStep == iaLogarithmicDeltas[i]) {
                            this.setStep(new Double(iaLogarithmicDeltas[i + 1]));
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                if ((this.iType & 2) != 2) break block23;
                double dStep = AutoScale.asDouble(this.oStep);
                if (this.bIntegralZoom) {
                    double dPower = Math.log10(dStep);
                    if (dPower < 0.0) {
                        dPower = Math.floor(dPower);
                        dPower = Math.pow(10.0, dPower);
                    } else {
                        dPower = dStep;
                    }
                    dStep /= dPower;
                    dStep = Math.round(dStep);
                    int n = iaLinearDeltas.length;
                    int i = 0;
                    while (i < n) {
                        if (dStep < (double)iaLinearDeltas[i]) {
                            dStep = (double)iaLinearDeltas[i] * dPower;
                            break;
                        }
                        ++i;
                    }
                    if (i == n) {
                        dStep = (double)iaLinearDeltas[0] * (dPower *= 20.0);
                    }
                    if (((Number)this.oStep).doubleValue() == dStep) {
                        return false;
                    }
                } else {
                    dStep *= 2.0;
                }
                dStep = ChartUtil.alignWithInt(dStep, false);
                this.setStep(new Double(dStep));
                break block23;
            }
            if ((this.iType & 8) == 8) {
                int[] ia = null;
                int iStep = AutoScale.asInteger(this.oStep);
                int iUnit = AutoScale.asInteger(this.oUnit);
                int icu = 0;
                while (icu < iaCalendarUnits.length) {
                    if (iUnit == iaCalendarUnits[icu]) {
                        ia = iaCalendarDeltas[icu];
                        if (ia == null) {
                            this.setStep(new Integer(++iStep));
                        } else {
                            int i = 0;
                            int n = ia.length;
                            while (i < n) {
                                if (ia[i] == iStep) break;
                                ++i;
                            }
                            if (i == n - 1) {
                                ia = iaCalendarDeltas[icu + 1];
                                this.oUnit = new Integer(iaCalendarUnits[icu + 1]);
                                if (ia == null) {
                                    this.setStep(new Integer(1));
                                    return true;
                                }
                                i = -1;
                            }
                            this.setStep(new Integer(ia[i + 1]));
                            break;
                        }
                    }
                    ++icu;
                }
            }
        }
        return true;
    }

    public final String getNumericPattern() {
        if (this.oMinimum == null || this.oStep == null) {
            return "0.00";
        }
        double dMinValue = AutoScale.asDouble(this.oMinimum);
        double dStep = AutoScale.asDouble(this.oStep);
        if ((this.iType & 4) == 4) {
            return ValueFormatter.getNumericPattern(dMinValue);
        }
        return ValueFormatter.getNumericPattern(dStep);
    }

    public final int getType() {
        return this.iType;
    }

    public final void setData(DataSetIterator _oaData) {
        this.dsiData = _oaData;
    }

    public final FormatSpecifier getFormatSpecifier() {
        return this.fs;
    }

    public final void setFormatSpecifier(FormatSpecifier fs) {
        this.fs = fs;
    }

    public final Object getUnit() {
        return this.oUnit;
    }

    public final DataSetIterator getData() {
        return this.dsiData;
    }

    final void setTickCordinates(AxisTickCoordinates atc) {
        if (atc != null && atc.size() == 1) {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.tick.computations", Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        this.atcTickCoordinates = atc;
    }

    public final boolean isTickLabelVisible(int index) {
        assert (this.labelVisHelper != null);
        return this.labelVisHelper.isTickLabelVisible(index);
    }

    public final String getComputedLabelText(int index) {
        assert (this.hmComputedLabelText != null);
        return this.hmComputedLabelText.get(index);
    }

    public final Collection<Integer> getVisibleLabelIds() {
        return this.hmComputedLabelText.keySet();
    }

    public final boolean isTickLabelStaggered(int index) {
        assert (this.staggeredHelper != null);
        return this.staggeredHelper.isTickLabelStaggered(index);
    }

    public final boolean isAxisLabelStaggered() {
        return this.bAxisLabelStaggered;
    }

    public final boolean isTickBetweenCategories() {
        return this.bTickBetweenCategories;
    }

    public final AxisTickCoordinates getTickCordinates() {
        return this.atcTickCoordinates;
    }

    public final double getNormalizedStart() {
        return 0.0;
    }

    public final double getNormalizedEnd() {
        return this.dEnd - this.dStart;
    }

    public final double[] getNormalizedEndPoints() {
        return new double[]{0.0, this.dEnd - this.dStart};
    }

    public final double[] getEndPoints() {
        return new double[]{this.dStart, this.dEnd};
    }

    final void setEndPoints(double _dStart, double _dEnd) {
        if (_dStart != -1.0) {
            this.dStart = _dStart;
        }
        if (_dEnd != -1.0) {
            this.dEnd = _dEnd;
        }
        if (this.atcTickCoordinates != null) {
            this.atcTickCoordinates.setEndPoints(this.dStart, this.dEnd);
        }
    }

    private void checkValible(double dValue, String sName) throws ChartException {
        if (Double.isInfinite(dValue)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, String.valueOf(sName) + Messages.getString("AutoScale.Exception.IsInfiite"), Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (Double.isNaN(dValue)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, String.valueOf(sName) + Messages.getString("AutoScale.Exception.IsNaN"), Messages.getResourceBundle(this.rtc.getULocale()));
        }
    }

    public final int getTickCount() throws ChartException {
        if (this.oStepNumber != null) {
            if (this.bCategoryScale || (this.iType & 1) != 1) {
                logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unsupported.step.number", Messages.getResourceBundle(this.rtc.getULocale()))));
            } else {
                return this.oStepNumber + 1;
            }
        }
        int nTicks = 2;
        if (this.isCategoryScale()) {
            if (this.dsiData != null) {
                nTicks = this.dsiData.size() + 1;
                if (!this.bTickBetweenCategories) {
                    ++nTicks;
                }
            }
        } else if ((this.iType & 1) == 1) {
            if ((this.iType & 2) == 2) {
                double dMax = AutoScale.asDouble(this.oMaximum);
                double dMin = AutoScale.asDouble(this.oMinimum);
                double dStep = AutoScale.asDouble(this.oStep);
                if (!ChartUtil.mathEqual(dMax, dMin)) {
                    double lNTicks = Math.ceil((dMax - dMin) / dStep - 0.5) + 1.0;
                    if (lNTicks > 1000.0 || lNTicks < 2.0) {
                        nTicks = lNTicks > 1000.0 ? 1000 : 2;
                        dStep = dMax / (double)(nTicks - 1) - dMin / (double)(nTicks - 1);
                        this.checkValible(dStep, Messages.getString("AutoScale.ValueName.StepSize"));
                        dStep = ChartUtil.alignWithInt(dStep, true);
                        this.setStep(new Double(dStep));
                    } else {
                        nTicks = (int)lNTicks;
                    }
                } else {
                    nTicks = 5;
                }
            } else if ((this.iType & 4) == 4) {
                double dMax = AutoScale.asDouble(this.oMaximum);
                double dMin = AutoScale.asDouble(this.oMinimum);
                double dStep = AutoScale.asDouble(this.oStep);
                double dMaxLog = Math.log(dMax) / LOG_10;
                double dMinLog = Math.log(dMin) / LOG_10;
                double dStepLog = Math.log(dStep) / LOG_10;
                nTicks = (int)Math.ceil((dMaxLog - dMinLog) / dStepLog) + 1;
            }
        } else if ((this.iType & 8) == 8) {
            CDateTime cdt1 = (CDateTime)((Object)this.oMinimum);
            CDateTime cdt2 = (CDateTime)((Object)this.oMaximum);
            double diff = CDateTime.computeDifference(cdt2, cdt1, AutoScale.asInteger(this.oUnit)) / (double)AutoScale.asInteger(this.oStep);
            nTicks = (int)Math.round(diff) + 1;
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unknown.axis.type.tick.computations", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (nTicks < 2) {
            nTicks = 2;
        }
        return nTicks;
    }

    public final double getUnitSize() {
        if (this.atcTickCoordinates == null) {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.unit.size.failure", Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        return Math.abs(this.atcTickCoordinates.getStep());
    }

    public final Object getMinimum() {
        return this.oMinimum;
    }

    public final void setMinimum(Object o) {
        this.oMinimum = o;
    }

    public final Object getMaximum() {
        return this.oMaximum;
    }

    public final void setMaximum(Object o) {
        this.oMaximum = o;
    }

    public final Object getStep() {
        return this.oStep;
    }

    public final void setStep(Object o) {
        this.oStep = o;
    }

    public final Integer getStepNumber() {
        return this.oStepNumber;
    }

    public final void setStepNumber(Integer o) {
        this.oStepNumber = o;
    }

    final Object[] getMinMax() throws ChartException {
        Object oValue = null;
        try {
            if ((this.iType & 1) == 1) {
                double dMinValue = Double.MAX_VALUE;
                double dMaxValue = -1.7976931348623157E308;
                this.dsiData.reset();
                while (this.dsiData.hasNext()) {
                    oValue = this.dsiData.next();
                    if (oValue == null) continue;
                    double dValue = (Double)oValue;
                    if (dValue < dMinValue) {
                        dMinValue = dValue;
                    }
                    if (!(dValue > dMaxValue)) continue;
                    dMaxValue = dValue;
                }
                return new Object[]{new Double(dMinValue), new Double(dMaxValue)};
            }
            if ((this.iType & 8) == 8) {
                Calendar caMin = null;
                Calendar caMax = null;
                this.dsiData.reset();
                while (this.dsiData.hasNext()) {
                    oValue = this.dsiData.next();
                    Calendar cValue = (Calendar)oValue;
                    if (caMin == null) {
                        caMin = cValue;
                    }
                    if (caMax == null) {
                        caMax = cValue;
                    }
                    if (cValue == null) continue;
                    if (cValue.before((Object)caMin)) {
                        caMin = cValue;
                        continue;
                    }
                    if (!cValue.after((Object)caMax)) continue;
                    caMax = cValue;
                }
                return new Object[]{new CDateTime(caMin), new CDateTime(caMax)};
            }
        }
        catch (ClassCastException classCastException) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.axis.data.type", new Object[]{oValue}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        return null;
    }

    public final void updateAxisMinMax(Object oMinValue, Object oMaxValue) {
        ScaleContext sct;
        if (this.rtc.getScale() != null && this.rtc.getScale().isShared()) {
            this.updateContext(this.rtc.getScale());
            return;
        }
        if (this.rtc.getScale() != null) {
            oMinValue = this.rtc.getScale().getMin();
            oMaxValue = this.rtc.getScale().getMax();
        }
        if ((this.iType & 4) == 4) {
            if ((this.iType & 0x20) == 32) {
                this.oMaximum = new Double(100.0);
                this.oMinimum = new Double(1.0);
                this.setStep(new Double(10.0));
                this.bMaximumFixed = true;
                this.bMinimumFixed = true;
                this.bStepFixed = true;
                return;
            }
            sct = new ScaleContext(this.iMarginPercent, this.iType, oMinValue, oMaxValue, this.oStep);
        } else if ((this.iType & 8) == 8) {
            int iUnit = AutoScale.asInteger(this.oUnit);
            sct = new ScaleContext(this.iMarginPercent, this.iType, iUnit, oMinValue, oMaxValue, this.oStep);
        } else {
            sct = new ScaleContext(this.iMarginPercent, this.iType, oMinValue, oMaxValue, this.oStep);
        }
        if ((this.iType & 8) == 8) {
            sct.setFixedValue(this.bMinimumFixed, this.bMaximumFixed, this.oMinimumFixed, this.oMaximumFixed);
        } else {
            sct.setFixedValue(this.bMinimumFixed, this.bMaximumFixed, this.oMinimum, this.oMaximum);
        }
        sct.setFixedStep(this.bStepFixed, this.oStepNumber);
        sct.computeMinMax();
        this.updateContext(sct);
        this.tmpSC = sct;
        AutoScale.updateSharedScaleContext(this.rtc, this.iType, this.tmpSC);
    }

    private final void updateContext(ScaleContext sct) {
        this.oMaximum = sct.getMax();
        this.oMinimum = sct.getMin();
        this.oMaximumWithMargin = sct.getMaxWithMargin();
        this.oMinimumWithMargin = sct.getMinWithMargin();
        this.setStep(sct.getStep());
        this.oUnit = sct.getUnit();
    }

    Object getMinWithMargin() {
        return this.oMinimumWithMargin;
    }

    Object getMaxWithMargin() {
        return this.oMaximumWithMargin;
    }

    public final boolean checkFit(IDisplayServer xs, Label la, int iLabelLocation) throws ChartException {
        block41: {
            Double fontHeight;
            RotatedRectangle rrPrev2;
            RotatedRectangle rrPrev;
            AxisTickCoordinates da;
            int iPointToCheck;
            double y;
            double x;
            block42: {
                block40: {
                    if (this.isCategoryScale()) {
                        return true;
                    }
                    double dAngleInDegrees = la.getCaption().getFont().getRotation();
                    x = 0.0;
                    y = 0.0;
                    iPointToCheck = 0;
                    if (iLabelLocation == 4 || iLabelLocation == 8) {
                        iPointToCheck = this.iScaleDirection == -1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 1 : 2) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 3 : 0);
                    } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                        iPointToCheck = this.iScaleDirection == 1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 0 : 1) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 2 : 3);
                    }
                    da = this.atcTickCoordinates;
                    rrPrev = null;
                    rrPrev2 = null;
                    fontHeight = Methods.computeFontHeight(xs, la);
                    if ((this.iType & 3) != 3) break block40;
                    double dAxisValue = AutoScale.asDouble(this.getMinimum());
                    double dAxisStep = AutoScale.asDouble(this.getStep());
                    DecimalFormat df = null;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    NumberDataElement nde = NumberDataElementImpl.create(0.0);
                    int i = 0;
                    while (i < da.size()) {
                        RotatedRectangle rr;
                        String sText;
                        nde.setValue(dAxisValue);
                        try {
                            sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                        }
                        catch (ChartException dfex) {
                            logger.log((Exception)((Object)dfex));
                            sText = NULL_STRING;
                        }
                        if (iLabelLocation == 4 || iLabelLocation == 8) {
                            x = da.getCoordinate(i) * this.dZoomFactor;
                        } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                            y = da.getCoordinate(i) * this.dZoomFactor;
                        }
                        la.getCaption().setValue(sText);
                        try {
                            rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y, fontHeight);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                        }
                        Point p = rr.getPoint(iPointToCheck);
                        if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                            if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                                return false;
                            }
                            rrPrev2 = rr;
                        } else {
                            if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev))) {
                                return false;
                            }
                            rrPrev = rr;
                        }
                        dAxisValue += dAxisStep;
                        ++i;
                    }
                    break block41;
                }
                if ((this.iType & 5) != 5) break block42;
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size() - 1) {
                    RotatedRectangle rr;
                    String sText;
                    nde.setValue(dAxisValue);
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = NULL_STRING;
                    }
                    if (iLabelLocation == 4 || iLabelLocation == 8) {
                        x = da.getCoordinate(i) * this.dZoomFactor;
                    } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                        y = da.getCoordinate(i) * this.dZoomFactor;
                    }
                    la.getCaption().setValue(sText);
                    try {
                        rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y, fontHeight);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                    }
                    Point p = rr.getPoint(iPointToCheck);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                            return false;
                        }
                        rrPrev2 = rr;
                    } else {
                        if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p))) {
                            return false;
                        }
                        rrPrev = rr;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
                break block41;
            }
            if (this.iType != 8) break block41;
            CDateTime cdtAxisValue = AutoScale.asDateTime(this.oMinimum);
            int iUnit = AutoScale.asInteger(this.oUnit);
            int iStep = AutoScale.asInteger(this.oStep);
            IDateFormatWrapper sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
            CDateTime cdt = cdtAxisValue;
            int i = 0;
            while (i < da.size() - 1) {
                RotatedRectangle rr;
                String sText = ValueFormatter.format((Object)cdt, this.fs, this.rtc.getULocale(), sdf);
                if (iLabelLocation == 4 || iLabelLocation == 8) {
                    x = da.getCoordinate(i) * this.dZoomFactor;
                } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                    y = da.getCoordinate(i) * this.dZoomFactor;
                }
                la.getCaption().setValue(sText);
                try {
                    rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y, fontHeight);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                Point p = rr.getPoint(iPointToCheck);
                if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                    if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                        return false;
                    }
                    rrPrev2 = rr;
                } else {
                    if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p))) {
                        return false;
                    }
                    rrPrev = rr;
                }
                cdt = cdtAxisValue.forward(iUnit, iStep * (i + 1));
                ++i;
            }
        }
        return true;
    }

    private CateLabVisTester createCateLabVisTester(IDisplayServer xs, Label la, int iLabelLocation) {
        double dAngleInDegrees = la.getCaption().getFont().getRotation();
        int iNewPointToCheck = 0;
        int iPrevPointToCheck = 0;
        boolean isNegativeRotation = dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0;
        switch (iLabelLocation) {
            case 4: {
                iNewPointToCheck = isNegativeRotation ? 3 : 0;
                iPrevPointToCheck = isNegativeRotation ? 1 : 3;
                break;
            }
            case 8: {
                int n = isNegativeRotation ? (this.iScaleDirection == -1 ? 1 : 3) : (iNewPointToCheck = this.iScaleDirection == -1 ? 2 : 0);
                iPrevPointToCheck = isNegativeRotation ? (this.iScaleDirection == -1 ? 2 : 0) : (this.iScaleDirection == -1 ? 0 : 2);
                break;
            }
            case 1: {
                iNewPointToCheck = this.iScaleDirection == 1 ? 1 : 2;
                iPrevPointToCheck = this.iScaleDirection == 1 ? 2 : 1;
                break;
            }
            case 2: {
                iNewPointToCheck = this.iScaleDirection == 1 ? 0 : 3;
                iPrevPointToCheck = this.iScaleDirection == 1 ? 3 : 0;
            }
        }
        return new CateLabVisTester(iLabelLocation, iNewPointToCheck, iPrevPointToCheck, la, xs);
    }

    protected final void checkTickLabelsVisibility(IDisplayServer xs, Label la, int iLabelLocation) throws ChartException {
        boolean vis;
        this.hmComputedLabelText = new HashMap<Integer, String>();
        boolean bl = vis = la.isSetVisible() && la.isVisible();
        if (!vis && this.rtc.getScale() != null) {
            vis = true;
        }
        boolean staggerEnabled = this.isAxisLabelStaggered();
        this.staggeredHelper = StaggeredHelper.createInstance(staggerEnabled, this.atcTickCoordinates.size(), this.iLabelShowingInterval);
        this.labelVisHelper = LabelVisibleHelper.createInstance(vis, this.isCategoryScale(), this.atcTickCoordinates.size(), this.iLabelShowingInterval);
        if (!vis || !this.isCategoryScale()) {
            return;
        }
        DataSetIterator dsi = this.getData();
        dsi.reset();
        int iDateTimeUnit = this.iType == 8 ? CDateTime.computeUnit(dsi) : 0;
        dsi.reset();
        CateLabVisTester tester = this.createCateLabVisTester(xs, la, iLabelLocation);
        EllipsisHelper eHelper = new EllipsisHelper(tester, la.getEllipsis());
        int start_id = this.isTickBetweenCategories() ? 0 : 1;
        RotatedRectangle[] rrPrev = new RotatedRectangle[2];
        double dStep = Math.abs(this.atcTickCoordinates.getStep() * this.dZoomFactor);
        int indexStep = dStep > 1.0 ? 1 : (int)(1.0 / dStep);
        int i = start_id;
        while (i < this.atcTickCoordinates.size() - 1) {
            Object oValue = null;
            if (dsi.hasNext()) {
                oValue = dsi.next();
            }
            if (this.labelVisHelper.shouldTickLabelVisible(i)) {
                boolean bVis;
                int arrayIndex;
                double x = 0.0;
                double y = 0.0;
                String sText = this.formatCategoryValue(this.iType, oValue, iDateTimeUnit);
                if (iLabelLocation == 4 || iLabelLocation == 8) {
                    x = this.atcTickCoordinates.getCoordinate(i) * this.dZoomFactor;
                } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                    y = this.atcTickCoordinates.getCoordinate(i) * this.dZoomFactor;
                }
                la.getCaption().setValue(sText);
                RotatedRectangle rrCurr = null;
                int n = arrayIndex = this.isAxisLabelStaggered() && this.isTickLabelStaggered(i) ? 1 : 0;
                if (rrPrev[arrayIndex] == null) {
                    rrCurr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
                    bVis = true;
                } else {
                    tester.setFPara(rrPrev[arrayIndex], x, y);
                    bVis = eHelper.checkLabelEllipsis(sText, null);
                    rrCurr = tester.getCurrentRR();
                }
                if (bVis) {
                    this.labelVisHelper.addVisible(i);
                    rrPrev[arrayIndex] = rrCurr;
                    this.hmComputedLabelText.put(i, la.getCaption().getValue());
                }
            }
            i += indexStep;
        }
    }

    protected boolean quickCheckVisibility(int iLabelLocation, Point previousPoint, double x, double y) {
        return !(iLabelLocation == 4 || iLabelLocation == 8 ? this.iScaleDirection == -1 && previousPoint.getX() < x || this.iScaleDirection != -1 && previousPoint.getX() > x : (iLabelLocation == 1 || iLabelLocation == 2) && (this.iScaleDirection == 1 && previousPoint.getY() > y || this.iScaleDirection != 1 && previousPoint.getY() < y));
    }

    final void resetShifts() {
        this.dStartShift = 0.0;
        this.dEndShift = 0.0;
    }

    public final double getStart() {
        return this.dStart;
    }

    public final double getEnd() {
        return this.dEnd;
    }

    final double getStartShift() {
        return this.dStartShift;
    }

    final double getEndShift() {
        return this.dEndShift;
    }

    static final AutoScale computeScale(IDisplayServer xs, OneAxis ax, DataSetIterator dsi, int iType, double dStart, double dEnd, Scale scModel, FormatSpecifier fs, RunTimeContext rtc, int direction, double zoomFactor, int iMarginPercent) throws ChartException {
        return AutoScale.computeScale(xs, ax, dsi, iType, dStart, dEnd, scModel, null, fs, rtc, direction, zoomFactor, iMarginPercent);
    }

    static final AutoScale computeScale(IDisplayServer xs, OneAxis ax, DataSetIterator dsi, int iType, double dStart, double dEnd, Scale scModel, AxisOrigin axisOrigin, FormatSpecifier fs, RunTimeContext rtc, int direction, double zoomFactor, int iMarginPercent) throws ChartException {
        Object oValue;
        Object oMaxValue;
        Object oMinValue;
        Label la = ax.getLabel();
        int iLabelLocation = ax.getLabelPosition();
        int iOrientation = ax.getOrientation();
        DataElement oMinimum = scModel.getMin();
        DataElement oMaximum = scModel.getMax();
        Double oStep = scModel.isSetStep() ? new Double(scModel.getStep()) : null;
        Integer oStepNumber = scModel.isSetStepNumber() ? new Integer(scModel.getStepNumber()) : null;
        AutoScale sc = null;
        AutoScale scCloned = null;
        boolean bIsPercent = ax.getModelAxis().isPercent();
        if ((iType & 0x10) == 16 || ax.isCategoryScale()) {
            sc = new AutoScale(iType);
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bCategoryScale = true;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.bTickBetweenCategories = ax.isTickBwtweenCategories();
            sc.dZoomFactor = zoomFactor;
            sc.iMarginPercent = iMarginPercent;
            sc.setData(dsi);
            sc.setDirection(direction);
            sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
            oMinValue = null;
            oMaxValue = null;
        } else if ((iType & 2) == 2) {
            double dMinValue = Double.MAX_VALUE;
            double dMaxValue = -1.7976931348623157E308;
            dsi.reset();
            double dPrecision = 0.0;
            while (dsi.hasNext()) {
                oValue = dsi.next();
                if (oValue == null) continue;
                double dValue = (Double)oValue;
                if (dValue < dMinValue) {
                    dMinValue = dValue;
                }
                if (dValue > dMaxValue) {
                    dMaxValue = dValue;
                }
                dPrecision = AutoScale.getPrecision(dPrecision, dValue, fs, rtc.getULocale(), bIsPercent);
            }
            if (axisOrigin != null && ((Object)((Object)axisOrigin.getType())).equals((Object)IntersectionType.VALUE_LITERAL) && axisOrigin.getValue() instanceof NumberDataElement) {
                double origin = AutoScale.asDouble(axisOrigin.getValue());
                if (oMinimum == null && origin < dMinValue) {
                    oMinimum = axisOrigin.getValue();
                }
                if (oMaximum == null && origin > dMaxValue) {
                    oMaximum = axisOrigin.getValue();
                }
            }
            double dAbsMax = Math.abs(dMaxValue);
            double dAbsMin = Math.abs(dMinValue);
            double dStep = Math.max(dAbsMax, dAbsMin);
            double dDelta = dMaxValue - dMinValue;
            if (dDelta == 0.0) {
                dStep = dPrecision;
            } else {
                dStep = Math.floor(Math.log(dDelta) / LOG_10);
                if ((dStep = Math.pow(10.0, dStep)) < dPrecision) {
                    dStep = dPrecision;
                }
            }
            sc = new AutoScale(iType, new Double(0.0), new Double(0.0));
            sc.setStep(new Double(dStep));
            sc.oStepNumber = oStepNumber;
            sc.setData(dsi);
            sc.setDirection(direction);
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.bTickBetweenCategories = ax.isTickBwtweenCategories();
            sc.dZoomFactor = zoomFactor;
            sc.dPrecision = dPrecision;
            sc.iMarginPercent = iMarginPercent;
            AutoScale.setNumberMinMaxToScale(sc, oMinimum, oMaximum, rtc, ax);
            AutoScale.setStepToScale(sc, oStep, oStepNumber, rtc);
            oMinValue = new Double(dMinValue);
            oMaxValue = new Double(dMaxValue);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
        } else if ((iType & 4) == 4) {
            double dMinValue = Double.MAX_VALUE;
            double dMaxValue = -1.7976931348623157E308;
            if ((iType & 0x20) == 32) {
                dMinValue = 0.0;
                dMaxValue = 100.0;
            } else {
                dsi.reset();
                while (dsi.hasNext()) {
                    oValue = dsi.next();
                    if (oValue == null) continue;
                    double dValue = (Double)oValue;
                    if (dValue < dMinValue) {
                        dMinValue = dValue;
                    }
                    if (!(dValue > dMaxValue)) continue;
                    dMaxValue = dValue;
                }
                if (axisOrigin != null && ((Object)((Object)axisOrigin.getType())).equals((Object)IntersectionType.VALUE_LITERAL) && axisOrigin.getValue() instanceof NumberDataElement) {
                    double origin = AutoScale.asDouble(axisOrigin.getValue());
                    if (oMinimum == null && origin < dMinValue) {
                        oMinimum = axisOrigin.getValue();
                    }
                    if (oMaximum == null && origin > dMaxValue) {
                        oMaximum = axisOrigin.getValue();
                    }
                }
                if (dMinValue == 0.0) {
                    dMinValue = dMaxValue > 0.0 ? 1 : -1;
                }
            }
            sc = new AutoScale(iType, new Double(0.0), new Double(0.0));
            sc.setStep(new Double(10.0));
            sc.oStepNumber = oStepNumber;
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.bTickBetweenCategories = ax.isTickBwtweenCategories();
            sc.dZoomFactor = zoomFactor;
            sc.iMarginPercent = iMarginPercent;
            sc.setData(dsi);
            sc.setDirection(direction);
            AutoScale.setNumberMinMaxToScale(sc, oMinimum, oMaximum, rtc, ax);
            AutoScale.setStepToScale(sc, oStep, oStepNumber, rtc);
            oMinValue = new Double(dMinValue);
            oMaxValue = new Double(dMaxValue);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
            if ((iType & 0x20) == 32) {
                sc.bStepFixed = true;
                sc.bMaximumFixed = true;
                sc.bMinimumFixed = true;
                sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
                return sc;
            }
        } else if ((iType & 8) == 8) {
            int iUnit;
            Calendar caMin = null;
            Calendar caMax = null;
            dsi.reset();
            while (dsi.hasNext()) {
                Calendar cValue = (Calendar)dsi.next();
                if (cValue == null) continue;
                if (caMin == null) {
                    caMin = cValue;
                }
                if (caMax == null) {
                    caMax = cValue;
                }
                if (cValue.before((Object)caMin)) {
                    caMin = cValue;
                    continue;
                }
                if (!cValue.after((Object)caMax)) continue;
                caMax = cValue;
            }
            oMinValue = new CDateTime(caMin);
            oMaxValue = new CDateTime(caMax);
            if (axisOrigin != null && ((Object)((Object)axisOrigin.getType())).equals((Object)IntersectionType.VALUE_LITERAL) && axisOrigin.getValue() instanceof DateTimeDataElement) {
                CDateTime origin = AutoScale.asDateTime(axisOrigin.getValue());
                if (oMinimum == null && origin.before(oMinValue)) {
                    oMinimum = axisOrigin.getValue();
                }
                if (oMaximum == null && origin.after(oMaxValue)) {
                    oMaximum = axisOrigin.getValue();
                }
            }
            if ((iUnit = oStep != null || oStepNumber != null ? ChartUtil.convertUnitTypeToCalendarConstant(scModel.getUnit()) : CDateTime.getPreferredUnit(oMinValue, oMaxValue)) == 0) {
                iUnit = 13;
            }
            CDateTime cdtMinAxis = oMinValue.backward(iUnit, 1);
            CDateTime cdtMaxAxis = oMaxValue.forward(iUnit, 1);
            cdtMinAxis.clearBelow(iUnit);
            cdtMaxAxis.clearBelow(iUnit);
            sc = new AutoScale(8, (Object)cdtMinAxis, (Object)cdtMaxAxis);
            sc.setStep(new Integer(1));
            sc.oStepNumber = oStepNumber;
            sc.oUnit = new Integer(iUnit);
            sc.iMinUnit = ((Object)oMinValue).equals(oMaxValue) ? AutoScale.getUnitId(iUnit) : AutoScale.getMinUnitId(fs, rtc);
            sc.setDirection(direction);
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.bTickBetweenCategories = ax.isTickBwtweenCategories();
            sc.dZoomFactor = zoomFactor;
            sc.iMarginPercent = iMarginPercent;
            if (oMinimum != null) {
                if (!(oMinimum instanceof DateTimeDataElement)) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.minimum.scale.value", new Object[]{oMinimum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
                }
                sc.oMinimum = ((DateTimeDataElement)oMinimum).getValueAsCDateTime();
                sc.oMinimumFixed = ((DateTimeDataElement)oMinimum).getValueAsCDateTime();
                sc.bMinimumFixed = true;
            }
            if (oMaximum != null) {
                if (!(oMaximum instanceof DateTimeDataElement)) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.maximum.scale.value", new Object[]{sc.oMaximum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
                }
                sc.oMaximum = ((DateTimeDataElement)oMaximum).getValueAsCDateTime();
                sc.oMaximumFixed = ((DateTimeDataElement)oMaximum).getValueAsCDateTime();
                sc.bMaximumFixed = true;
            }
            if (sc.bMaximumFixed && sc.bMinimumFixed && ((CDateTime)((Object)sc.oMinimum)).after(sc.oMaximum)) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.min.largerthan.max", new Object[]{sc.oMinimum, sc.oMaximum}, Messages.getResourceBundle(rtc.getULocale()));
            }
            AutoScale.setStepToScale(sc, oStep, oStepNumber, rtc);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
        } else {
            oMinValue = null;
            oMaxValue = null;
        }
        sc.bLabelWithinAxes = ax.getModelAxis().isLabelWithinAxes();
        if ((iType & 0x10) != 16 && !ax.isCategoryScale()) {
            boolean bFirstFit;
            sc.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, false, null);
            dStart = sc.dStart;
            dEnd = sc.dEnd;
            boolean bFits = bFirstFit = sc.checkFit(xs, la, iLabelLocation);
            boolean bZoomSuccess = false;
            int i = 0;
            while (bFits == bFirstFit && i < 50) {
                bZoomSuccess = true;
                scCloned = (AutoScale)sc.clone();
                if (sc.bStepFixed || rtc.getScale() != null && rtc.getScale().isShared()) break;
                if (bFirstFit) {
                    if (!bFits) break;
                    bZoomSuccess = sc.zoomIn();
                } else {
                    if (!bFits && sc.getTickCordinates().size() == 2) break;
                    bZoomSuccess = sc.zoomOut();
                }
                if (!bZoomSuccess) break;
                sc.updateAxisMinMax(oMinValue, oMaxValue);
                sc.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, false, null);
                bFits = sc.checkFit(xs, la, iLabelLocation);
                if (!bFits && sc.getTickCordinates().size() == 2) {
                    sc = scCloned;
                    break;
                }
                ++i;
            }
            if (scCloned != null && bFirstFit && bZoomSuccess) {
                sc = scCloned;
            }
            AutoScale.updateSharedScaleContext(rtc, iType, sc.tmpSC);
        }
        sc.setData(dsi);
        return sc;
    }

    private static double getValidDouble(double dValue) {
        String sValue = dfDoulbeNormalized.format(dValue);
        double dNewValue = Double.valueOf(sValue);
        return dNewValue;
    }

    private static int getMinUnitId(FormatSpecifier fs, RunTimeContext rtc) throws ChartException {
        int iUnit = 0;
        CDateTime cdt = new CDateTime(7, 6, 5, 4, 3, 2);
        String sDate = ValueFormatter.format((Object)cdt, fs, rtc.getULocale(), null);
        int i = 0;
        while (i < iaCalendarUnits.length) {
            cdt.set(iaCalendarUnits[i], 1);
            String sDatei = ValueFormatter.format((Object)cdt, fs, rtc.getULocale(), null);
            if (!sDate.equals(sDatei)) {
                iUnit = i;
                break;
            }
            ++i;
        }
        return iUnit;
    }

    public static int getMinUnit(CDateTime cdt) throws ChartException {
        int iUnit = 0;
        int i = 0;
        while (i < iaCalendarUnits.length) {
            if (cdt.get(iaCalendarUnits[i]) > 0) {
                iUnit = i;
                break;
            }
            ++i;
        }
        return iaCalendarUnits[iUnit];
    }

    public static int getUnitId(int iUnit) throws ChartException {
        int id = 0;
        int i = 0;
        while (i < iaCalendarUnits.length) {
            if (iaCalendarUnits[i] == iUnit) {
                id = i;
                break;
            }
            ++i;
        }
        return id;
    }

    protected static double getPrecision(double precision, double pValue, FormatSpecifier fs, ULocale locale, boolean bIsPercent) {
        NumberFormatSpecifier ns;
        double value = Math.abs(pValue);
        if ((value = AutoScale.getValidDouble(value)) == 0.0) {
            if (precision < 0.0) {
                return precision;
            }
            if (precision >= 0.0) {
                return 1.0;
            }
        }
        if (precision == 0.0) {
            precision = bIsPercent ? 1.0 : Math.pow(10.0, Math.floor(Math.log(value) / Math.log(10.0)));
        }
        double check = value / precision;
        int loopCounter = 0;
        while (Math.floor(check) != check && loopCounter < 20) {
            ++loopCounter;
            check = value / (precision /= 10.0);
        }
        if (loopCounter == 20) {
            logger.log(2, "Autoscale precision not found for " + value);
        }
        if (fs != null && fs instanceof NumberFormatSpecifier && (ns = (NumberFormatSpecifier)fs).isSetFractionDigits()) {
            double multiplier;
            double d = multiplier = ns.isSetMultiplier() ? ns.getMultiplier() : 1.0;
            if (multiplier != 0.0) {
                double formatPrecision = Math.pow(10.0, -ns.getFractionDigits()) / multiplier;
                precision = precision == 0.0 ? formatPrecision : Math.max(precision, formatPrecision);
            }
        }
        return precision;
    }

    public final int computeTicks(IDisplayServer xs, Label la, int iLabelLocation, int iOrientation, double dStart, double dEnd, boolean bConsiderStartEndLabels, AllAxes aax) throws ChartException {
        return this.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, bConsiderStartEndLabels, bConsiderStartEndLabels, aax);
    }

    public final int computeTicks(IDisplayServer xs, Label la, int iLabelLocation, int iOrientation, double dStart, double dEnd, boolean bConsiderStartLabel, boolean bConsiderEndLabel, AllAxes aax) throws ChartException {
        int iDirection;
        boolean bMaxIsNotIntegralMultipleOfStep = false;
        int nTicks = 0;
        double dLength = 0.0;
        double dTickGap = 0.0;
        int n = this.iScaleDirection == 0 ? (iOrientation == 0 ? 1 : -1) : (iDirection = this.iScaleDirection);
        if (bConsiderStartLabel || bConsiderEndLabel) {
            this.computeAxisStartEndShifts(xs, la, iOrientation, iLabelLocation, aax);
            if (!this.bLabelWithinAxes && bConsiderStartLabel) {
                dStart += this.dStartShift * (double)iDirection;
            }
            if (bConsiderEndLabel) {
                dEnd += this.dEndShift * (double)(-iDirection);
            }
        }
        this.dStart = dStart;
        this.dEnd = dEnd;
        nTicks = this.getTickCount();
        dLength = Math.abs(dStart - dEnd);
        if (!this.bCategoryScale && (this.iType & 1) == 1 && (this.iType & 2) == 2) {
            double dMax = AutoScale.asDouble(this.oMaximum);
            double dMin = AutoScale.asDouble(this.oMinimum);
            double dStep = AutoScale.asDouble(this.oStep);
            boolean bl = bMaxIsNotIntegralMultipleOfStep = !ChartUtil.mathEqual(dMax / dStep, (int)(dMax / dStep));
            if (this.bStepFixed && this.oStepNumber != null) {
                dTickGap = dLength / (double)this.oStepNumber.intValue() * (double)iDirection;
            } else {
                double dStepSize = AutoScale.asDouble(this.oStep);
                dTickGap = Math.min(Math.abs(dStepSize / (dMax - dMin) * dLength), dLength) * (double)iDirection;
            }
        } else {
            dTickGap = this.isTickBetweenCategories() ? dLength / (double)(nTicks - 1) * (double)iDirection : dLength / (double)(nTicks - 2) * (double)iDirection;
        }
        if (nTicks > 1000 && this.bStepFixed && !this.bCategoryScale) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.scale.tick.max", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        AxisTickCoordinates atc = new AxisTickCoordinates(nTicks, dStart, dEnd, dTickGap, !this.bCategoryScale || this.isTickBetweenCategories());
        this.setTickCordinates(null);
        this.setEndPoints(dStart, dEnd);
        this.setTickCordinates(atc);
        if (this.bStepFixed && this.oStepNumber == null && nTicks > 2 && bMaxIsNotIntegralMultipleOfStep && !this.checkFit(xs, la, iLabelLocation)) {
            AxisTickCoordinates atc1 = new AxisTickCoordinates(--nTicks, dStart, dEnd, dTickGap, !this.bCategoryScale || this.isTickBetweenCategories());
            this.setTickCordinates(null);
            this.setTickCordinates(atc1);
        }
        this.checkTickLabelsVisibility(xs, la, iLabelLocation);
        return nTicks;
    }

    public final String formatCategoryValue(int iType, Object oValue, int iDateTimeUnit) {
        if (oValue == null) {
            return IConstants.NULL_STRING;
        }
        if ((iType & 0x10) == 16) {
            if (oValue instanceof Number) {
                return this.formatCategoryValue(1, oValue, iDateTimeUnit);
            }
            return oValue.toString();
        }
        if ((iType & 8) == 8) {
            Calendar ca = (Calendar)oValue;
            IDateFormatWrapper sdf = null;
            if (this.fs == null) {
                sdf = this.cacheDateFormat.get(iDateTimeUnit);
            }
            try {
                return ValueFormatter.format(ca, this.fs, this.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                return IConstants.NULL_STRING;
            }
        }
        if ((iType & 1) == 1) {
            DecimalFormat df = null;
            if (this.fs == null) {
                String pattern = ValueFormatter.getNumericPattern(((Number)oValue).doubleValue());
                df = (DecimalFormat)this.cacheNumFormat.get(pattern);
            }
            try {
                return ValueFormatter.format(oValue, this.fs, this.rtc.getULocale(), df);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                return IConstants.NULL_STRING;
            }
        }
        return IConstants.NULL_STRING;
    }

    final void computeAxisStartEndShifts(IDisplayServer xs, Label la, int iOrientation, int iLocation, AllAxes aax) throws ChartException {
        double dMaxES;
        double dMaxSS = aax != null && iOrientation == aax.getOrientation() ? aax.getMaxStartShift() : 0.0;
        double d = dMaxES = aax != null && iOrientation == aax.getOrientation() ? aax.getMaxEndShift() : 0.0;
        if (!la.isVisible() && !this.bLabelWithinAxes) {
            this.dStartShift = dMaxSS;
            this.dEndShift = dMaxES;
            return;
        }
        if (this.isCategoryScale()) {
            boolean bCenter;
            int iDateTimeUnit;
            double dUnitSize = this.getUnitSize();
            DataSetIterator dsi = this.getData();
            BoundingBox bb = null;
            try {
                iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
            }
            catch (ClassCastException classCastException) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.dataset.non.datetime", Messages.getResourceBundle(this.rtc.getULocale()));
            }
            double rotation = la.getCaption().getFont().getRotation();
            boolean bl = bCenter = rotation == 0.0 || rotation == 90.0 || rotation == -90.0;
            if (!this.isTickLabelVisible(0)) {
                this.dStartShift = dMaxSS;
            } else {
                la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.first(), iDateTimeUnit));
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dStartShift = bCenter ? Math.max(dMaxSS, dUnitSize > bb.getHeight() ? 0.0 : (bb.getHeight() - dUnitSize) / 2.0) : (this.iScaleDirection == 1 ? Math.max(dMaxSS, bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint() - dUnitSize / 2.0));
                } else if (iOrientation == 0) {
                    this.dStartShift = bCenter ? Math.max(dMaxSS, dUnitSize > bb.getWidth() ? 0.0 : (bb.getWidth() - dUnitSize) / 2.0) : (this.iScaleDirection == -1 ? Math.max(dMaxSS, bb.getWidth() - bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxSS, bb.getHotPoint() - dUnitSize / 2.0));
                }
            }
            if (!this.isTickLabelVisible(dsi.size() - 1)) {
                this.dEndShift = dMaxES;
            } else {
                la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.last(), iDateTimeUnit));
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, this.dEnd);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dEndShift = bCenter ? Math.max(dMaxES, dUnitSize > bb.getHeight() ? 0.0 : (bb.getHeight() - dUnitSize) / 2.0) : (this.iScaleDirection == 1 ? Math.max(dMaxES, bb.getHeight() - bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxES, bb.getHotPoint() - dUnitSize / 2.0));
                } else if (iOrientation == 0) {
                    this.dEndShift = bCenter ? Math.max(dMaxES, dUnitSize > bb.getWidth() ? 0.0 : (bb.getWidth() - dUnitSize) / 2.0) : (this.iScaleDirection == -1 ? Math.max(dMaxES, bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxES, bb.getWidth() - bb.getHotPoint() - dUnitSize / 2.0));
                }
            }
        } else if ((this.iType & 1) == 1) {
            if ((this.iType & 2) == 2) {
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern());
                }
                String sValue = null;
                try {
                    sValue = ValueFormatter.format(this.getMinimum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                BoundingBox bb = null;
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
                }
                try {
                    sValue = ValueFormatter.format(this.getMaximum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
                }
            } else if ((this.iType & 4) == 4) {
                double dMinimum = AutoScale.asDouble(this.getMinimum());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(ValueFormatter.getNumericPattern(dMinimum));
                }
                String sValue = null;
                try {
                    sValue = ValueFormatter.format(this.getMinimum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                BoundingBox bb = null;
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
                }
                double dMaximum = AutoScale.asDouble(this.getMaximum());
                if (this.fs == null) {
                    df = new DecimalFormat(ValueFormatter.getNumericPattern(dMaximum));
                }
                try {
                    sValue = ValueFormatter.format(this.getMaximum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
                }
            }
        } else if (this.getType() == 8) {
            CDateTime cdt = AutoScale.asDateTime(this.getMinimum());
            int iUnit = AutoScale.asInteger(this.oUnit);
            IDateFormatWrapper sdf = null;
            String sText = null;
            if (this.fs == null) {
                sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
            }
            try {
                sText = ValueFormatter.format((Object)cdt, this.fs, this.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                sText = IConstants.NULL_STRING;
            }
            la.getCaption().setValue(sText);
            BoundingBox bb = null;
            try {
                bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
            }
            if (iOrientation == 1) {
                this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
            } else if (iOrientation == 0) {
                this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
            }
            cdt = AutoScale.asDateTime(this.getMaximum());
            try {
                sText = ValueFormatter.format((Object)cdt, this.fs, this.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                sText = IConstants.NULL_STRING;
            }
            la.getCaption().setValue(sText);
            try {
                bb = AutoScale.computeBox(xs, iLocation, la, 0.0, this.dEnd);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
            }
            if (iOrientation == 1) {
                this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
            } else if (iOrientation == 0) {
                this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
            }
        }
    }

    public final double computeAxisLabelThickness(IDisplayServer xs, Label la, int iOrientation) throws ChartException {
        if (!la.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unset.label.visibility", new Object[]{la.getCaption().getValue()}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (!la.isVisible()) {
            return 0.0;
        }
        AxisTickCoordinates da = this.getTickCordinates();
        if (iOrientation == 1) {
            double dMaxW = 0.0;
            double dMaxW2 = 0.0;
            if (this.isCategoryScale()) {
                Collection<Integer> visIds = this.getVisibleLabelIds();
                for (int id : visIds) {
                    la.getCaption().setValue(this.getComputedLabelText(id));
                    double dW = AutoScale.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(id)) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                        continue;
                    }
                    if (!(dW > dMaxW)) continue;
                    dMaxW = dW;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = AutoScale.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue += dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = AutoScale.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = AutoScale.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    cdtAxisValue = cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxW + dMaxW2;
        }
        if (iOrientation == 0) {
            double dMaxH = 0.0;
            double dMaxH2 = 0.0;
            if (this.isCategoryScale()) {
                Collection<Integer> visIds = this.getVisibleLabelIds();
                for (int id : visIds) {
                    la.getCaption().setValue(this.getComputedLabelText(id));
                    double dH = AutoScale.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(id)) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                        continue;
                    }
                    if (!(dH > dMaxH)) continue;
                    dMaxH = dH;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = AutoScale.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue += dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = AutoScale.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = AutoScale.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.isTickLabelStaggered(i)) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxH + dMaxH2;
        }
        return 0.0;
    }

    public final double computeStaggeredAxisLabelOffset(IDisplayServer xs, Label la, int iOrientation) throws ChartException {
        if (!la.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unset.label.visibility", new Object[]{la.getCaption().getValue()}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (!la.isVisible() || !this.isAxisLabelStaggered()) {
            return 0.0;
        }
        AxisTickCoordinates da = this.getTickCordinates();
        if (iOrientation == 1) {
            double dMaxW = 0.0;
            if (this.isCategoryScale()) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    double dW;
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    if (!this.isTickLabelStaggered(i) && (dW = AutoScale.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                }
                int i = 0;
                while (i < da.size()) {
                    double dW;
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dW = AutoScale.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue += dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    double dW;
                    String sText;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dW = AutoScale.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    double dW;
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dW = AutoScale.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    cdtAxisValue = cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxW;
        }
        if (iOrientation == 0) {
            double dMaxH = 0.0;
            if (this.isCategoryScale()) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    double dH;
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    if (!this.isTickLabelStaggered(i) && (dH = AutoScale.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                }
                int i = 0;
                while (i < da.size()) {
                    double dH;
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dH = AutoScale.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue += dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                int i = 0;
                while (i < da.size()) {
                    double dH;
                    String sText;
                    if (this.fs == null) {
                        df = this.computeDecimalFormat(dAxisValue, dAxisStep);
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dH = AutoScale.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue *= dAxisStep;
                    ++i;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                int i = 0;
                while (i < da.size()) {
                    double dH;
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.isTickLabelStaggered(i) && (dH = AutoScale.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    cdtAxisValue.forward(iUnit, iStep);
                    ++i;
                }
            }
            return dMaxH;
        }
        return 0.0;
    }

    public final boolean isStepFixed() {
        return this.bStepFixed;
    }

    public final void setStepFixed(boolean v) {
        this.bStepFixed = v;
    }

    public final boolean isMinimumFixed() {
        return this.bMinimumFixed;
    }

    public final void setMinimumFixed(boolean v) {
        this.bMinimumFixed = v;
    }

    public final boolean isMaximumFixed() {
        return this.bMaximumFixed;
    }

    public final void setMaximumFixed(boolean v) {
        this.bMaximumFixed = v;
    }

    public final boolean isCategoryScale() {
        return (this.iType & 0x10) == 16 || this.bCategoryScale;
    }

    public final double[] getMinorCoordinates(int iMinorUnitsPerMajor) {
        if (this.atcTickCoordinates == null || iMinorUnitsPerMajor <= 0) {
            return null;
        }
        double[] da = new double[iMinorUnitsPerMajor];
        double dUnit = this.getUnitSize();
        if ((this.iType & 4) != 4) {
            double dEach = dUnit / (double)iMinorUnitsPerMajor;
            int i = 1;
            while (i < iMinorUnitsPerMajor) {
                da[i - 1] = dEach * (double)i;
                ++i;
            }
        } else {
            double dCount = iMinorUnitsPerMajor;
            double dMax = Math.log(dCount);
            int i = 0;
            while (i < iMinorUnitsPerMajor) {
                da[i] = Math.log(i + 1) * dUnit / dMax;
                ++i;
            }
        }
        da[iMinorUnitsPerMajor - 1] = dUnit;
        return da;
    }

    public final RunTimeContext getRunTimeContext() {
        return this.rtc;
    }

    public final void setRunTimeContext(RunTimeContext context) {
        this.rtc = context;
    }

    public static void setNumberMinMaxToScale(AutoScale sc, Object oMinimum, Object oMaximum, RunTimeContext rtc, OneAxis ax) throws ChartException {
        if (oMinimum != null) {
            if (!(oMinimum instanceof NumberDataElement)) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.minimum.scale.value", new Object[]{sc.oMinimum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
            }
            sc.oMinimum = new Double(((NumberDataElement)oMinimum).getValue());
            sc.bMinimumFixed = true;
        }
        if (oMaximum != null) {
            if (!(oMaximum instanceof NumberDataElement)) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.maximum.scale.value", new Object[]{sc.oMaximum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
            }
            sc.oMaximum = new Double(((NumberDataElement)oMaximum).getValue());
            sc.bMaximumFixed = true;
        }
        if (sc.bMaximumFixed && sc.bMinimumFixed && (Double)sc.oMinimum > (Double)sc.oMaximum) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.min.largerthan.max", new Object[]{sc.oMinimum, sc.oMaximum}, Messages.getResourceBundle(rtc.getULocale()));
        }
    }

    public static void setStepToScale(AutoScale sc, Object oStep, Integer oStepNumber, RunTimeContext rtc) throws ChartException {
        if (oStep != null) {
            sc.setStep(oStep);
            sc.bStepFixed = true;
            if ((Double)sc.oStep <= 0.0) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.step.size", new Object[]{oStep}, Messages.getResourceBundle(rtc.getULocale()));
            }
        }
        if (oStepNumber != null) {
            sc.oStepNumber = oStepNumber;
            sc.bStepFixed = true;
            if (sc.oStepNumber < 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.step.number", new Object[]{oStepNumber}, Messages.getResourceBundle(rtc.getULocale()));
            }
        }
    }

    public final DecimalFormat computeDecimalFormat(double dAxisValue, double dAxisStep) {
        String valuePattern = ValueFormatter.getNumericPattern(dAxisValue);
        String stepPattern = ValueFormatter.getNumericPattern(dAxisStep);
        boolean bValuePrecise = ChartUtil.checkDoublePrecise(dAxisValue);
        boolean bStepPrecise = ChartUtil.checkDoublePrecise(dAxisStep);
        if (bValuePrecise ? bStepPrecise && valuePattern.length() < stepPattern.length() : bStepPrecise) {
            return (DecimalFormat)this.cacheNumFormat.get(stepPattern);
        }
        return (DecimalFormat)this.cacheNumFormat.get(valuePattern);
    }

    private static void updateSharedScaleContext(RunTimeContext rtc, int iType, ScaleContext sct) {
        if (rtc.getScale() != null && !rtc.getScale().isShared()) {
            if ((iType & 8) == 8) {
                rtc.getScale().updateShared(sct);
            } else {
                rtc.setScale(sct);
            }
        }
    }

    private class CateLabVisTester
    implements EllipsisHelper.ITester {
        private RotatedRectangle rrPrev;
        private RotatedRectangle rrCurr;
        private int iLabelLocation;
        private double x;
        private double y;
        private int iNewPointToCheck;
        private int iPrevPointToCheck;
        private Label la;
        private IDisplayServer xs;
        private Double fontHeight = null;

        CateLabVisTester(int iLabelLocation, int iNewPointToCheck, int iPrevPointToCheck, Label la, IDisplayServer xs) {
            this.iLabelLocation = iLabelLocation;
            this.iNewPointToCheck = iNewPointToCheck;
            this.iPrevPointToCheck = iPrevPointToCheck;
            this.la = la;
            this.xs = xs;
            this.fontHeight = Methods.computeFontHeight(xs, la);
        }

        private void setFPara(RotatedRectangle rrPrev, double x, double y) {
            this.rrPrev = rrPrev;
            this.x = x;
            this.y = y;
        }

        private RotatedRectangle getCurrentRR() {
            return this.rrCurr;
        }

        public boolean testLabelVisible(String sText, Object oPara) throws ChartException {
            this.la.getCaption().setValue(sText);
            Point previousPoint = this.rrPrev.getPoint(this.iPrevPointToCheck);
            if (AutoScale.this.quickCheckVisibility(this.iLabelLocation, previousPoint, this.x, this.y)) {
                boolean visible;
                this.rrCurr = AutoScale.computePolygon(this.xs, this.iLabelLocation, this.la, this.x, this.y, this.fontHeight);
                Point p = this.rrCurr.getPoint(this.iNewPointToCheck);
                boolean bl = visible = !this.rrPrev.contains(p) && !ChartUtil.intersects(this.rrCurr, this.rrPrev);
                if (visible) {
                    return true;
                }
            }
            return false;
        }

        public double getHeight() {
            return 0.0;
        }

        public double getWidth() {
            return 0.0;
        }
    }

    private static abstract class LabelVisibleHelper {
        protected Set<Integer> idsVis = new HashSet<Integer>();
        protected final int iTickCount;
        protected final int iShowIterval;
        protected final CommonRule commonRule;

        private LabelVisibleHelper(int iTickCount, int iShowIterval) {
            this.iTickCount = iTickCount;
            this.iShowIterval = iShowIterval;
            this.commonRule = iShowIterval < 2 ? CommonRule.SHOW_INTERVAL_1 : CommonRule.SHOW_INTEVAL_2UP;
        }

        public abstract boolean isTickLabelVisible(int var1);

        public boolean shouldTickLabelVisible(int index) {
            return this.commonRule.shouldVisible(index, this.iTickCount, this.iShowIterval);
        }

        public void addVisible(int index) {
            this.idsVis.add(index);
        }

        public static LabelVisibleHelper createInstance(boolean bLabelVisible, boolean bCategory, int iTickCount, int iShowIterval) {
            if (!bLabelVisible) {
                return new LabelVisibleHelper(iTickCount, iShowIterval){

                    public boolean isTickLabelVisible(int index) {
                        return false;
                    }

                    public boolean shouldTickLabelVisible(int index) {
                        return false;
                    }
                };
            }
            if (bCategory) {
                return new LabelVisibleHelper(iTickCount, iShowIterval){

                    public boolean isTickLabelVisible(int index) {
                        return this.idsVis.contains(index);
                    }
                };
            }
            return new LabelVisibleHelper(iTickCount, iShowIterval){

                public boolean isTickLabelVisible(int index) {
                    return this.commonRule.shouldVisible(index, this.iTickCount, this.iShowIterval);
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum CommonRule {
            SHOW_INTERVAL_1{

                public boolean shouldVisible(int index, int iTickCount, int iShowIterval) {
                    return !CommonRule.isIndexOutOfBound(index, iTickCount);
                }
            }
            ,
            SHOW_INTEVAL_2UP{

                public boolean shouldVisible(int index, int iTickCount, int iShowIterval) {
                    return !CommonRule.isIndexOutOfBound(index, iTickCount) && index % iShowIterval == 0;
                }
            };


            public abstract boolean shouldVisible(int var1, int var2, int var3);

            private static boolean isIndexOutOfBound(int index, int iTickCount) {
                return index < 0 || index > iTickCount - 1;
            }
        }
    }

    private static abstract class StaggeredHelper {
        private StaggeredHelper() {
        }

        public static StaggeredHelper createInstance(boolean staggerEnabled, final int iTickCount, final int iLabelShowingInterval) {
            if (!staggerEnabled) {
                return new StaggeredHelper(){

                    public boolean isTickLabelStaggered(int index) {
                        return false;
                    }
                };
            }
            if (iLabelShowingInterval < 2) {
                return new StaggeredHelper(){

                    public boolean isTickLabelStaggered(int index) {
                        if (StaggeredHelper.isIndexOutOfBound(index, iTickCount)) {
                            return false;
                        }
                        return index % 2 == 1;
                    }
                };
            }
            return new StaggeredHelper(){

                public boolean isTickLabelStaggered(int index) {
                    if (StaggeredHelper.isIndexOutOfBound(index, iTickCount)) {
                        return false;
                    }
                    return index % iLabelShowingInterval == 0 && index / iLabelShowingInterval % 2 == 1;
                }
            };
        }

        private static boolean isIndexOutOfBound(int index, int iTickCount) {
            return index < 0 || index > iTickCount - 1;
        }

        public abstract boolean isTickLabelStaggered(int var1);
    }
}

