/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;

public class dateUtil {
    public static final int NUMSECSINHR = 3600;
    public static final int NUMSECSINDY = 86400;
    public static final int NUMSECSINWK = 604800;
    public static final int NUMSECSINMN = 18144000;
    public static final int NUMSECSINYR = 217728000;
    private static final char ERA_ID = 'E';
    private static final char DAY_ID = 'D';
    private static final char MONTH_ID = 'M';
    private static final char YEAR_ID = 'Y';
    private static final char PERCENT = '%';
    private static final char CQUOTE = '\'';
    private static final char SPACE = ' ';
    private static final char FOUR_DIGIT_YEAR = '4';
    private static final char TWO_DIGIT_YEAR = '2';
    private static final String SLASH = "/";
    private static final String HYPHEN = "-";
    private static final String PERIOD = ".";
    private static final String NOSEP = "0";
    private static final String UNDERSCORE = "_";
    private static final String SQUOTE = "'";
    private static final String CDIRTAG = ";;;;";
    private static final String WDIRTAG = ";;;;;";
    private static final String NONALPHANUMTOKS = "/-. ~`!@#$%^&*()_+=\t\n\r\b{}[]|\\:;'\"<>,?";
    static int[] numDaysArr = new int[12];

    public static int calcNumDays(String date) {
        if (!dateUtil.isValidDate(date)) {
            return -1;
        }
        dateUtil.numDaysArr[0] = 0;
        dateUtil.numDaysArr[1] = 31;
        dateUtil.numDaysArr[2] = 59;
        dateUtil.numDaysArr[3] = 90;
        dateUtil.numDaysArr[4] = 120;
        dateUtil.numDaysArr[5] = 151;
        dateUtil.numDaysArr[6] = 181;
        dateUtil.numDaysArr[7] = 212;
        dateUtil.numDaysArr[8] = 243;
        dateUtil.numDaysArr[9] = 273;
        dateUtil.numDaysArr[10] = 304;
        dateUtil.numDaysArr[11] = 334;
        StringTokenizer dateT = new StringTokenizer(date, HYPHEN);
        int nd = 0;
        if (dateUtil.isValidDate(date)) {
            int y = stringUtil.stringToInt(dateT.nextToken());
            int m = stringUtil.stringToInt(dateT.nextToken());
            int d = stringUtil.stringToInt(dateT.nextToken());
            nd = numDaysArr[m - 1] + d;
            if (m > 2 && dateUtil.isLeapYear(y)) {
                ++nd;
            }
        }
        return nd;
    }

    public static boolean isValidTimeStamp(String timeStamp) {
        StringTokenizer tsT = new StringTokenizer(timeStamp, " ");
        if (tsT.countTokens() != 2) {
            return false;
        }
        if (!dateUtil.isValidDate(tsT.nextToken())) {
            return false;
        }
        String time = tsT.nextToken();
        if (time.indexOf(46) == -1) {
            return dateUtil.isValidTime(time);
        }
        StringTokenizer tT = new StringTokenizer(time, PERIOD);
        if (tT.countTokens() != 2) {
            return false;
        }
        if (!dateUtil.isValidTime(tT.nextToken())) {
            return false;
        }
        String f = tT.nextToken();
        return stringUtil.isANum(f) && f.length() <= 8;
    }

    public static String IfxTimeStamp(String s) {
        if (s.length() > 25) {
            return s.substring(0, 25);
        }
        return s;
    }

    public static boolean isValidTime(String time) {
        StringTokenizer tT = new StringTokenizer(time, ":");
        if (tT.countTokens() != 3) {
            return false;
        }
        int h = stringUtil.stringToInt(tT.nextToken());
        if (h < 0 || h > 23) {
            return false;
        }
        int m = stringUtil.stringToInt(tT.nextToken());
        if (m < 0 || m > 59) {
            return false;
        }
        int s = stringUtil.stringToInt(tT.nextToken());
        return s >= 0 && s <= 59;
    }

    public static boolean isValidDate(String date) {
        StringTokenizer dT = new StringTokenizer(date, HYPHEN);
        if (dT.countTokens() != 3) {
            return false;
        }
        String tmp = dT.nextToken();
        if (tmp.length() != 4) {
            return false;
        }
        int y = stringUtil.stringToInt(tmp);
        int m = stringUtil.stringToInt(dT.nextToken());
        if (m < 1 || m > 12) {
            return false;
        }
        int d = stringUtil.stringToInt(dT.nextToken());
        switch (m) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (d >= 1 && d <= 31) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (d >= 1 && d <= 30) break;
                return false;
            }
            case 2: {
                int max = 28;
                if (y % 4 == 0 && y % 100 != 0 || y % 400 == 0) {
                    max = 29;
                }
                if (d >= 1 && d <= max) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static long gregToJulian(String date) {
        int y = stringUtil.stringToInt(date.substring(0, 4));
        int m = stringUtil.stringToInt(date.substring(5, 7));
        int d = stringUtil.stringToInt(date.substring(8, 10));
        long jdate = 1461 * (y + 4800 + (m - 14) / 12) / 4 + 367 * (m - 2 - 12 * ((m - 14) / 12)) / 12 - 3 * ((y + 4900 + (m - 14) / 12) / 100) / 4 + d - 32075;
        return jdate;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private static String getdbDateStr(java.sql.Date date, String dateLocale, String dbDateFormat) throws SQLException {
        String pattern = "";
        String retStr = "";
        String dbDatetok = null;
        boolean sepfound = false;
        int datefmtlen = 0;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (dbDateFormat.length() < 4 || dbDateFormat.length() > 6) {
            throw IfxErrMsg.getSQLException(-79797, "\"" + dbDateFormat + "\"", clLocale);
        }
        String temptok = dbDateFormat.substring(dbDateFormat.length() - 1);
        if (temptok.equals(SLASH) || temptok.equals(HYPHEN) || temptok.equals(PERIOD)) {
            dbDatetok = temptok;
            sepfound = true;
        } else if (temptok.equals(NOSEP)) {
            dbDatetok = "";
            sepfound = true;
        } else {
            if (!(temptok.equals("E") || temptok.equals("2") || temptok.equals("4") || temptok.equals("M") || temptok.equals("D"))) {
                sepfound = true;
            }
            dbDatetok = SLASH;
        }
        datefmtlen = sepfound ? dbDateFormat.length() - 1 : dbDateFormat.length();
        int i = 0;
        while (i < datefmtlen) {
            switch (dbDateFormat.charAt(i)) {
                case 'E': {
                    if (i == 0) {
                        pattern = String.valueOf(pattern) + "GGG ";
                        break;
                    }
                    pattern = String.valueOf(pattern) + " GGG ";
                    break;
                }
                case 'D': {
                    pattern = String.valueOf(pattern) + "dd" + dbDatetok;
                    break;
                }
                case 'M': {
                    pattern = String.valueOf(pattern) + "MM" + dbDatetok;
                    break;
                }
                case 'Y': {
                    if (i + 1 == datefmtlen) {
                        throw IfxErrMsg.getSQLException(-79798, "\"" + dbDateFormat + "\"", clLocale);
                    }
                    if (dbDateFormat.charAt(i + 1) == '2' || dbDateFormat.charAt(i + 1) == '4') break;
                    throw IfxErrMsg.getSQLException(-79799, "\"" + dbDateFormat + "\"", clLocale);
                }
                case '2': 
                case '4': {
                    if (i == 0 || dbDateFormat.charAt(i - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + dbDateFormat + "\"", clLocale);
                    }
                    if (dbDateFormat.charAt(i) == '2') {
                        pattern = String.valueOf(pattern) + "yy" + dbDatetok;
                        break;
                    }
                    pattern = String.valueOf(pattern) + "yyyy" + dbDatetok;
                    break;
                }
                default: {
                    throw IfxErrMsg.getSQLException(-79801, "\"" + dbDateFormat + "\"", clLocale);
                }
            }
            ++i;
        }
        if (dbDatetok.equals("")) {
            retStr = dateUtil.formatDate(date, clLocale, pattern);
            return retStr;
        }
        retStr = dateUtil.formatDate(date, clLocale, pattern.substring(0, pattern.length() - 1));
        return retStr;
    }

    private static String getglDateStr(java.sql.Date date, String dateLocale, String glDateFormat, boolean nativeSQL) {
        String pattern = "";
        String retStr = "";
        boolean quote_letters = false;
        String[] dateField = new String[5];
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        int i = 0;
        while (i < glDateFormat.length()) {
            switch (glDateFormat.charAt(i)) {
                case '%': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + "%";
                        break;
                    }
                    if (!quote_letters) break;
                    pattern = String.valueOf(pattern) + SQUOTE;
                    quote_letters = false;
                    break;
                }
                case '\'': {
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + SQUOTE + SQUOTE + SQUOTE;
                        quote_letters = false;
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + SQUOTE;
                    break;
                }
                case 'a': {
                    Locale swiss_fr_loc;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        swiss_fr_loc = new Locale("fr", "CH", "");
                        Locale turkey_loc = new Locale("tr", "TR", "");
                        if (nativeSQL && (clLocale.toString().equals(turkey_loc.toString()) || clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) || clLocale.toString().equals(swiss_fr_loc.toString()))) {
                            if (quote_letters) {
                                pattern = String.valueOf(pattern) + dateUtil.getInfmxglPattern(date, 'a', clLocale);
                                break;
                            }
                            pattern = String.valueOf(pattern) + SQUOTE + dateUtil.getInfmxglPattern(date, 'a', clLocale);
                            quote_letters = true;
                            break;
                        }
                        pattern = String.valueOf(pattern) + "E";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "a";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "a";
                    quote_letters = true;
                    break;
                }
                case 'A': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + "EEEEE";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "A";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "A";
                    quote_letters = true;
                    break;
                }
                case 'b': {
                    Locale swiss_fr_loc;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        swiss_fr_loc = new Locale("fr", "CH", "");
                        if (nativeSQL && (clLocale.toString().equals(Locale.JAPAN.toString()) || clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) || clLocale.toString().equals(swiss_fr_loc.toString()))) {
                            if (quote_letters) {
                                pattern = String.valueOf(pattern) + dateUtil.getInfmxglPattern(date, 'b', clLocale);
                                break;
                            }
                            pattern = String.valueOf(pattern) + SQUOTE + dateUtil.getInfmxglPattern(date, 'b', clLocale);
                            quote_letters = true;
                            break;
                        }
                        pattern = String.valueOf(pattern) + "MMM";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "b";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "b";
                    quote_letters = true;
                    break;
                }
                case 'B': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (nativeSQL && clLocale.toString().equals(Locale.JAPAN.toString())) {
                            if (quote_letters) {
                                pattern = String.valueOf(pattern) + dateUtil.getInfmxglPattern(date, 'B', clLocale);
                                break;
                            }
                            pattern = String.valueOf(pattern) + SQUOTE + dateUtil.getInfmxglPattern(date, 'B', clLocale);
                            quote_letters = true;
                            break;
                        }
                        pattern = String.valueOf(pattern) + "MMMMM";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "B";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "B";
                    quote_letters = true;
                    break;
                }
                case 'C': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + CDIRTAG + "yyyy";
                        break;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        pattern = String.valueOf(pattern) + CDIRTAG + "yyyy" + " GGGGG ";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "C";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "C";
                    quote_letters = true;
                    break;
                }
                case 'd': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + "dd";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "d";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "d";
                    quote_letters = true;
                    break;
                }
                case 'D': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + "MM/dd/yy";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "D";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "D";
                    quote_letters = true;
                    break;
                }
                case 'e': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + "d";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "e";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "e";
                    quote_letters = true;
                    break;
                }
                case 'h': {
                    Locale swiss_fr_loc;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        swiss_fr_loc = new Locale("fr", "CH", "");
                        if (nativeSQL && (clLocale.toString().equals(Locale.JAPAN.toString()) || clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) || clLocale.toString().equals(swiss_fr_loc.toString()))) {
                            if (quote_letters) {
                                pattern = String.valueOf(pattern) + dateUtil.getInfmxglPattern(date, 'h', clLocale);
                                break;
                            }
                            pattern = String.valueOf(pattern) + SQUOTE + dateUtil.getInfmxglPattern(date, 'h', clLocale);
                            quote_letters = true;
                            break;
                        }
                        pattern = String.valueOf(pattern) + "MMM";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "h";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "h";
                    quote_letters = true;
                    break;
                }
                case 'i': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') break;
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "i";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "i";
                    quote_letters = true;
                    break;
                }
                case 'E': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') break;
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "E";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "E";
                    quote_letters = true;
                    break;
                }
                case 'y': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%' || i >= 2 && glDateFormat.charAt(i - 1) == 'i' && glDateFormat.charAt(i - 2) == '%') {
                        pattern = String.valueOf(pattern) + "yy";
                        break;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        pattern = String.valueOf(pattern) + "yy" + " GGGGG ";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "y";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "y";
                    quote_letters = true;
                    break;
                }
                case 'Y': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%' || i >= 2 && glDateFormat.charAt(i - 1) == 'i' && glDateFormat.charAt(i - 2) == '%') {
                        pattern = String.valueOf(pattern) + "yyyy";
                        break;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        pattern = String.valueOf(pattern) + "yyyy" + " GGGGG ";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "Y";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "Y";
                    quote_letters = true;
                    break;
                }
                case 'm': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + "MM";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "m";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "m";
                    quote_letters = true;
                    break;
                }
                case 'n': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + "\f";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "n";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "n";
                    quote_letters = true;
                    break;
                }
                case 't': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + "\t";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "t";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "t";
                    quote_letters = true;
                    break;
                }
                case 'w': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + WDIRTAG + "E";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "w";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "w";
                    quote_letters = true;
                    break;
                }
                case 'x': {
                    dateField = dateUtil.getLocaleDateOrder(clLocale, true);
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        pattern = String.valueOf(pattern) + dateUtil.getglDateXPattern(dateField);
                        break;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        pattern = String.valueOf(pattern) + dateUtil.getglDateXPattern(dateField) + " GGGGG ";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "x";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "x";
                    quote_letters = true;
                    break;
                }
                case 'g': {
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        pattern = String.valueOf(pattern) + CDIRTAG + "yyyy" + " G ";
                        break;
                    }
                    if (quote_letters) {
                        pattern = String.valueOf(pattern) + "g";
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + "g";
                    quote_letters = true;
                    break;
                }
                default: {
                    if (Character.isLetter(glDateFormat.charAt(i)) && !quote_letters) {
                        pattern = String.valueOf(pattern) + SQUOTE + glDateFormat.substring(i, i + 1);
                        quote_letters = true;
                        break;
                    }
                    if (Character.isLetter(glDateFormat.charAt(i)) && quote_letters || !Character.isLetter(glDateFormat.charAt(i)) && !quote_letters) {
                        pattern = String.valueOf(pattern) + glDateFormat.substring(i, i + 1);
                        break;
                    }
                    pattern = String.valueOf(pattern) + SQUOTE + glDateFormat.substring(i, i + 1);
                    quote_letters = false;
                    break;
                }
            }
            ++i;
        }
        if (quote_letters) {
            pattern = String.valueOf(pattern) + SQUOTE;
        }
        retStr = dateUtil.formatDate(date, clLocale, pattern);
        return retStr;
    }

    private static String getLocaleDateStr(java.sql.Date date, String dateLocale) {
        DateFormat formatter = null;
        String dateStr = null;
        int dateStyle = 3;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        formatter = DateFormat.getDateInstance(dateStyle, clLocale);
        dateStr = formatter.format(date);
        return dateStr;
    }

    private static String formatDate(java.sql.Date date, Locale clLocale, String pattern) {
        SimpleDateFormat formatter;
        int index = 0;
        int cindex = 0;
        String dateStr = null;
        if (pattern.indexOf(WDIRTAG) == -1) {
            formatter = new SimpleDateFormat(pattern, clLocale);
            dateStr = formatter.format(date);
        } else {
            DateFormatSymbols symbols = new DateFormatSymbols(clLocale);
            String[] defaultDays = symbols.getShortWeekdays();
            formatter = new SimpleDateFormat(pattern, symbols);
            dateStr = formatter.format(date);
            int windex = 0;
            int weekdaynum = 0;
            while (windex < dateStr.length() && (index = dateStr.indexOf(WDIRTAG, windex)) != -1) {
                int i = 0;
                while (i < defaultDays.length - 1) {
                    if (dateStr.indexOf(WDIRTAG + defaultDays[i + 1], windex) != -1) {
                        weekdaynum = i;
                        break;
                    }
                    ++i;
                }
                dateStr = String.valueOf(dateStr.substring(0, index)) + weekdaynum + dateStr.substring(index + WDIRTAG.length() + defaultDays[weekdaynum + 1].length());
                windex = index + 1;
            }
        }
        while (cindex < dateStr.length() && (index = dateStr.indexOf(CDIRTAG, cindex)) != -1) {
            dateStr = String.valueOf(dateStr.substring(0, index)) + dateStr.substring(index + CDIRTAG.length(), index + CDIRTAG.length() + 2) + dateStr.substring(index + CDIRTAG.length() + 4);
            cindex = index + 2;
        }
        return dateStr;
    }

    private static String convertdbDate(String date, String dateLocale, String dbDateFormat) throws SQLException {
        String localDateStr = null;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (!dateUtil.isValidDate(date)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + date + "\"", clLocale);
        }
        java.sql.Date dateObj = java.sql.Date.valueOf(date);
        localDateStr = dateUtil.getdbDateStr(dateObj, dateLocale, dbDateFormat);
        return localDateStr;
    }

    private static String convertglDate(String date, String dateLocale, String glDateFormat) throws SQLException {
        String localDateStr = null;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (!dateUtil.isValidDate(date)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + date + "\"", clLocale);
        }
        java.sql.Date dateObj = java.sql.Date.valueOf(date);
        boolean nativeSQL = true;
        localDateStr = dateUtil.getglDateStr(dateObj, dateLocale, glDateFormat, nativeSQL);
        return localDateStr;
    }

    private static String convertcllDate(String date, String dateLocale) throws SQLException {
        String localDateStr = null;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        if (!dateUtil.isValidDate(date)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + date + "\"", clLocale);
        }
        java.sql.Date dateObj = java.sql.Date.valueOf(date);
        localDateStr = dateUtil.getLocaleDateStr(dateObj, dateLocale);
        return localDateStr;
    }

    private static java.sql.Date getdbDateObj(String dateStr, IfxConnection conn) throws SQLException {
        String dbDateFormat = conn.getdbDate();
        String dbDatetok = null;
        String datepart = null;
        boolean sepfound = false;
        int dateidx = 0;
        int datefmtlen = 0;
        int tmpidx = 0;
        int y = -10000;
        int m = -85000;
        int d = -2500000;
        StringTokenizer dT = null;
        java.sql.Date dateObj = null;
        boolean needCentury = false;
        if (dbDateFormat.length() < 4 || dbDateFormat.length() > 6) {
            throw IfxErrMsg.getSQLException(-79797, "\"" + dbDateFormat + "\"", conn);
        }
        String temptok = dbDateFormat.substring(dbDateFormat.length() - 1);
        if (temptok.equals(SLASH) || temptok.equals(HYPHEN) || temptok.equals(PERIOD)) {
            dbDatetok = temptok;
            sepfound = true;
        } else if (temptok.equals(NOSEP)) {
            dbDatetok = "";
            sepfound = true;
        } else {
            if (!(temptok.equals("E") || temptok.equals("2") || temptok.equals("4") || temptok.equals("M") || temptok.equals("D"))) {
                sepfound = true;
            }
            dbDatetok = SLASH;
        }
        datefmtlen = sepfound ? dbDateFormat.length() - 1 : dbDateFormat.length();
        if (!dbDatetok.equals("") && (dT = new StringTokenizer(dateStr, String.valueOf(dbDatetok) + " ")).countTokens() < 3) {
            throw IfxErrMsg.getSQLException(-79802, "\"" + dateStr + "\"", conn);
        }
        int i = 0;
        while (i < datefmtlen) {
            if (dbDatetok.equals("") && dateidx >= dateStr.length()) {
                throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
            }
            if (!dbDatetok.equals("") && !dT.hasMoreTokens()) {
                throw IfxErrMsg.getSQLException(-79804, "\"" + dateStr + "\"", conn);
            }
            if (!dbDatetok.equals("") && dbDateFormat.charAt(i) != 'Y') {
                datepart = dT.nextToken();
            }
            switch (dbDateFormat.charAt(i)) {
                case 'E': {
                    if (!dbDatetok.equals("")) break;
                    if (dateidx <= dateStr.length()) {
                        tmpidx = dateStr.indexOf(32, dateidx);
                        if (tmpidx != -1) {
                            dateidx = tmpidx + 1;
                            break;
                        }
                        throw IfxErrMsg.getSQLException(-79805, "\"" + dateStr + "\"", conn);
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                }
                case 'D': {
                    if (!dbDatetok.equals("")) {
                        d = stringUtil.stringToInt(datepart);
                        if (d != 0) break;
                        throw IfxErrMsg.getSQLException(-79806, "\"" + dateStr + "\"", conn);
                    }
                    if (dateidx + 2 <= dateStr.length()) {
                        d = stringUtil.stringToInt(dateStr.substring(dateidx, dateidx + 2));
                        if (d == 0) {
                            throw IfxErrMsg.getSQLException(-79806, "\"" + dateStr + "\"", conn);
                        }
                        dateidx += 2;
                        break;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                }
                case 'M': {
                    if (!dbDatetok.equals("")) {
                        m = stringUtil.stringToInt(datepart) - 1;
                        if (m != -1) break;
                        throw IfxErrMsg.getSQLException(-79807, "\"" + dateStr + "\"", conn);
                    }
                    if (dateidx + 2 <= dateStr.length()) {
                        m = stringUtil.stringToInt(dateStr.substring(dateidx, dateidx + 2)) - 1;
                        if (m == -1) {
                            throw IfxErrMsg.getSQLException(-79807, "\"" + dateStr + "\"", conn);
                        }
                        dateidx += 2;
                        break;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                }
                case 'Y': {
                    if (i + 1 == datefmtlen) {
                        throw IfxErrMsg.getSQLException(-79798, "\"" + dbDateFormat + "\"", conn);
                    }
                    if (dbDateFormat.charAt(i + 1) == '2' || dbDateFormat.charAt(i + 1) == '4') break;
                    throw IfxErrMsg.getSQLException(-79799, "\"" + dbDateFormat + "\"", conn);
                }
                case '2': {
                    if (i == 0 || dbDateFormat.charAt(i - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + dbDateFormat + "\"", conn);
                    }
                    if (!dbDatetok.equals("")) {
                        y = stringUtil.stringToInt(datepart);
                        if (datepart.length() >= 3) break;
                        needCentury = true;
                        break;
                    }
                    if (dateidx + 2 <= dateStr.length()) {
                        y = stringUtil.stringToInt(dateStr.substring(dateidx, dateidx + 2));
                        needCentury = true;
                        dateidx += 2;
                        break;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dbDateFormat + "\"", conn);
                }
                case '4': {
                    if (i == 0 || dbDateFormat.charAt(i - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + dbDateFormat + "\"", conn);
                    }
                    if (!dbDatetok.equals("")) {
                        y = stringUtil.stringToInt(datepart);
                        if (datepart.length() >= 3) break;
                        needCentury = true;
                        break;
                    }
                    if (dateidx + 4 <= dateStr.length()) {
                        y = stringUtil.stringToInt(dateStr.substring(dateidx, dateidx + 4));
                        dateidx += 4;
                        break;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                }
                default: {
                    throw IfxErrMsg.getSQLException(-79801, "\"" + dbDateFormat + "\"", conn);
                }
            }
            ++i;
        }
        try {
            if (needCentury) {
                y += dateUtil.getCentury(conn, y, m + 1, d);
            }
            GregorianCalendar gc = new GregorianCalendar(y, m, d);
            dateObj = new java.sql.Date(gc.getTime().getTime());
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79786, e.toString(), conn);
        }
        return dateObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static java.sql.Date getglDateObj(String dateStr, IfxConnection conn) throws SQLException {
        String glDateFormat = conn.getglDate();
        String glLocale = conn.getclLocale();
        int dateidx = 0;
        int tmpidx = 0;
        int y = -10000;
        int m = -85000;
        int d = -2500000;
        String yearpart = null;
        String monthpart = null;
        String daypart = null;
        DateFormatSymbols symbols = null;
        String[] defaultDays = new String[8];
        String[] defaultMonths = new String[13];
        String[] modifiedMonths = new String[13];
        java.sql.Date dateObj = null;
        String[] dateField = new String[3];
        String datepart = null;
        int datepartlen = 0;
        StringTokenizer xdirT = null;
        StringTokenizer DdirT = null;
        String tmpdateStr = null;
        String tmpdefDays = null;
        String tmpdefMnths = null;
        boolean needCentury = false;
        Locale clLocale = dateUtil.getLocaleValue(glLocale);
        symbols = new DateFormatSymbols(clLocale);
        int i = 0;
        while (i < glDateFormat.length()) {
            if (dateidx >= dateStr.length()) {
                throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
            }
            block1 : switch (glDateFormat.charAt(i)) {
                case '%': {
                    if (i == 0 || glDateFormat.charAt(i - 1) != '%') break;
                    ++dateidx;
                    break;
                }
                case 'a': {
                    Locale swiss_fr_loc;
                    int j;
                    int defDaylen;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        defaultDays = symbols.getShortWeekdays();
                        defDaylen = 0;
                        j = 0;
                        while (j < defaultDays.length - 1) {
                            tmpdefDays = defaultDays[j + 1].toLowerCase(clLocale);
                            defDaylen = defaultDays[j + 1].length();
                            if (dateidx + defDaylen <= dateStr.length()) {
                                Locale turkey_loc = new Locale("tr", "TR", "");
                                tmpdateStr = dateStr.substring(dateidx, dateidx + defDaylen).toLowerCase(clLocale);
                                if (tmpdateStr.indexOf(tmpdefDays) != -1) {
                                    swiss_fr_loc = new Locale("fr", "CH", "");
                                    if (clLocale.toString().equals(swiss_fr_loc.toString())) {
                                        dateidx += 3;
                                        break block1;
                                    }
                                    dateidx += defDaylen;
                                    break block1;
                                }
                                if ((clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) || clLocale.toString().equals(turkey_loc.toString())) && tmpdateStr.indexOf(tmpdefDays.substring(0, 3)) != -1) {
                                    dateidx += 3;
                                    break block1;
                                }
                            } else if (dateidx + 3 <= dateStr.length()) {
                                tmpdateStr = dateStr.substring(dateidx, dateidx + 3).toLowerCase(clLocale);
                                if (defDaylen >= 3 && tmpdateStr.equals(tmpdefDays.substring(0, 3))) {
                                    dateidx += 3;
                                    break block1;
                                }
                            }
                            ++j;
                        }
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'A': {
                    int j;
                    int defDaylen;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        defaultDays = symbols.getWeekdays();
                        defDaylen = 0;
                        j = 0;
                        while (j < defaultDays.length - 1) {
                            defDaylen = defaultDays[j + 1].length();
                            if (dateidx + defDaylen <= dateStr.length() && (tmpdateStr = dateStr.substring(dateidx, dateidx + defDaylen).toLowerCase(clLocale)).indexOf(tmpdefDays = defaultDays[j + 1].toLowerCase(clLocale)) != -1) {
                                dateidx += defDaylen;
                                break block1;
                            }
                            ++j;
                        }
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'b': 
                case 'h': {
                    int j;
                    String[] defMonths;
                    int defMthlen;
                    boolean month_found;
                    Locale swiss_fr_loc;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        month_found = false;
                        defMthlen = 0;
                        defaultMonths = symbols.getShortMonths();
                        int j2 = 0;
                        while (j2 < defaultMonths.length - 1) {
                            tmpdefMnths = defaultMonths[j2].toLowerCase(clLocale);
                            defMthlen = defaultMonths[j2].length();
                            if (dateidx + defMthlen <= dateStr.length()) {
                                swiss_fr_loc = new Locale("fr", "CH", "");
                                tmpdateStr = dateStr.substring(dateidx, dateidx + defMthlen).toLowerCase(clLocale);
                                if (tmpdateStr.indexOf(tmpdefMnths) != -1) {
                                    m = j2;
                                    month_found = true;
                                    dateidx += defMthlen;
                                    break;
                                }
                                if ((clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) || clLocale.toString().equals(swiss_fr_loc.toString())) && (tmpdateStr.indexOf(tmpdefMnths.substring(0, 3)) != -1 || tmpdefMnths.equals("juin") && tmpdateStr.substring(0, 3).equals("jun") || tmpdefMnths.equals("juil.") && tmpdateStr.substring(0, 3).equals("jul"))) {
                                    m = j2;
                                    month_found = true;
                                    dateidx += 3;
                                    break;
                                }
                            } else if (dateidx + 3 <= dateStr.length()) {
                                swiss_fr_loc = new Locale("fr", "CH", "");
                                tmpdateStr = dateStr.substring(dateidx, dateidx + 3).toLowerCase(clLocale);
                                if (defMthlen >= 3 && tmpdateStr.equals(tmpdefMnths.substring(0, 3))) {
                                    m = j2;
                                    month_found = true;
                                    dateidx += 3;
                                    break;
                                }
                                if ((clLocale.toString().equals(Locale.CANADA_FRENCH.toString()) || clLocale.toString().equals(swiss_fr_loc.toString())) && (tmpdefMnths.equals("juin") && tmpdateStr.equals("jun") || tmpdefMnths.equals("juil.") && tmpdateStr.equals("jul"))) {
                                    m = j2;
                                    month_found = true;
                                    dateidx += 3;
                                    break;
                                }
                            }
                            ++j2;
                        }
                        if (month_found) break;
                        defMonths = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", ""};
                        symbols.setShortMonths(defMonths);
                        modifiedMonths = symbols.getShortMonths();
                        j = 0;
                        while (j < modifiedMonths.length - 1) {
                            defMthlen = modifiedMonths[j].length();
                            if (dateidx + defMthlen <= dateStr.length() && (tmpdateStr = dateStr.substring(dateidx, dateidx + defMthlen).toLowerCase(clLocale)).indexOf(modifiedMonths[j]) != -1) {
                                m = j;
                                dateidx += defMthlen;
                                break block1;
                            }
                            ++j;
                        }
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'B': {
                    int j;
                    String[] defMonths;
                    int defMthlen;
                    boolean month_found;
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        month_found = false;
                        defMthlen = 0;
                        defaultMonths = symbols.getMonths();
                        int j3 = 0;
                        while (j3 < defaultMonths.length - 1) {
                            defMthlen = defaultMonths[j3].length();
                            if (dateidx + defMthlen <= dateStr.length() && (tmpdateStr = dateStr.substring(dateidx, dateidx + defMthlen).toLowerCase(clLocale)).indexOf(tmpdefMnths = defaultMonths[j3].toLowerCase(clLocale)) != -1) {
                                m = j3;
                                month_found = true;
                                dateidx += defMthlen;
                                break;
                            }
                            ++j3;
                        }
                        if (month_found) break;
                        defMonths = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", ""};
                        symbols.setMonths(defMonths);
                        modifiedMonths = symbols.getMonths();
                        j = 0;
                        while (j < modifiedMonths.length - 1) {
                            defMthlen = modifiedMonths[j].length();
                            if (dateidx + defMthlen <= dateStr.length() && (tmpdateStr = dateStr.substring(dateidx, dateidx + defMthlen).toLowerCase(clLocale)).indexOf(modifiedMonths[j]) != -1) {
                                m = j;
                                dateidx += defMthlen;
                                break block1;
                            }
                            ++j;
                        }
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'C': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        dateidx += 2;
                        break;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 3 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                        tmpidx = dateStr.indexOf(32, dateidx + 3);
                        if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + dateStr + "\"", conn);
                        dateidx = tmpidx + 1;
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'd': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (dateidx + 2 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                        daypart = dateStr.substring(dateidx, dateidx + 2);
                        d = stringUtil.stringToInt(daypart);
                        dateidx += 2;
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'D': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (dateidx + 8 <= dateStr.length()) {
                            tmpidx = dateidx + 8;
                        } else if (dateidx + 7 <= dateStr.length()) {
                            tmpidx = dateidx + 7;
                        } else {
                            if (dateidx + 6 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                            tmpidx = dateidx + 6;
                        }
                        DdirT = new StringTokenizer(dateStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (DdirT.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + dateStr + "\"", conn);
                        }
                        datepartlen = 0;
                        datepart = DdirT.nextToken();
                        m = stringUtil.stringToInt(datepart) - 1;
                        datepartlen += datepart.length();
                        datepart = DdirT.nextToken();
                        d = stringUtil.stringToInt(datepart);
                        datepartlen += datepart.length();
                        datepart = DdirT.nextToken();
                        y = stringUtil.stringToInt(datepart);
                        if (datepart.length() < 3) {
                            needCentury = true;
                        }
                        dateidx = dateidx + (datepartlen += datepart.length()) + 2;
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'e': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (dateidx != 0 && dateStr.charAt(dateidx - 1) == ' ') {
                            if (dateidx + 1 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                            daypart = dateStr.substring(dateidx, dateidx + 1);
                            ++dateidx;
                        } else {
                            if (dateidx + 2 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                            daypart = dateStr.substring(dateidx, dateidx + 2);
                            dateidx += 2;
                        }
                        d = stringUtil.stringToInt(daypart);
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'i': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') break;
                    ++dateidx;
                    break;
                }
                case 'E': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') break;
                    ++dateidx;
                    break;
                }
                case 'y': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%' || i >= 2 && glDateFormat.charAt(i - 1) == 'i' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 2 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                        yearpart = dateStr.substring(dateidx, dateidx + 2);
                        y = stringUtil.stringToInt(yearpart);
                        needCentury = true;
                        dateidx += 2;
                        break;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 3 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                        yearpart = dateStr.substring(dateidx, dateidx + 2);
                        y = stringUtil.stringToInt(yearpart);
                        needCentury = true;
                        tmpidx = dateStr.indexOf(32, dateidx + 3);
                        if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + dateStr + "\"", conn);
                        dateidx = tmpidx + 1;
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'Y': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%' || i >= 2 && glDateFormat.charAt(i - 1) == 'i' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 4 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                        yearpart = dateStr.substring(dateidx, dateidx + 4);
                        y = stringUtil.stringToInt(yearpart);
                        dateidx += 4;
                        break;
                    }
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 5 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                        yearpart = dateStr.substring(dateidx, dateidx + 4);
                        y = stringUtil.stringToInt(yearpart);
                        tmpidx = dateStr.indexOf(32, dateidx + 5);
                        if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + dateStr + "\"", conn);
                        dateidx = tmpidx + 1;
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'm': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%') {
                        if (dateidx + 2 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                        monthpart = dateStr.substring(dateidx, dateidx + 2);
                        m = stringUtil.stringToInt(monthpart) - 1;
                        dateidx += 2;
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'x': {
                    if (i != 0 && glDateFormat.charAt(i - 1) == '%' || i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        dateField = dateUtil.getLocaleDateOrder(clLocale, false);
                        if (dateidx + 10 <= dateStr.length()) {
                            tmpidx = dateidx + 10;
                        } else if (dateidx + 9 <= dateStr.length()) {
                            tmpidx = dateidx + 9;
                        } else if (dateidx + 8 <= dateStr.length()) {
                            tmpidx = dateidx + 8;
                        } else if (dateidx + 7 <= dateStr.length()) {
                            tmpidx = dateidx + 7;
                        } else {
                            if (dateidx + 6 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                            tmpidx = dateidx + 6;
                        }
                        xdirT = new StringTokenizer(dateStr.substring(dateidx, tmpidx), NONALPHANUMTOKS);
                        if (xdirT.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79809, "\"" + dateStr + "\"", conn);
                        }
                        datepartlen = 0;
                        int z = 0;
                        while (z < dateField.length) {
                            datepart = xdirT.nextToken();
                            datepartlen += datepart.length();
                            if (dateField[z].indexOf("YEAR") != -1) {
                                y = stringUtil.stringToInt(datepart);
                                if (datepart.length() < 3) {
                                    needCentury = true;
                                }
                            } else if (dateField[z].indexOf("MONTH") != -1) {
                                m = stringUtil.stringToInt(datepart) - 1;
                            } else {
                                d = stringUtil.stringToInt(datepart);
                            }
                            ++z;
                        }
                        datepartlen += 2;
                        if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                            if (dateidx + datepartlen + 1 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                            tmpidx = dateStr.indexOf(32, dateidx + datepartlen + 1);
                            if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + dateStr + "\"", conn);
                            dateidx = tmpidx + 1;
                            break;
                        }
                        dateidx += datepartlen;
                        break;
                    }
                    ++dateidx;
                    break;
                }
                case 'g': {
                    if (i >= 2 && glDateFormat.charAt(i - 1) == 'E' && glDateFormat.charAt(i - 2) == '%') {
                        if (dateidx + 3 > dateStr.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + dateStr + "\"", conn);
                        tmpidx = dateStr.indexOf(32, dateidx + 3);
                        if (tmpidx == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + dateStr + "\"", conn);
                        dateidx = tmpidx + 1;
                        break;
                    }
                    ++dateidx;
                    break;
                }
                default: {
                    ++dateidx;
                    break;
                }
            }
            ++i;
        }
        try {
            if (needCentury) {
                y += dateUtil.getCentury(conn, y, m + 1, d);
            }
            GregorianCalendar gc = new GregorianCalendar(y, m, d);
            return new java.sql.Date(gc.getTime().getTime());
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79786, e.toString(), conn);
        }
    }

    private static java.sql.Date getLocaleDateObj(String dateStr, IfxConnection conn) throws SQLException {
        String dateLocale = conn.getclLocale();
        int y = -10000;
        int m = -85000;
        int d = -2500000;
        java.sql.Date dateObj = null;
        String datepart = null;
        boolean needCentury = false;
        Locale clLocale = dateUtil.getLocaleValue(dateLocale);
        StringTokenizer dT = new StringTokenizer(dateStr, "/-.");
        if (dT.countTokens() != 3) {
            throw IfxErrMsg.getSQLException(-79802, "\"" + dateStr + "\"", conn);
        }
        String[] dateField = dateUtil.getLocaleDateOrder(clLocale, false);
        int i = 0;
        while (i < dateField.length) {
            datepart = dT.nextToken();
            if (dateField[i].indexOf("YEAR") != -1) {
                y = stringUtil.stringToInt(datepart);
                if (datepart.length() < 3) {
                    needCentury = true;
                }
            } else if (dateField[i].indexOf("MONTH") != -1) {
                m = stringUtil.stringToInt(datepart) - 1;
            } else {
                d = stringUtil.stringToInt(datepart);
            }
            ++i;
        }
        try {
            if (needCentury) {
                y += dateUtil.getCentury(conn, y, m + 1, d);
            }
            GregorianCalendar gc = new GregorianCalendar(y, m, d);
            dateObj = new java.sql.Date(gc.getTime().getTime());
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79786, e.toString(), conn);
        }
        return dateObj;
    }

    private static String[] getLocaleDateOrder(Locale clLocale, boolean retToken) {
        String datepart = null;
        String[] dateField = !retToken ? new String[3] : new String[5];
        GregorianCalendar gc = new GregorianCalendar(1964, 1, 7);
        java.sql.Date dateObj = new java.sql.Date(gc.getTime().getTime());
        int dateStyle = 3;
        DateFormat formatter = DateFormat.getDateInstance(dateStyle, clLocale);
        String locdateStr = formatter.format(dateObj);
        StringTokenizer locdT = new StringTokenizer(locdateStr, "/-.", retToken);
        int i = 0;
        while (i < dateField.length) {
            datepart = locdT.nextToken();
            dateField[i] = datepart.indexOf("64") != -1 ? (datepart.length() > 2 ? "YEAR4" : "YEAR2") : (datepart.equals("02") ? "MONTH2" : (datepart.equals("2") ? "MONTH1" : (datepart.equals("07") ? "DAY2" : (datepart.equals("7") ? "DAY1" : (datepart.equals(SLASH) ? SLASH : (datepart.equals(HYPHEN) ? HYPHEN : PERIOD))))));
            ++i;
        }
        return dateField;
    }

    public static Locale getLocaleValue(String dateLocale) {
        Locale clLocale = null;
        if (dateLocale != null) {
            StringTokenizer dT = new StringTokenizer(dateLocale, UNDERSCORE);
            String lang = dT.nextToken();
            String ccode = dT.nextToken();
            clLocale = new Locale(lang, ccode);
        } else {
            clLocale = new Locale(Locale.getDefault().getLanguage(), Locale.getDefault().getCountry());
        }
        return clLocale;
    }

    public static String convertNativeSQLDate(String dateStr, IfxConnection conn) throws SQLException {
        String locdateStr = null;
        String locdateFmt = "";
        if (conn.getdbDate() != null) {
            locdateFmt = conn.getdbDate();
            locdateStr = dateUtil.convertdbDate(dateStr, conn.getclLocale(), locdateFmt);
        } else if (conn.getglDate() != null) {
            locdateFmt = conn.getglDate();
            locdateStr = dateUtil.convertglDate(dateStr, conn.getclLocale(), locdateFmt);
        } else {
            locdateStr = dateUtil.convertcllDate(dateStr, conn.getclLocale());
        }
        if (locdateStr == null) {
            throw IfxErrMsg.getSQLException(-79785, "\"" + locdateFmt + "\"", conn);
        }
        return locdateStr;
    }

    public static String convertDateStr(java.sql.Date date, IfxConnection conn) throws SQLException {
        String locdateStr = null;
        if (conn.getdbDate() != null) {
            locdateStr = dateUtil.getdbDateStr(date, conn.getclLocale(), conn.getdbDate());
        } else if (conn.getglDate() != null) {
            boolean nativeSQL = false;
            locdateStr = dateUtil.getglDateStr(date, conn.getclLocale(), conn.getglDate(), nativeSQL);
        } else {
            locdateStr = dateUtil.getLocaleDateStr(date, conn.getclLocale());
        }
        return locdateStr;
    }

    public static java.sql.Date convertDateObj(String dateStr, IfxConnection conn) throws SQLException {
        java.sql.Date locdateObj = null;
        locdateObj = conn.getdbDate() != null ? dateUtil.getdbDateObj(dateStr, conn) : (conn.getglDate() != null ? dateUtil.getglDateObj(dateStr, conn) : dateUtil.getLocaleDateObj(dateStr, conn));
        return locdateObj;
    }

    private static String getglDateXPattern(String[] dateField) {
        String xpattern = "";
        int z = 0;
        while (z < dateField.length) {
            xpattern = dateField[z].equals("YEAR4") ? String.valueOf(xpattern) + "yyyy" : (dateField[z].equals("YEAR2") ? String.valueOf(xpattern) + "yy" : (dateField[z].equals("MONTH1") ? String.valueOf(xpattern) + "M" : (dateField[z].equals("MONTH2") ? String.valueOf(xpattern) + "MM" : (dateField[z].equals("DAY1") ? String.valueOf(xpattern) + "d" : (dateField[z].equals("DAY2") ? String.valueOf(xpattern) + "dd" : (dateField[z].equals(SLASH) ? String.valueOf(xpattern) + SLASH : (dateField[z].equals(HYPHEN) ? String.valueOf(xpattern) + HYPHEN : String.valueOf(xpattern) + PERIOD)))))));
            ++z;
        }
        return xpattern;
    }

    private static String getInfmxglPattern(java.sql.Date date, char glDirective, Locale clLocale) {
        String infmxPattern = "";
        DateFormatSymbols symbols = new DateFormatSymbols(clLocale);
        String[] jdkdefDays = new String[8];
        String[] infmxdefDays = new String[8];
        String[] jdkdefMonths = new String[13];
        String[] infmxdefMonths = new String[13];
        String dateStr = null;
        block0 : switch (glDirective) {
            case 'b': 
            case 'h': {
                String[] tmpdefMonths;
                dateStr = dateUtil.formatDate(date, clLocale, "MMM");
                jdkdefMonths = symbols.getShortMonths();
                if (clLocale.toString().equals(Locale.JAPAN.toString())) {
                    tmpdefMonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};
                    System.arraycopy(tmpdefMonths, 0, infmxdefMonths, 0, 13);
                } else {
                    tmpdefMonths = new String[]{"Jan", "F\u00e9v", "Mar", "Avr", "Mai", "Jun", "Jul", "Ao\u00fb", "Sep", "Oct", "Nov", "D\u00e9c", ""};
                    System.arraycopy(tmpdefMonths, 0, infmxdefMonths, 0, 13);
                }
                int j = 0;
                while (j < jdkdefMonths.length - 1) {
                    if (dateStr.equals(jdkdefMonths[j])) {
                        infmxPattern = infmxdefMonths[j];
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            case 'B': {
                dateStr = dateUtil.formatDate(date, clLocale, "MMMMM");
                jdkdefMonths = symbols.getMonths();
                String[] tmpdefMonths = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""};
                System.arraycopy(tmpdefMonths, 0, infmxdefMonths, 0, 13);
                int j = 0;
                while (j < jdkdefMonths.length - 1) {
                    if (dateStr.equals(jdkdefMonths[j])) {
                        infmxPattern = infmxdefMonths[j];
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            case 'a': {
                String[] tmpdefDays;
                dateStr = dateUtil.formatDate(date, clLocale, "E");
                jdkdefDays = symbols.getShortWeekdays();
                Locale turkey_loc = new Locale("tr", "TR", "");
                if (clLocale.toString().equals(turkey_loc.toString())) {
                    tmpdefDays = new String[]{"", "Pzr", "Pzt", "Sal", "\u00e7ar", "Per", "Cum", "Cts"};
                    System.arraycopy(tmpdefDays, 0, infmxdefDays, 0, 8);
                } else {
                    tmpdefDays = new String[]{"", "Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"};
                    System.arraycopy(tmpdefDays, 0, infmxdefDays, 0, 8);
                }
                int j = 0;
                while (j < jdkdefDays.length - 1) {
                    if (dateStr.equals(jdkdefDays[j + 1])) {
                        infmxPattern = infmxdefDays[j + 1];
                        break block0;
                    }
                    ++j;
                }
                break;
            }
        }
        return infmxPattern;
    }

    private static int getCentury(IfxConnection conn, int year, int month, int day) throws SQLException {
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79716, "getCentury: conn is null.", null);
        }
        Trace trace = conn.getTrace();
        trace.writeTrace(1, "dateUtil: getCentury() entered");
        trace.writeTrace(3, "    getCentury() year: " + year);
        trace.writeTrace(3, "    getCentury() month: " + month);
        trace.writeTrace(3, "    getCentury() day: " + day);
        trace.writeTrace(3, "    getCentury() dbcentury: " + conn.getdbCentury());
        trace.writeTrace(1, "");
        if (year > 99) {
            return 0;
        }
        GregorianCalendar gcToday = null;
        int currentCentury = 0;
        int centuryReturned = 0;
        gcToday = dateUtil.getCurrentDateGC(conn);
        currentCentury = gcToday.get(1) / 100;
        if (conn.getdbCentury() == null || conn.getdbCentury().equalsIgnoreCase("R")) {
            trace.writeTrace(2, "    getCentury() just return the current");
            centuryReturned = currentCentury;
        } else {
            long msToday = 0L;
            long msPresent = 0L;
            long msFuture = 0L;
            long msPast = 0L;
            GregorianCalendar gc = null;
            msToday = gcToday.getTime().getTime();
            int currentMonth = gcToday.get(2);
            int currentDay = gcToday.get(5);
            trace.writeTrace(2, "    getCentury() currentMonth: " + currentMonth);
            trace.writeTrace(2, "    getCentury() currentDay: " + currentDay);
            trace.writeTrace(2, "    getCentury() currentCentury: " + currentCentury);
            trace.writeTrace(2, "");
            int tmpMonth = month;
            int tmpDay = day;
            int tmpYear = currentCentury * 100 + year;
            if (tmpMonth == 29 && tmpDay == 2 && dateUtil.isLeapYear(tmpYear)) {
                tmpMonth = 3;
                tmpDay = 1;
            }
            gc = new GregorianCalendar(tmpYear, tmpMonth - 1, tmpDay);
            msPresent = gc.getTime().getTime();
            trace.writeTrace(2, "    getCentury() msPresent: " + msPresent);
            trace.writeTrace(2, "    getCentury() Present: " + gc.getTime());
            trace.writeTrace(2, "");
            tmpMonth = month;
            tmpDay = day;
            tmpYear = (currentCentury - 1) * 100 + year;
            if (tmpMonth == 29 && tmpDay == 2 && dateUtil.isLeapYear(tmpYear)) {
                tmpMonth = 3;
                tmpDay = 1;
            }
            gc = new GregorianCalendar(tmpYear, tmpMonth - 1, tmpDay);
            msPast = gc.getTime().getTime();
            trace.writeTrace(2, "    getCentury() msPast: " + msPast);
            trace.writeTrace(2, "    getCentury() Past: " + gc.getTime());
            trace.writeTrace(2, "");
            tmpMonth = month;
            tmpDay = day;
            tmpYear = (currentCentury + 1) * 100 + year;
            if (tmpMonth == 29 && tmpDay == 2 && dateUtil.isLeapYear(tmpYear)) {
                tmpMonth = 3;
                tmpDay = 1;
            }
            gc = new GregorianCalendar(tmpYear, tmpMonth - 1, tmpDay);
            msFuture = gc.getTime().getTime();
            trace.writeTrace(2, "    getCentury() msFuture: " + msFuture);
            trace.writeTrace(2, "    getCentury() Future: " + gc.getTime());
            trace.writeTrace(2, "");
            long present_diff = 0L;
            long past_diff = 0L;
            long future_diff = 0L;
            char dbCentury = conn.getdbCentury().toUpperCase().charAt(0);
            switch (dbCentury) {
                case 'C': {
                    present_diff = Math.abs(msPresent - msToday);
                    past_diff = Math.abs(msPast - msToday);
                    future_diff = Math.abs(msFuture - msToday);
                    String s = "    getCentury() 'C': \n";
                    s = String.valueOf(s) + "\tpresent_diff: " + present_diff + "\n";
                    s = String.valueOf(s) + "\tpast_diff: " + past_diff + "\n ";
                    s = String.valueOf(s) + "\tfuture_diff: " + future_diff + "\n";
                    trace.writeTrace(2, "    getCentury() 'C': " + s);
                    trace.writeTrace(2, "");
                    if (present_diff < past_diff) {
                        if (present_diff < future_diff) {
                            centuryReturned = currentCentury;
                            break;
                        }
                        centuryReturned = currentCentury + 1;
                        break;
                    }
                    if (past_diff < future_diff) {
                        centuryReturned = currentCentury - 1;
                        break;
                    }
                    centuryReturned = currentCentury + 1;
                    break;
                }
                case 'P': {
                    present_diff = msPresent - msToday;
                    past_diff = msPast - msToday;
                    String s = "    getCentury() 'P': \n";
                    s = String.valueOf(s) + "\tpresent_diff: " + present_diff + "\n";
                    s = String.valueOf(s) + "\tpast_diff: " + past_diff + "\n ";
                    trace.writeTrace(2, "    getCentury() 'P': " + s);
                    trace.writeTrace(2, "");
                    if (present_diff < 0L) {
                        centuryReturned = currentCentury;
                        break;
                    }
                    centuryReturned = currentCentury - 1;
                    break;
                }
                case 'F': {
                    present_diff = msPresent - msToday;
                    future_diff = msFuture - msToday;
                    String s = "    getCentury() 'F': \n";
                    s = String.valueOf(s) + "\tpresent_diff: " + present_diff + "\n";
                    s = String.valueOf(s) + "\tfuture_diff: " + future_diff + "\n";
                    trace.writeTrace(2, "    getCentury() 'C': " + s);
                    trace.writeTrace(2, "");
                    if (present_diff > 0L) {
                        centuryReturned = currentCentury;
                        break;
                    }
                    centuryReturned = currentCentury + 1;
                    break;
                }
                default: {
                    centuryReturned = currentCentury;
                    break;
                }
            }
        }
        trace.writeTrace(2, "dateUtil: getCentury() centuryReturned = " + centuryReturned);
        trace.writeTrace(1, "dateUtil: getCentury() exited");
        return centuryReturned * 100;
    }

    public static GregorianCalendar getCurrentDateGC(IfxConnection conn) throws SQLException {
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79716, "getCurrentDateGC: conn is null.", null);
        }
        Trace trace = conn.getTrace();
        trace.writeTrace(1, "dateUtil: getCurrentDateGC() entered");
        trace.writeTrace(3, "    getCurrentDateGC() locString: " + conn.getclLocale());
        trace.writeTrace(3, "    getCurrentDateGC() dbTodayStart: " + conn.getdbTodayStart());
        trace.writeTrace(3, "    getCurrentDateGC() getdbTodayDate: " + conn.getdbTodayDate());
        Locale loc = dateUtil.getLocaleValue(conn.getclLocale());
        GregorianCalendar gcToday = new GregorianCalendar(loc);
        trace.writeTrace(3, "    gcToday(): " + gcToday.getTime());
        long dbTodayStart = conn.getdbTodayStart();
        long dbTodayDate = conn.getdbTodayDate();
        if (dbTodayDate != -1L && dbTodayStart != -1L) {
            long currentMillis = gcToday.getTime().getTime();
            long diff = currentMillis - dbTodayStart;
            long current = dbTodayDate + diff;
            Date d = new Date(current);
            gcToday = new GregorianCalendar();
            gcToday.setTime(d);
        }
        trace.writeTrace(3, "    getCurrentDateGC() value returned: " + gcToday.getTime());
        trace.writeTrace(1, "dateUtil: getCurrentDateGC() exited");
        return gcToday;
    }
}

