/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.util.TraceOS;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class Trace {
    private final int DEF_TRACE_LEVEL = 0;
    private final int HEX_SIZE = 22;
    private final int HEX_ASCII_SIZE = 16;
    private int traceLevel = 0;
    private String traceFile;
    private TraceOS dataOS;

    public Trace() {
        this.traceLevel = 0;
        this.traceFile = null;
    }

    public void resetTrace() {
        this.closeTraceFile();
        this.traceFile = null;
        this.traceLevel = 0;
    }

    public Trace(int level, String fileName) {
        if (level == 0) {
            return;
        }
        if (fileName == null) {
            this.traceLevel = 0;
            System.err.println("Trace file is null, setting trace level to 0");
            return;
        }
        try {
            this.dataOS = new TraceOS(new PrintWriter((Writer)new BufferedWriter(new FileWriter(fileName, true)), true));
        }
        catch (Exception e) {
            System.err.println("Cannot Open FileOutputStream for Trace" + e.toString());
            System.err.println("No Tracing will be done");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (this.dataOS.checkError()) {
            this.resetTrace();
        } else {
            this.traceLevel = level;
            this.traceFile = fileName;
        }
    }

    public void setTraceLevel(int level) {
        this.traceLevel = level;
    }

    public synchronized void setNewTraceFile(int level, String fileName) {
        this.closeTraceFile();
        if (level == 0) {
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (fileName == null) {
            System.err.println("Filename is null, resetting Trace\n");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        try {
            this.dataOS = new TraceOS(new PrintWriter((Writer)new BufferedWriter(new FileWriter(fileName, true)), true));
        }
        catch (Exception e) {
            System.err.println("Cannot reOpen FileOutputStream for Trace" + e.toString());
            System.err.println("No Tracing will be done");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (this.dataOS.checkError()) {
            this.resetTrace();
        } else {
            this.traceLevel = level;
            this.traceFile = fileName;
        }
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public synchronized void setTraceOS(TraceOS traceOS) {
        if (this.dataOS != null && !this.dataOS.equals(traceOS)) {
            this.closeTraceFile();
        }
        this.dataOS = traceOS;
    }

    public TraceOS getTraceOS() {
        return this.dataOS;
    }

    public void closeTraceFile() {
        if (this.dataOS != null) {
            this.dataOS.flush();
            this.dataOS.close();
        }
    }

    public void writeTrace(int levelNum, String stringInfo) {
        if (this.traceLevel < levelNum) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(stringInfo);
        }
    }

    public void writeTrace(int levelNum, String stringInfo, String data) {
        this.writeTrace(levelNum, String.valueOf(stringInfo) + data);
    }

    public void writeTrace(int levelNum, String stringInfo, int data) {
        this.writeTrace(levelNum, String.valueOf(stringInfo) + data);
    }

    public void writeTrace(int levelNum, int data) {
        if (this.traceLevel < levelNum) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(data);
        }
    }

    public void writeTrace(int levelNum, String stringInfo, short data) {
        this.writeTrace(levelNum, String.valueOf(stringInfo) + data);
    }

    public void writeTrace(int levelNum, short data) {
        if (this.traceLevel < levelNum) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(data);
        }
    }

    public void writeTrace(int levelNum, String stringInfo, double data) {
        this.writeTrace(levelNum, String.valueOf(stringInfo) + data);
    }

    public void writeTrace(int levelNum, double data) {
        if (this.traceLevel < levelNum) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(data);
        }
    }

    public void writeTrace(int levelNum, String stringInfo, float data) {
        this.writeTrace(levelNum, String.valueOf(stringInfo) + data);
    }

    public void writeTrace(int levelNum, float data) {
        if (this.traceLevel < levelNum) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(data);
        }
    }

    public void writeTrace(int levelNum, String stringInfo, long data) {
        this.writeTrace(levelNum, String.valueOf(stringInfo) + data);
    }

    public void writeTrace(int levelNum, long data) {
        if (this.traceLevel < levelNum) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(data);
        }
    }

    public void writeTrace(int levelNum, String stringInfo, boolean data) {
        this.writeTrace(levelNum, String.valueOf(stringInfo) + data);
    }

    public void writeTrace(int levelNum, boolean data) {
        if (this.traceLevel < levelNum) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(data);
        }
    }

    public void writeTrace(int levelNum, byte[] byteData, char format) {
        this.writeTrace(levelNum, byteData, format, byteData.length);
    }

    public void writeTrace(int levelNum, byte[] byteData, char format, int size) {
        this.writeTrace(levelNum, byteData, 0, format, size);
    }

    public void writeTrace(int levelNum, byte[] byteData, int offset, char format, int size) {
        int j = 0;
        boolean hexOnly = true;
        StringBuffer strAscii = null;
        StringBuffer strHex = null;
        int bytesDisplayed = 22;
        if (this.traceLevel < levelNum) {
            return;
        }
        if (format == 'b' || format == 'B') {
            hexOnly = false;
            bytesDisplayed = 16;
            strAscii = new StringBuffer(bytesDisplayed);
        }
        strHex = new StringBuffer(bytesDisplayed * 4);
        try {
            if (hexOnly) {
                this.dataOS.println("=================================-========================================");
                this.dataOS.println("Index:   Hex:");
            } else {
                this.dataOS.println("========================================================      ================");
                this.dataOS.println("Index:   Hex:                                                 Ascii:\n");
            }
            if (this.dataOS == null) {
                this.dataOS.println("   ***** NULL data *****  ");
                return;
            }
            int i = 0;
            while (i < size) {
                Byte byteValue = new Byte(byteData[i + offset]);
                int intValue = byteValue.intValue();
                if (j == 0) {
                    strHex.append("0x");
                    if (i < 16) {
                        strHex.append("000");
                    } else if (i < 256) {
                        strHex.append("00");
                    } else if (i < 4096) {
                        strHex.append("0");
                    }
                    strHex.append(Integer.toHexString(i));
                    strHex.append(":  ");
                }
                if ((intValue &= 0xFF) < 16) {
                    strHex.append("0");
                }
                strHex.append(Integer.toHexString(intValue));
                strHex.append(" ");
                if (!hexOnly) {
                    if ((intValue &= 0xFF) >= 32 && intValue <= 126) {
                        Character charValue = new Character((char)intValue);
                        strAscii.append(charValue.toString());
                    } else {
                        strAscii.append(".");
                    }
                }
                if (j == bytesDisplayed - 1) {
                    this.dataOS.print(strHex.toString());
                    strHex = new StringBuffer(bytesDisplayed * 4);
                    if (!hexOnly) {
                        this.dataOS.print("     ");
                        this.dataOS.print(strAscii.toString());
                        strAscii = new StringBuffer(bytesDisplayed);
                    }
                    this.dataOS.println("");
                    j = -1;
                }
                ++i;
                ++j;
            }
            if (j > -1) {
                this.dataOS.print(strHex.toString());
                if (!hexOnly) {
                    while (j < bytesDisplayed) {
                        this.dataOS.print("   ");
                        ++j;
                    }
                    this.dataOS.print("     ");
                    this.dataOS.print(strAscii.toString());
                }
            }
            this.dataOS.println("");
            if (hexOnly) {
                this.dataOS.println("==========================================================================");
            } else {
                this.dataOS.println("==============================================================================");
            }
            this.dataOS.println("");
        }
        catch (Exception exception) {
            System.out.println("Exception in writeTrace...");
            System.out.println("Trying to create a Table ...\n");
        }
    }
}

