/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.msg.sqlBundle;
import com.informix.util.IfxErrMsg;
import java.util.Locale;

public class IfxMessage {
    private static final short MsgBufInitSize = 256;

    private static String getBundleName(int sqlcode) {
        String bundle = null;
        int poscode = Math.abs(sqlcode);
        bundle = sqlBundle.getBundleName(sqlcode);
        if (bundle != null) {
            return bundle;
        }
        bundle = poscode >= 1 && poscode <= 79 || poscode == 32765 ? "com.informix.msg.os" : (poscode >= 79700 && poscode <= 79999 ? "com.informix.msg.jdbc" : (poscode >= 80000 && poscode <= 89999 ? "com.informix.msg.jdbcminor" : (poscode >= 1200 && poscode <= 1299 ? "com.informix.msg.rds" : (poscode >= 100 && poscode <= 199 ? "com.informix.msg.isam" : (poscode >= 23101 && poscode <= 23199 ? "com.informix.msg.cals" : (poscode >= 7200 && poscode <= 7212 ? "com.informix.msg.nls" : (poscode >= 27000 && poscode <= 29999 ? "com.informix.msg.net" : (poscode >= 25500 && poscode <= 25599 ? "com.informix.msg.netsrv" : (poscode >= 36000 && poscode <= 36999 ? "com.informix.msg.xopen" : (poscode >= 5000 && poscode <= 5022 ? "com.informix.msg.ccsm" : "com.informix.msg.os"))))))))));
        return bundle;
    }

    public static String getMessage(int sqlcode) {
        String sqlcodeStr = Integer.toString(sqlcode);
        String bundle = IfxMessage.getBundleName(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, null);
        return msg;
    }

    public static String getMessage(int sqlcode, String locale) {
        String sqlcodeStr = Integer.toString(sqlcode);
        String bundle = IfxMessage.getBundleName(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, locale);
        return msg;
    }

    public static String getMessage(int sqlcode, Locale loc) {
        String sqlcodeStr = Integer.toString(sqlcode);
        String bundle = IfxMessage.getBundleName(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, loc);
        return msg;
    }

    public static String getMessage(String msgtext, String arg1, String locale) {
        int index2;
        if (msgtext == null) {
            return null;
        }
        int index1 = msgtext.indexOf("%s");
        if (index1 >= 0 || (index1 = msgtext.indexOf("%d")) >= 0) {
            index2 = index1 + 2;
        } else {
            index1 = msgtext.indexOf("%ld");
            if (index1 >= 0) {
                index2 = index1 + 3;
            } else {
                return msgtext;
            }
        }
        StringBuffer msg = new StringBuffer(256).append(msgtext.substring(0, index1)).append(arg1).append(msgtext.substring(index2));
        return msg.toString();
    }

    public static String getMessage(int sqlcode, String arg1, String locale) {
        String bundle = IfxMessage.getBundleName(sqlcode);
        String sqlcodeStr = Integer.toString(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, locale);
        return IfxMessage.getMessage(msg, arg1, null);
    }

    public static String getMessage(String msgtext, String arg1, String arg2, String locale) {
        return IfxMessage.getMessage(IfxMessage.getMessage(msgtext, arg1, locale), arg2, locale);
    }

    public static String getMessage(int sqlcode, String arg1, String arg2, String locale) {
        String bundle = IfxMessage.getBundleName(sqlcode);
        String sqlcodeStr = Integer.toString(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle, locale);
        return IfxMessage.getMessage(msg, arg1, arg2, locale);
    }

    public static String getSQLSTATE(int sqlcode) {
        String bundle = "com.informix.msg.itoxmsg";
        String sqlcodeStr = Integer.toString(sqlcode);
        String msg = IfxErrMsg.getErrMsg(sqlcodeStr, bundle);
        if (msg == null) {
            return "IX000";
        }
        return msg;
    }
}

