/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.memoryUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class JavaToIfxType {
    public static final int IFX_INT_SIZE = 4;
    public static final int BYTESHIFT = 8;
    public static final int BYTEMASK = 255;
    public static final int IFX_LGINT_SIZE = 10;
    public static final int IFX_SMINT_SIZE = 2;
    public static final int IFX_SMFLOAT_SIZE = 4;
    public static final int IFX_LONG_SIZE = 8;
    public static final int IFX_DOUBLE_SIZE = 8;
    public static final int DefDblScale = 10;
    public static final int DefFltScale = 10;
    private static Calendar Cal = Calendar.getInstance();
    protected static final boolean TruncateFractSec = true;
    static final int NanosPerSecond = 1000000000;
    static final int MilliPerSecond = 1000;
    static final int SecondsPerMinute = 60;
    static final int SecondsPerHour = 3600;
    static final int SecondsPerDay = 86400;
    static final int MonthsPerYear = 12;
    public static byte[] DATETIME_PREC = new byte[2];
    public static short DP_SHORT;

    public static byte[] JavaToIfxInt(int i) {
        byte[] b = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return b;
    }

    public static byte[] JavaToIfxChar(String s) {
        int x = s.length();
        byte[] b = new byte[x + 2];
        byte[] temp = s.getBytes();
        b[0] = (byte)(x >> 8 & 0xFF);
        b[1] = (byte)(x & 0xFF);
        System.arraycopy(temp, 0, b, 2, x);
        return b;
    }

    public static byte[] JavaToIfxChar(String s, String dbEnc) throws IOException {
        byte[] temp = null;
        temp = dbEnc != null ? s.getBytes(dbEnc) : s.getBytes();
        int x = temp.length;
        byte[] b = new byte[x + 2];
        b[0] = (byte)(x >> 8 & 0xFF);
        b[1] = (byte)(x & 0xFF);
        System.arraycopy(temp, 0, b, 2, x);
        return b;
    }

    public static byte[] JavaToIfxVarChar(String s, String dbEnc, int leng) throws IOException {
        byte[] temp = null;
        temp = dbEnc != null ? s.getBytes(dbEnc) : s.getBytes();
        byte[] b = new byte[leng + 1];
        memoryUtil.byfill(b, (byte)0);
        int x = temp.length;
        int y = Math.min(x, leng);
        b[0] = (byte)(x & 0xFF);
        System.arraycopy(temp, 0, b, 1, y);
        return b;
    }

    public static byte[] JavaToIfxDate(Date d) {
        int dtVal = IfxToJavaType.convertDateToDays(d);
        return JavaToIfxType.JavaToIfxInt(dtVal);
    }

    public static String convertNanosToFract(int nano) {
        char[] s = new char[5];
        double reducedNano = (double)nano / 10000.0 + 0.0;
        String st = Integer.toString((int)reducedNano);
        Decimal.charfill(s, 0, 4, '0');
        int minS = st.length() - 6;
        int j = 4;
        int i = st.length() - 1;
        while (i >= 0 && i >= minS) {
            s[j] = st.charAt(i);
            --i;
            --j;
        }
        return new String(s);
    }

    public static synchronized String convertTimestampToString(Timestamp t) {
        Cal.setTime(t);
        int yr = Cal.get(1);
        int month = Cal.get(2) + 1;
        int day = Cal.get(5);
        int hour = Cal.get(11);
        int minute = Cal.get(12);
        int second = Cal.get(13);
        int nanos = t.getNanos();
        String s = String.valueOf(yr);
        s = month < 10 ? String.valueOf(s) + "0" + month : String.valueOf(s) + month;
        s = day < 10 ? String.valueOf(s) + "0" + day : String.valueOf(s) + day;
        s = hour < 10 ? String.valueOf(s) + "0" + hour : String.valueOf(s) + hour;
        s = minute < 10 ? String.valueOf(s) + "0" + minute : String.valueOf(s) + minute;
        s = second < 10 ? String.valueOf(s) + "0" + second : String.valueOf(s) + second;
        s = String.valueOf(s) + "." + JavaToIfxType.convertNanosToFract(nanos);
        return s;
    }

    public static synchronized String convertTimeToString(Time t) {
        Cal.setTime(t);
        int hour = Cal.get(11);
        int minute = Cal.get(12);
        int second = Cal.get(13);
        String s = "";
        s = hour < 10 ? String.valueOf(s) + "0" + hour : String.valueOf(s) + hour;
        s = minute < 10 ? String.valueOf(s) + "0" + minute : String.valueOf(s) + minute;
        s = second < 10 ? String.valueOf(s) + "0" + second : String.valueOf(s) + second;
        return s;
    }

    public static String convertIntervalToString(IntervalDF i) {
        StringBuffer retval = new StringBuffer();
        boolean fNeg = false;
        long secs = i.getSeconds();
        long nans = i.getNanoSeconds();
        if (secs < 0L || secs == 0L && nans < 0L) {
            fNeg = true;
            secs = -secs;
            nans = -nans;
        }
        if (secs > 0L) {
            int days = (int)Math.floor(secs / 86400L);
            secs %= 86400L;
            if (days < 10) {
                retval.append('0');
            }
            retval.append(days);
            int hours = (int)Math.floor(secs / 3600L);
            secs %= 3600L;
            if (hours < 10) {
                retval.append('0');
            }
            retval.append(hours);
            int mins = (int)Math.floor(secs / 60L);
            secs %= 60L;
            if (mins < 10) {
                retval.append('0');
            }
            retval.append(mins);
            if (secs < 10L) {
                retval.append('0');
            }
            retval.append(secs);
        }
        retval.append('.');
        String s1 = JavaToIfxType.convertNanosToFract((int)nans);
        retval.append(s1);
        if (fNeg) {
            String t = retval.toString();
            t = "-" + t;
            return t;
        }
        return retval.toString();
    }

    public static String convertIntervalToString(IntervalYM i) {
        boolean fNeg = false;
        long months = i.getMonths();
        if (months < 0L) {
            months = -months;
            fNeg = true;
        }
        String r = String.valueOf(months / 12L);
        int len = r.length();
        r.trim();
        String t = String.valueOf(months % 12L);
        len = t.length();
        if (len < 2) {
            StringBuffer sb = new StringBuffer();
            int ii = 0;
            while (ii < 2 - len) {
                sb.append("0");
                ++ii;
            }
            sb.append(t);
            t = sb.toString();
        }
        String s = fNeg ? "-" + r + t : String.valueOf(r) + t;
        return s;
    }

    public static byte[] JavaToIfxDateTime(Timestamp t) {
        String ts = JavaToIfxType.convertTimestampToString(t);
        byte[] buf = new Decimal(ts).javaToIfx();
        return buf;
    }

    public static byte[] JavaToIfxDateTime(Time t) {
        String ts = JavaToIfxType.convertTimeToString(t);
        byte[] buf = new Decimal(ts).javaToIfx();
        return buf;
    }

    public static byte[] JavaToIfxInterval(IntervalDF t) {
        byte[] ii = new byte[2];
        long secs = t.getSeconds();
        if (secs < 0L) {
            secs = -secs;
        }
        String ts = JavaToIfxType.convertIntervalToString(t);
        if (secs <= 0L) {
            ii = Decimal.encodeIntervalPrecision(ii, (byte)2, (byte)12, (byte)15);
        } else {
            byte flen = ts.charAt(0) == '-' ? (byte)(ts.length() - 13) : (byte)(ts.length() - 12);
            ii = Decimal.encodeIntervalPrecision(ii, flen, (byte)4, (byte)15);
        }
        short inPrec = (short)(ii[0] * 256 + ii[1]);
        Decimal dd = new Decimal(ts, inPrec);
        byte[] buf = dd.javaToIfx();
        return buf;
    }

    public static byte[] JavaToIfxInterval(IntervalYM t) {
        byte[] ii = new byte[2];
        String ts = JavaToIfxType.convertIntervalToString(t);
        long months = t.getMonths();
        if (months < 0L) {
            months = -months;
        }
        String s = new Long(months /= 12L).toString();
        s.trim();
        ii = Decimal.encodeIntervalPrecision(ii, (byte)s.length(), (byte)0, (byte)2);
        short inPrec = (short)(ii[0] * 256 + ii[1]);
        byte[] buf = new Decimal(ts, inPrec).javaToIfx();
        return buf;
    }

    public static final byte[] JavaToIfxDecimalNull(short qual) {
        byte dgt_len = (byte)(qual >> 8 & 0xFF);
        byte TU_end = (byte)(qual & 0xF);
        byte len = (byte)((dgt_len + (TU_end & 1) + 1) / 2);
        byte[] ret = new byte[len + 1];
        memoryUtil.byfill(ret, (byte)0);
        return ret;
    }

    public static final byte[] JavaToIfxDecimal(BigDecimal n) {
        Decimal d = new Decimal(n);
        return d.javaToIfx();
    }

    public static final byte[] JavaToIfxDouble(Double d) {
        return JavaToIfxType.JavaToIfxDouble((double)d);
    }

    public static final byte[] JavaToIfxDouble(double d) {
        byte[] b = new byte[8];
        long val = Double.doubleToLongBits(d);
        b[0] = (byte)(val >> 56 & 0xFFL);
        b[1] = (byte)(val >> 48 & 0xFFL);
        b[2] = (byte)(val >> 40 & 0xFFL);
        b[3] = (byte)(val >> 32 & 0xFFL);
        b[4] = (byte)(val >> 24 & 0xFFL);
        b[5] = (byte)(val >> 16 & 0xFFL);
        b[6] = (byte)(val >> 8 & 0xFFL);
        b[7] = (byte)(val & 0xFFL);
        return b;
    }

    public static final byte[] JavaToIfxReal(Float f) {
        return JavaToIfxType.JavaToIfxReal(f.floatValue());
    }

    public static byte[] JavaToIfxReal(float f) {
        int val = Float.floatToIntBits(f);
        return JavaToIfxType.JavaToIfxInt(val);
    }

    public static byte[] JavaToIfxSmallInt(short s) {
        byte[] b = new byte[]{(byte)(s >> 8), (byte)s};
        return b;
    }

    public static byte[] JavaToIfxLongInt(long l) {
        byte[] b = new byte[10];
        short sign = 1;
        if (l < 0L) {
            sign = -1;
            l = -l;
        }
        byte[] bSign = JavaToIfxType.JavaToIfxSmallInt(sign);
        System.arraycopy(bSign, 0, b, 0, 2);
        long i0 = l & 0xFFFFFFFFL;
        byte[] bInt = JavaToIfxType.JavaToIfxInt((int)i0);
        System.arraycopy(bInt, 0, b, 2, 4);
        int i1 = (int)(l >> 32);
        byte[] bUInt = JavaToIfxType.JavaToIfxInt(i1);
        System.arraycopy(bUInt, 0, b, 6, 4);
        return b;
    }

    static {
        Decimal.encodeDateTimePrecision(DATETIME_PREC, (byte)0, (byte)15);
        DP_SHORT = (short)(DATETIME_PREC[0] * 256 + DATETIME_PREC[1]);
    }
}

