/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;

public class IntervalYM
extends Interval {
    protected long months;
    protected static final int MonthsPerYear = 12;

    public IntervalYM() throws SQLException {
        this.setQualifier((byte)6, (byte)0, (byte)2);
    }

    public IntervalYM(Timestamp t1, Timestamp t2) throws SQLException {
        this.setQualifier((byte)6, (byte)0, (byte)2);
        this.set(t1, t2);
    }

    public IntervalYM(int years, int months) throws SQLException {
        this.setQualifier((byte)6, (byte)0, (byte)2);
        this.set(years, months);
    }

    public IntervalYM(int months, short qual) throws SQLException {
        this.setQualifier(qual);
        this.months = months;
    }

    public IntervalYM(String str) throws SQLException {
        this.setQualifier((byte)6, (byte)0, (byte)2);
        this.set(str);
    }

    public IntervalYM(String str, short qual) throws SQLException {
        this.setQualifier(qual);
        this.set(str);
    }

    public IntervalYM(String str, int len, byte startCode, byte endCode) throws SQLException {
        this.setQualifier((byte)len, startCode, endCode);
        this.set(str);
    }

    public void set(Timestamp t1, Timestamp t2) {
        GregorianCalendar cal1 = new GregorianCalendar();
        GregorianCalendar cal2 = new GregorianCalendar();
        cal1.setTime(t1);
        cal2.setTime(t2);
        int t1_years = cal1.get(1);
        int t2_years = cal2.get(1);
        int t1_months = cal1.get(2);
        int t2_months = cal2.get(2);
        int years = t1_years - t2_years;
        int months = t1_months - t2_months;
        this.set(years, months);
    }

    public void set(int years, int months) {
        if (years < 0) {
            if (months > 0) {
                ++years;
                months -= 12;
            }
        } else if (months < 0 && years > 0) {
            --years;
            months += 12;
        }
        this.months = months + years * 12;
    }

    public void set(String str) throws SQLException {
        this.fromString(str);
    }

    public String toString() {
        String retVal;
        short qual = this.getQualifier();
        byte endCode = Interval.getEndCode(qual);
        byte startCode = Interval.getStartCode(qual);
        long months = this.months;
        boolean isNegative = false;
        if (months < 0L) {
            isNegative = true;
            months = -months;
        }
        if (startCode == 0 && endCode == 2) {
            String yearStr = String.valueOf(months / 12L);
            String monthStr = "";
            if (months % 12L < 10L) {
                monthStr = "0";
            }
            monthStr = String.valueOf(monthStr) + String.valueOf(months % 12L);
            retVal = String.valueOf(yearStr) + Interval.dtdelim[0] + monthStr;
        } else if (startCode == 0) {
            retVal = String.valueOf(months / 12L);
        } else if (startCode == 2) {
            retVal = String.valueOf(months);
        } else {
            throw new NumberFormatException("Invalid qualifier for IntervalYM");
        }
        if (isNegative) {
            retVal = "-" + retVal;
        }
        return retVal;
    }

    public void fromString(String str) throws SQLException {
        if (str == null) {
            return;
        }
        short qual = this.getQualifier();
        str = str.trim();
        boolean isNegative = false;
        if (str.length() > 0 && str.charAt(0) == '-') {
            if (str.length() == 1) {
                throw IfxErrMsg.getSQLException(-79706, null);
            }
            isNegative = true;
            str = str.substring(1);
        }
        int[] data = this.stringToUnits(str, qual);
        this.months = data[0] * 12 + data[1];
        if (isNegative) {
            this.months = -this.months;
        }
    }

    public long getMonths() {
        return this.months;
    }

    public boolean equals(Object other) {
        boolean retval = false;
        if (other instanceof IntervalYM && other != null) {
            retval = this.months == ((IntervalYM)other).getMonths();
        }
        return retval;
    }

    public boolean greaterThan(IntervalYM other) {
        return other != null && this.months > other.getMonths();
    }

    public boolean lessThan(IntervalYM other) {
        return other != null && this.months < other.getMonths();
    }

    public void setQualifier(byte len, byte startCode, byte endCode) throws SQLException {
        if (startCode > 2 || endCode > 2 || startCode > endCode) {
            throw IfxErrMsg.getSQLException(-79707, null);
        }
        this.int_qual = (short)(endCode - startCode + len << 8 | startCode << 4 | endCode);
    }

    public void setQualifier(short qualifier) throws SQLException {
        byte startCode = Interval.getStartCode(qualifier);
        byte endCode = Interval.getEndCode(qualifier);
        if (startCode > 2 || endCode > 2 || startCode > endCode) {
            throw IfxErrMsg.getSQLException(-79707, null);
        }
        this.int_qual = qualifier;
    }
}

