/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class IntervalDF
extends Interval {
    protected long seconds;
    protected long nanos;
    protected static final int NanosPerSecond = 1000000000;
    protected static final int MilliPerSecond = 1000;
    protected static final int SecondsPerMinute = 60;
    protected static final int SecondsPerHour = 3600;
    protected static final int SecondsPerDay = 86400;

    public IntervalDF() throws SQLException {
        this.setQualifier((byte)4, (byte)15);
    }

    public IntervalDF(Timestamp t1, Timestamp t2) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(t1, t2);
    }

    public IntervalDF(long seconds, long nanos) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(seconds, nanos);
    }

    public IntervalDF(long seconds, long nanos, short qual) throws SQLException {
        this.setQualifier(qual);
        this.set(seconds, nanos);
    }

    public IntervalDF(String str) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(str);
    }

    public IntervalDF(String str, short qual) throws SQLException {
        this.setQualifier(qual);
        this.set(str);
    }

    public IntervalDF(String str, int len, byte startCode, byte endCode) throws SQLException {
        this.setQualifier((byte)len, startCode, endCode);
        this.set(str);
    }

    public void set(Timestamp t1, Timestamp t2) {
        long t1_seconds = ((Date)t1).getTime() / 1000L;
        long t2_seconds = ((Date)t2).getTime() / 1000L;
        long seconds = t1_seconds - t2_seconds;
        long nanos = t1.getNanos() - t2.getNanos();
        this.set(seconds, nanos);
    }

    public void set(long seconds, long nanos) {
        if (seconds < 0L) {
            if (nanos > 0L) {
                ++seconds;
                nanos -= 1000000000L;
            }
        } else if (nanos < 0L && seconds > 0L) {
            --seconds;
            nanos += 1000000000L;
        }
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public void set(String str) throws SQLException {
        if (str == null) {
            return;
        }
        this.fromString(str);
    }

    public String toString() {
        long secs = this.seconds;
        long nans = this.nanos;
        StringBuffer retval = new StringBuffer();
        short qual = this.getQualifier();
        int endCode = Interval.getEndCode(qual);
        byte startCode = Interval.getStartCode(qual);
        Interval.println("IntervalDF.toString() secs = " + secs + " nans = " + nans + " start = " + startCode + " end = " + endCode);
        boolean intervalNegative = false;
        if (this.seconds < 0L || this.seconds == 0L && this.nanos < 0L) {
            intervalNegative = true;
            secs = -this.seconds;
            nans = -nans;
        }
        if (startCode == 4) {
            long days = secs / 86400L;
            secs %= 86400L;
            retval.append(days);
            if (endCode > 4) {
                retval.append(Interval.dtdelim[2]);
            }
            Interval.println("After processing Days: " + retval);
        }
        if (startCode <= 6 && endCode >= 6) {
            long hours = secs / 3600L;
            secs %= 3600L;
            if (hours < 10L) {
                retval.append('0');
            }
            retval.append(hours);
            if (endCode > 6) {
                retval.append(Interval.dtdelim[3]);
            }
            Interval.println("After processing Hours: " + retval);
        }
        if (startCode <= 8 && endCode >= 8) {
            long mins = secs / 60L;
            secs %= 60L;
            if (mins < 10L) {
                retval.append('0');
            }
            retval.append(mins);
            if (endCode > 8) {
                retval.append(Interval.dtdelim[4]);
            }
            Interval.println("After processing Minutes: " + retval);
        }
        if (startCode <= 10 && endCode >= 10) {
            if (secs < 10L) {
                retval.append('0');
            }
            retval.append(secs);
            Interval.println("After processing Seconds: " + retval);
        }
        if (endCode > 10) {
            retval.append(Interval.dtdelim[5]);
            if (nans == 0L) {
                int i = 11;
                while (i <= endCode) {
                    retval.append('0');
                    ++i;
                }
            } else {
                int numDigsNeeded = endCode - 10;
                int numDigs = 0;
                int i = 11;
                long scale = 100000000L;
                while (i <= endCode && nans != 0L) {
                    if (nans < scale) {
                        retval.append('0');
                        ++numDigs;
                    } else {
                        retval.append((long)((int)nans) / scale);
                        ++numDigs;
                        nans %= scale;
                    }
                    scale /= 10L;
                    ++i;
                }
                i = numDigs;
                while (i < numDigsNeeded) {
                    retval.append('0');
                    ++i;
                }
            }
            Interval.println("After processing Fractions: " + retval);
        }
        Interval.println("IntervalDF.toString no strip |" + retval.toString());
        int insertIdx = 0;
        int lastPos = retval.length() - 1;
        while (insertIdx < lastPos && retval.charAt(insertIdx) == '0' && Character.isDigit(retval.charAt(insertIdx + 1))) {
            retval.setCharAt(insertIdx, ' ');
            ++insertIdx;
        }
        if (intervalNegative) {
            retval.insert(insertIdx, '-');
        }
        Interval.println("IntervalDF.toString return |" + retval.toString());
        return retval.toString();
    }

    public void fromString(String str) throws SQLException {
        if (str == null) {
            return;
        }
        short qual = this.getQualifier();
        str = str.trim();
        boolean isNegative = false;
        if (str.length() > 0 && str.charAt(0) == '-') {
            if (str.length() == 1) {
                throw IfxErrMsg.getSQLException(-79706, null);
            }
            isNegative = true;
            str = str.substring(1);
        }
        int[] data = this.stringToUnits(str, qual);
        this.seconds = (long)data[2] * 86400L;
        this.seconds += (long)data[3] * 3600L;
        this.seconds += (long)data[4] * 60L;
        this.seconds += (long)data[5];
        this.nanos = data[6];
        if (isNegative) {
            this.seconds = -this.seconds;
            this.nanos = -this.nanos;
        }
        Interval.println("IntervalDF.fromString() seconds = " + this.seconds + " nanos: " + this.nanos);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getNanoSeconds() {
        return this.nanos;
    }

    public boolean equals(Object other) {
        boolean retval = false;
        if (other instanceof IntervalDF && other != null) {
            retval = this.seconds == ((IntervalDF)other).getSeconds() && this.nanos == ((IntervalDF)other).getNanoSeconds();
        }
        return retval;
    }

    public boolean greaterThan(IntervalDF other) {
        boolean retval = false;
        if (other != null) {
            long otherSeconds = other.getSeconds();
            retval = this.seconds > otherSeconds ? true : this.seconds == otherSeconds && this.nanos > other.getNanoSeconds();
        }
        return retval;
    }

    public boolean lessThan(IntervalDF other) {
        boolean retval = false;
        if (other != null) {
            long otherSeconds = other.getSeconds();
            retval = this.seconds < otherSeconds ? true : this.seconds == otherSeconds && this.nanos < other.getNanoSeconds();
        }
        return retval;
    }

    private void setQualifier(byte startCode, byte endCode) throws SQLException {
        byte len = (byte)(endCode - startCode + (startCode == 0 ? 4 : 2));
        this.int_qual = (short)(len << 8 | startCode << 4 | endCode);
    }

    public void setQualifier(byte len, byte startCode, byte endCode) throws SQLException {
        Interval.println("Interval.setQualifier(" + len + " , " + startCode + " , " + endCode + ")");
        if (startCode < 4 || endCode < 4 || startCode > endCode) {
            throw IfxErrMsg.getSQLException(-79707, null);
        }
        this.int_qual = (short)(endCode - startCode + len << 8 | startCode << 4 | endCode);
    }

    public void setQualifier(short qualifier) throws SQLException {
        Interval.println("Interval.setQualifier(" + Integer.toString(qualifier, 16) + ")");
        byte startCode = Interval.getStartCode(qualifier);
        byte endCode = Interval.getEndCode(qualifier);
        if (startCode < 4 || endCode < 4 || startCode > endCode) {
            throw IfxErrMsg.getSQLException(-79707, null);
        }
        this.int_qual = qualifier;
    }
}

