/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.util.IfxErrMsg;
import java.sql.SQLException;

public abstract class Interval {
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;
    protected static final int DECSIZE = 16;
    protected static final int NUMBER_UNITS = 7;
    protected static final int YEAR_IDX = 0;
    protected static final int MONTH_IDX = 1;
    protected static final int DAY_IDX = 2;
    protected static final int HOUR_IDX = 3;
    protected static final int MIN_IDX = 4;
    protected static final int SEC_IDX = 5;
    protected static final int FRAC_IDX = 6;
    protected static final char[] dtdelim = new char[]{'-', '-', ' ', ':', ':', '.', ' '};
    protected static final boolean DEBUG = true;
    protected static boolean debugFlag;
    protected short int_qual;

    protected Interval() throws SQLException {
    }

    public static byte getLength(short qualifier) {
        return (byte)(qualifier >> 8);
    }

    protected byte getLength() {
        return Interval.getLength(this.int_qual);
    }

    public short getQualifier() {
        return this.int_qual;
    }

    public static short getQualifier(byte len, byte startCode, byte endCode) throws SQLException {
        Interval.goodQualifier(len, startCode, endCode);
        byte length = (byte)(endCode - startCode + len);
        short qualifier = (short)(length << 8 | startCode << 4 | endCode);
        return qualifier;
    }

    protected short getQualifier(byte startCode, byte endCode) throws SQLException {
        this.goodQualifier(startCode, endCode);
        short length = (short)(endCode - startCode + (startCode == 0 ? 4 : 2));
        short qualifier = (short)((byte)length << 8 | startCode << 4 | endCode);
        return qualifier;
    }

    public static void goodQualifier(byte length, byte startCode, byte endCode) throws SQLException {
        if (length < 0 || length > 9) {
            throw IfxErrMsg.getSQLException(-79717, null);
        }
        if (startCode < 0 || startCode > 15) {
            throw IfxErrMsg.getSQLException(-79718, null);
        }
        if (endCode < 0 || endCode > 15) {
            throw IfxErrMsg.getSQLException(-79719, null);
        }
    }

    protected boolean goodQualifier(byte startCode, byte endCode) throws SQLException {
        if (startCode > endCode) {
            throw IfxErrMsg.getSQLException(-79720, null);
        }
        if (startCode < 0 || startCode > 15) {
            throw IfxErrMsg.getSQLException(-79718, null);
        }
        if (endCode < 0 || endCode > 15) {
            throw IfxErrMsg.getSQLException(-79719, null);
        }
        return true;
    }

    public static byte getScale(short qualifier) {
        byte endCode = Interval.getEndCode(qualifier);
        byte scale = 0;
        if (endCode > 10) {
            scale = (byte)(endCode - 10);
        }
        return scale;
    }

    public static byte getStartCode(short qualifier) {
        byte startCode = (byte)(qualifier >> 4 & 0xF);
        return startCode;
    }

    public static byte getEndCode(short qualifier) {
        byte endCode = (byte)(qualifier & 0xF);
        return endCode;
    }

    public byte getStartCode() {
        return Interval.getStartCode(this.int_qual);
    }

    public byte getEndCode() {
        return Interval.getEndCode(this.int_qual);
    }

    protected byte getFirstLength(short qual) {
        int val = Interval.getLength(qual) - (Interval.getEndCode(qual) - Interval.getStartCode(qual));
        byte retval = (byte)val;
        return retval;
    }

    public static byte getStaticStartCode(short qualifier) {
        byte startCode = (byte)(qualifier >> 4 & 0xF);
        return startCode;
    }

    public static byte getStaticEndCode(short qualifier) {
        byte endCode = (byte)(qualifier & 0xF);
        return endCode;
    }

    public static String getFieldName(byte code) {
        switch (code) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public static String getIfxTypeName(int type, short qual) {
        String ret = null;
        if (type == 14) {
            ret = "interval ";
        } else if (type == 10) {
            ret = "datetime ";
        } else {
            return null;
        }
        ret = String.valueOf(ret) + Interval.getFieldName(Interval.getStaticStartCode(qual)) + " to " + Interval.getFieldName(Interval.getStaticEndCode(qual));
        return ret;
    }

    protected int[] stringToUnits(String str, short qual) throws SQLException {
        int[] data = new int[7];
        int i = 0;
        while (i < 7) {
            data[i] = 0;
            ++i;
        }
        byte endCode = Interval.getEndCode(qual);
        byte startCode = Interval.getStartCode(qual);
        byte fwidth = this.getFirstLength(qual);
        str = str.trim();
        int strIdx = 0;
        if (str.length() == 0) {
            return data;
        }
        Interval.println("str --" + str + "--");
        Interval.println("startCode " + startCode + " endCode " + endCode + " qual " + Integer.toString(qual, 16));
        try {
            int idx;
            int endIdx;
            if (startCode == 12) {
                if (str.charAt(strIdx) == '0') {
                    ++strIdx;
                }
                if (str.charAt(strIdx) != '.') {
                    throw IfxErrMsg.getSQLMinorException(-79721, -80000, null);
                }
                ++strIdx;
            } else {
                int numDigits = 0;
                while (numDigits < str.length()) {
                    if (!Character.isDigit(str.charAt(strIdx + numDigits))) break;
                    numDigits = (byte)(numDigits + 1);
                }
                Interval.println("fwidth " + fwidth + " numDigits " + numDigits);
                if (numDigits == 0) {
                    throw IfxErrMsg.getSQLMinorException(-79721, -80001, null);
                }
                if (numDigits > fwidth) {
                    throw IfxErrMsg.getSQLMinorException(-79721, -80002, null);
                }
                data[startCode / 2] = Integer.parseInt(str.substring(strIdx, strIdx + numDigits));
                Interval.println("data[" + startCode / 2 + "]: " + data[startCode / 2]);
                strIdx += numDigits + 1;
                startCode = (byte)(startCode + 2);
            }
            while (startCode <= endCode && startCode <= 10) {
                endIdx = strIdx;
                idx = strIdx + 1;
                if (!Character.isDigit(str.charAt(strIdx)) && str.charAt(strIdx) != ' ') {
                    throw IfxErrMsg.getSQLMinorException(-79722, -80003, Integer.toString(strIdx), null);
                }
                if (idx < str.length() && Character.isDigit(str.charAt(idx))) {
                    endIdx = idx++;
                }
                data[startCode / 2] = Integer.parseInt(str.substring(strIdx, endIdx + 1));
                Interval.println("data[" + startCode / 2 + "]: " + data[startCode / 2]);
                Interval.println("strIdx " + strIdx + " endIdx " + endIdx + " idx " + idx);
                if (idx < str.length() && str.charAt(idx) != dtdelim[startCode / 2]) {
                    if (startCode == endCode) break;
                    Interval.println("startCode " + startCode + " idx " + idx);
                    throw IfxErrMsg.getSQLMinorException(-79723, -80003, Integer.toString(idx), null);
                }
                strIdx = idx + 1;
                startCode = (byte)(startCode + 2);
            }
            if (strIdx < str.length()) {
                Interval.println("fraction part if any :" + str.substring(strIdx) + ":");
                endIdx = strIdx - 1;
                idx = strIdx;
                startCode = 11;
                int numDigits = 0;
                while (idx < str.length() && startCode <= endCode) {
                    if (!Character.isDigit(str.charAt(idx))) break;
                    ++endIdx;
                    ++idx;
                    startCode = (byte)(startCode + 1);
                    ++numDigits;
                }
                if (endIdx >= strIdx) {
                    int tmp = Integer.parseInt(str.substring(strIdx, endIdx + 1));
                    int numMult = 9 - numDigits;
                    int i2 = 0;
                    while (i2 < numMult) {
                        tmp *= 10;
                        ++i2;
                    }
                    data[6] = tmp;
                }
                strIdx = idx;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw IfxErrMsg.getSQLException(-79724, null);
        }
        if (strIdx < str.length()) {
            throw IfxErrMsg.getSQLException(-79725, str.substring(strIdx), null);
        }
        return data;
    }

    protected static void print(String str) {
        if (debugFlag) {
            System.out.print(str);
        }
    }

    protected static void println(String str) {
        if (debugFlag) {
            System.out.println(str);
        }
    }
}

