/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import java.util.Hashtable;

public class IfxTypes {
    public static final short IFX_TYPE_CHAR = 0;
    public static final short IFX_TYPE_SMALLINT = 1;
    public static final short IFX_TYPE_INT = 2;
    public static final short IFX_TYPE_FLOAT = 3;
    public static final short IFX_TYPE_SMFLOAT = 4;
    public static final short IFX_TYPE_DECIMAL = 5;
    public static final short IFX_TYPE_SERIAL = 6;
    public static final short IFX_TYPE_DATE = 7;
    public static final short IFX_TYPE_MONEY = 8;
    public static final short IFX_TYPE_NULL = 9;
    public static final short IFX_TYPE_DATETIME = 10;
    public static final short IFX_TYPE_BYTE = 11;
    public static final short IFX_TYPE_TEXT = 12;
    public static final short IFX_TYPE_VARCHAR = 13;
    public static final short IFX_TYPE_INTERVAL = 14;
    public static final short IFX_TYPE_NCHAR = 15;
    public static final short IFX_TYPE_NVCHAR = 16;
    public static final short IFX_TYPE_INT8 = 17;
    public static final short IFX_TYPE_SERIAL8 = 18;
    public static final short IFX_TYPE_SET = 19;
    public static final short IFX_TYPE_MULTISET = 20;
    public static final short IFX_TYPE_LIST = 21;
    public static final short IFX_TYPE_ROW = 22;
    public static final short IFX_TYPE_COLLECTION = 23;
    public static final short IFX_TYPE_ROWREF = 24;
    public static final short IFX_TYPE_UDTVAR = 40;
    public static final short IFX_TYPE_UDTFIXED = 41;
    public static final short IFX_TYPE_REFSER8 = 42;
    public static final short IFX_TYPE_LVARCHAR = 43;
    public static final short IFX_TYPE_SENDRECV = 44;
    public static final short IFX_TYPE_BOOL = 45;
    public static final short IFX_TYPE_IMPEXP = 46;
    public static final short IFX_TYPE_IMPEXPBIN = 47;
    public static final short IFX_TYPE_SQLUDRDEFAULT = 48;
    public static final short IFX_TYPE_UNKNOWN = -99;
    public static final short IFX_TYPE_MAX = 49;
    public static final short IFX_TYPE_CLOB = 101;
    public static final short IFX_TYPE_BLOB = 102;
    public static final short IFX_BIT_NOTNULLABLE = 256;
    public static final short IFX_BIT_DISTINCT = 2048;
    public static final short IFX_BIT_NAMEDROW = 4096;
    public static final short IFX_BIT_COLLCLIENT = Short.MIN_VALUE;
    public static final short IFX_BIT_DBOOLEAN = 16384;
    public static final short IFX_XID_LVARCHAR = 1;
    public static final short IFX_XID_SENDRECV = 2;
    public static final short IFX_XID_IMPEXP = 3;
    public static final short IFX_XID_IMPEXPBIN = 4;
    public static final short IFX_XID_BOOLEAN = 5;
    public static final short IFX_XID_POINTER = 6;
    public static final short IFX_XID_INDEXKEYARRAY = 7;
    public static final short IFX_XID_RTNPARAMTYPES = 8;
    public static final short IFX_XID_SELFUNCARGS = 9;
    public static final short IFX_XID_BLOB = 10;
    public static final short IFX_XID_CLOB = 11;
    public static final short IFX_XID_LOLIST = 12;
    public static final short IFX_XID_STAT = 15;
    public static final String IFX_XNAME_BLOB = "blob";
    public static final String IFX_XNAME_CLOB = "clob";
    public static final String IFX_XNAME_BOOL = "boolean";
    public static final String IFX_XNAME_LVARCHAR = "lvarchar";
    public static final int JAVA_OBJECT = 2000;
    public static final int DISTINCT = 2001;
    public static final int STRUCT = 2002;
    public static final int ARRAY = 2003;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int REF = 2006;
    static Hashtable IfxToJDBCTypeTable;
    static Hashtable JDBCToIfxTypeTable;
    static Hashtable JavaToIfxTypeTable;
    static Hashtable IfxTypeToJavaTable;
    static Hashtable IfxTypeToNameTable;
    static Hashtable JDBCTypeToNameTable;
    static Hashtable IfxNameToIfxTypeTable;

    private IfxTypes() {
    }

    public static int FromIfxToJDBCType(int ifxType) {
        Integer type = (Integer)IfxToJDBCTypeTable.get(new Integer(ifxType));
        if (type == null) {
            type = new Integer(1111);
        }
        return type;
    }

    public static int FromJDBCToIfxType(int jdbcType) {
        Integer type = (Integer)JDBCToIfxTypeTable.get(new Integer(jdbcType));
        if (type == null) {
            type = new Integer(-99);
        }
        return type;
    }

    public static int FromJavaToIfxType(String javaClassName) {
        Integer type = (Integer)JavaToIfxTypeTable.get(javaClassName);
        if (type == null) {
            type = new Integer(-99);
        }
        return type;
    }

    public static String FromIfxTypeToJava(int ifxType) {
        String name = (String)IfxTypeToJavaTable.get(new Integer(ifxType));
        if (name == null) {
            name = new String("unknown");
        }
        return name;
    }

    public static String IfxTypeToName(int ifxType) {
        String name = (String)IfxTypeToNameTable.get(new Integer(ifxType));
        if (name == null) {
            name = new String("unknown");
        }
        return name;
    }

    public static String JDBCTypeToName(int jdbcType) {
        String name = (String)JDBCTypeToNameTable.get(new Integer(jdbcType));
        if (name == null) {
            name = new String("unknown");
        }
        return name;
    }

    public static int FromIfxNameToIfxType(String name) {
        String s = new String(name);
        s.trim();
        s.toLowerCase();
        Integer type = (Integer)IfxNameToIfxTypeTable.get(s);
        if (type == null) {
            type = new Integer(1111);
        }
        return type;
    }

    public static boolean IsFloatTypes(int ifxType) {
        return (ifxType &= 0xFF) == 3 || ifxType == 4;
    }

    public static boolean isString(int ifxType) {
        return (ifxType &= 0xFF) == 0 || ifxType == 13 || ifxType == 15 || ifxType == 16 || ifxType == 43;
    }

    public static boolean isUDT(int ifxType) {
        return (ifxType &= 0xFF) == 40 || ifxType == 41 || ifxType == 45 || ifxType == 43;
    }

    public static boolean isCollection(int ifxType) {
        return (ifxType &= 0xFF) == 21 || ifxType == 19 || ifxType == 20;
    }

    public static boolean isComplexType(int ifxType) {
        if (IfxTypes.isCollection(ifxType)) {
            return true;
        }
        return (ifxType &= 0xFF) == 22;
    }

    static {
        if (IfxToJDBCTypeTable == null) {
            IfxToJDBCTypeTable = new Hashtable(49);
            IfxToJDBCTypeTable.put(new Integer(0), new Integer(1));
            IfxToJDBCTypeTable.put(new Integer(1), new Integer(5));
            IfxToJDBCTypeTable.put(new Integer(2), new Integer(4));
            IfxToJDBCTypeTable.put(new Integer(3), new Integer(8));
            IfxToJDBCTypeTable.put(new Integer(4), new Integer(6));
            IfxToJDBCTypeTable.put(new Integer(5), new Integer(3));
            IfxToJDBCTypeTable.put(new Integer(6), new Integer(4));
            IfxToJDBCTypeTable.put(new Integer(7), new Integer(91));
            IfxToJDBCTypeTable.put(new Integer(8), new Integer(3));
            IfxToJDBCTypeTable.put(new Integer(9), new Integer(0));
            IfxToJDBCTypeTable.put(new Integer(10), new Integer(93));
            IfxToJDBCTypeTable.put(new Integer(11), new Integer(-4));
            IfxToJDBCTypeTable.put(new Integer(12), new Integer(-1));
            IfxToJDBCTypeTable.put(new Integer(13), new Integer(12));
            IfxToJDBCTypeTable.put(new Integer(15), new Integer(1));
            IfxToJDBCTypeTable.put(new Integer(16), new Integer(12));
            IfxToJDBCTypeTable.put(new Integer(14), new Integer(1));
            IfxToJDBCTypeTable.put(new Integer(17), new Integer(-5));
            IfxToJDBCTypeTable.put(new Integer(18), new Integer(-5));
            IfxToJDBCTypeTable.put(new Integer(19), new Integer(1111));
            IfxToJDBCTypeTable.put(new Integer(21), new Integer(1111));
            IfxToJDBCTypeTable.put(new Integer(20), new Integer(1111));
            IfxToJDBCTypeTable.put(new Integer(22), new Integer(2002));
            IfxToJDBCTypeTable.put(new Integer(40), new Integer(2000));
            IfxToJDBCTypeTable.put(new Integer(41), new Integer(2000));
            IfxToJDBCTypeTable.put(new Integer(43), new Integer(-1));
            IfxToJDBCTypeTable.put(new Integer(44), new Integer(2000));
            IfxToJDBCTypeTable.put(new Integer(45), new Integer(1111));
            IfxToJDBCTypeTable.put(new Integer(46), new Integer(2000));
            IfxToJDBCTypeTable.put(new Integer(47), new Integer(2000));
            IfxToJDBCTypeTable.put(new Integer(102), new Integer(2004));
            IfxToJDBCTypeTable.put(new Integer(101), new Integer(2005));
        }
        if (JDBCToIfxTypeTable == null) {
            JDBCToIfxTypeTable = new Hashtable(49);
            JDBCToIfxTypeTable.put(new Integer(-5), new Integer(17));
            JDBCToIfxTypeTable.put(new Integer(-2), new Integer(11));
            JDBCToIfxTypeTable.put(new Integer(-7), new Integer(0));
            JDBCToIfxTypeTable.put(new Integer(1), new Integer(0));
            JDBCToIfxTypeTable.put(new Integer(91), new Integer(7));
            JDBCToIfxTypeTable.put(new Integer(3), new Integer(5));
            JDBCToIfxTypeTable.put(new Integer(8), new Integer(3));
            JDBCToIfxTypeTable.put(new Integer(6), new Integer(4));
            JDBCToIfxTypeTable.put(new Integer(4), new Integer(2));
            JDBCToIfxTypeTable.put(new Integer(-4), new Integer(11));
            JDBCToIfxTypeTable.put(new Integer(-1), new Integer(12));
            JDBCToIfxTypeTable.put(new Integer(0), new Integer(9));
            JDBCToIfxTypeTable.put(new Integer(2), new Integer(5));
            JDBCToIfxTypeTable.put(new Integer(7), new Integer(4));
            JDBCToIfxTypeTable.put(new Integer(5), new Integer(1));
            JDBCToIfxTypeTable.put(new Integer(92), new Integer(10));
            JDBCToIfxTypeTable.put(new Integer(93), new Integer(10));
            JDBCToIfxTypeTable.put(new Integer(-6), new Integer(1));
            JDBCToIfxTypeTable.put(new Integer(1111), new Integer(45));
            JDBCToIfxTypeTable.put(new Integer(-3), new Integer(11));
            JDBCToIfxTypeTable.put(new Integer(12), new Integer(13));
            JDBCToIfxTypeTable.put(new Integer(2000), new Integer(44));
            JDBCToIfxTypeTable.put(new Integer(2002), new Integer(22));
            JDBCToIfxTypeTable.put(new Integer(2003), new Integer(19));
            JDBCToIfxTypeTable.put(new Integer(2004), new Integer(102));
            JDBCToIfxTypeTable.put(new Integer(2005), new Integer(101));
        }
        if (JavaToIfxTypeTable == null) {
            JavaToIfxTypeTable = new Hashtable(49);
            JavaToIfxTypeTable.put(new String("java.lang.String"), new Integer(0));
            JavaToIfxTypeTable.put(new String("java.math.BigDecimal"), new Integer(5));
            JavaToIfxTypeTable.put(new String("java.lang.Boolean"), new Integer(1));
            JavaToIfxTypeTable.put(new String("java.lang.Integer"), new Integer(2));
            JavaToIfxTypeTable.put(new String("java.lang.Short"), new Integer(1));
            JavaToIfxTypeTable.put(new String("java.lang.Long"), new Integer(17));
            JavaToIfxTypeTable.put(new String("java.lang.Float"), new Integer(4));
            JavaToIfxTypeTable.put(new String("java.lang.Double"), new Integer(3));
            JavaToIfxTypeTable.put(new String("[B"), new Integer(11));
            JavaToIfxTypeTable.put(new String("java.sql.Date"), new Integer(7));
            JavaToIfxTypeTable.put(new String("java.sql.Time"), new Integer(10));
            JavaToIfxTypeTable.put(new String("java.sql.Timestamp"), new Integer(10));
            JavaToIfxTypeTable.put(new String("com.informix.lang.IntervalYM"), new Integer(14));
            JavaToIfxTypeTable.put(new String("com.informix.lang.IntervalDF"), new Integer(14));
            JavaToIfxTypeTable.put(new String("java.util.ArrayList"), new Integer(21));
            JavaToIfxTypeTable.put(new String("java.util.LinkedList"), new Integer(21));
            JavaToIfxTypeTable.put(new String("java.util.Vector"), new Integer(21));
            JavaToIfxTypeTable.put(new String("java.util.HashSet"), new Integer(19));
            JavaToIfxTypeTable.put(new String("java.util.TreeSet"), new Integer(19));
            JavaToIfxTypeTable.put(new String("java.lang.Boolean"), new Integer(45));
            JavaToIfxTypeTable.put(new String("java.sql.Blob"), new Integer(102));
            JavaToIfxTypeTable.put(new String("java.sql.Clob"), new Integer(101));
        }
        if (IfxTypeToJavaTable == null) {
            IfxTypeToJavaTable = new Hashtable(49);
            IfxTypeToJavaTable.put(new Integer(1), new String("java.lang.Short"));
            IfxTypeToJavaTable.put(new Integer(2), new String("java.lang.Integer"));
            IfxTypeToJavaTable.put(new Integer(3), new String("java.lang.Double"));
            IfxTypeToJavaTable.put(new Integer(4), new String("java.lang.Double"));
            IfxTypeToJavaTable.put(new Integer(5), new String("java.math.BigDecimal"));
            IfxTypeToJavaTable.put(new Integer(6), new String("java.lang.Integer"));
            IfxTypeToJavaTable.put(new Integer(7), new String("java.sql.Date"));
            IfxTypeToJavaTable.put(new Integer(8), new String("java.math.BigDecimal"));
            IfxTypeToJavaTable.put(new Integer(10), new String("java.sql.Timestamp"));
            IfxTypeToJavaTable.put(new Integer(11), new String("[B"));
            IfxTypeToJavaTable.put(new Integer(12), new String("java.lang.String"));
            IfxTypeToJavaTable.put(new Integer(13), new String("java.lang.String"));
            IfxTypeToJavaTable.put(new Integer(15), new String("java.lang.String"));
            IfxTypeToJavaTable.put(new Integer(16), new String("java.lang.String"));
            IfxTypeToJavaTable.put(new Integer(17), new String("java.lang.Long"));
            IfxTypeToJavaTable.put(new Integer(18), new String("java.lang.Long"));
            IfxTypeToJavaTable.put(new Integer(40), new String("java.sql.SQLData"));
            IfxTypeToJavaTable.put(new Integer(41), new String("java.sql.SQLData"));
            IfxTypeToJavaTable.put(new Integer(43), new String("java.lang.String"));
            IfxTypeToJavaTable.put(new Integer(44), new String("java.sql.SQLData"));
            IfxTypeToJavaTable.put(new Integer(45), new String("java.lang.Boolean"));
            IfxTypeToJavaTable.put(new Integer(46), new String("java.sql.SQLData"));
            IfxTypeToJavaTable.put(new Integer(47), new String("java.sql.SQLData"));
        }
        if (IfxTypeToNameTable == null) {
            IfxTypeToNameTable = new Hashtable(49);
            IfxTypeToNameTable.put(new Integer(0), new String("char"));
            IfxTypeToNameTable.put(new Integer(1), new String("smallint"));
            IfxTypeToNameTable.put(new Integer(2), new String("int"));
            IfxTypeToNameTable.put(new Integer(3), new String("float"));
            IfxTypeToNameTable.put(new Integer(4), new String("smallfloat"));
            IfxTypeToNameTable.put(new Integer(5), new String("decimal"));
            IfxTypeToNameTable.put(new Integer(6), new String("serial"));
            IfxTypeToNameTable.put(new Integer(7), new String("date"));
            IfxTypeToNameTable.put(new Integer(8), new String("money"));
            IfxTypeToNameTable.put(new Integer(10), new String("datetime"));
            IfxTypeToNameTable.put(new Integer(11), new String("byte"));
            IfxTypeToNameTable.put(new Integer(12), new String("text"));
            IfxTypeToNameTable.put(new Integer(13), new String("varchar"));
            IfxTypeToNameTable.put(new Integer(14), new String("interval"));
            IfxTypeToNameTable.put(new Integer(15), new String("nchar"));
            IfxTypeToNameTable.put(new Integer(16), new String("nvarchar"));
            IfxTypeToNameTable.put(new Integer(17), new String("int8"));
            IfxTypeToNameTable.put(new Integer(18), new String("serial8"));
            IfxTypeToNameTable.put(new Integer(43), new String(IFX_XNAME_LVARCHAR));
            IfxTypeToNameTable.put(new Integer(45), new String(IFX_XNAME_BOOL));
            IfxTypeToNameTable.put(new Integer(22), new String("row"));
            IfxTypeToNameTable.put(new Integer(19), new String("set"));
            IfxTypeToNameTable.put(new Integer(21), new String("list"));
            IfxTypeToNameTable.put(new Integer(20), new String("multiset"));
            IfxTypeToNameTable.put(new Integer(43), new String(IFX_XNAME_LVARCHAR));
            IfxTypeToNameTable.put(new Integer(45), new String(IFX_XNAME_BOOL));
            IfxTypeToNameTable.put(new Integer(102), new String(IFX_XNAME_BLOB));
            IfxTypeToNameTable.put(new Integer(101), new String(IFX_XNAME_CLOB));
        }
        if (IfxNameToIfxTypeTable == null) {
            IfxNameToIfxTypeTable = new Hashtable(49);
            IfxNameToIfxTypeTable.put(new String("char"), new Integer(0));
            IfxNameToIfxTypeTable.put(new String("smallint"), new Integer(1));
            IfxNameToIfxTypeTable.put(new String("int"), new Integer(2));
            IfxNameToIfxTypeTable.put(new String("integer"), new Integer(2));
            IfxNameToIfxTypeTable.put(new String("float"), new Integer(3));
            IfxNameToIfxTypeTable.put(new String("double precision"), new Integer(3));
            IfxNameToIfxTypeTable.put(new String("smallfloat"), new Integer(4));
            IfxNameToIfxTypeTable.put(new String("decimal"), new Integer(5));
            IfxNameToIfxTypeTable.put(new String("serial"), new Integer(6));
            IfxNameToIfxTypeTable.put(new String("date"), new Integer(7));
            IfxNameToIfxTypeTable.put(new String("money"), new Integer(8));
            IfxNameToIfxTypeTable.put(new String("datetime"), new Integer(10));
            IfxNameToIfxTypeTable.put(new String("byte"), new Integer(11));
            IfxNameToIfxTypeTable.put(new String("text"), new Integer(12));
            IfxNameToIfxTypeTable.put(new String("varchar"), new Integer(13));
            IfxNameToIfxTypeTable.put(new String("interval"), new Integer(14));
            IfxNameToIfxTypeTable.put(new String("nchar"), new Integer(15));
            IfxNameToIfxTypeTable.put(new String("nvarchar"), new Integer(16));
            IfxNameToIfxTypeTable.put(new String("int8"), new Integer(17));
            IfxNameToIfxTypeTable.put(new String("serial8"), new Integer(18));
            IfxNameToIfxTypeTable.put(new String("row"), new Integer(22));
            IfxNameToIfxTypeTable.put(new String("set"), new Integer(19));
            IfxNameToIfxTypeTable.put(new String("list"), new Integer(21));
            IfxNameToIfxTypeTable.put(new String("multiset"), new Integer(20));
            IfxNameToIfxTypeTable.put(new String(IFX_XNAME_LVARCHAR), new Integer(43));
            IfxNameToIfxTypeTable.put(new String(IFX_XNAME_BOOL), new Integer(45));
            IfxNameToIfxTypeTable.put(new String(IFX_XNAME_BLOB), new Integer(102));
            IfxNameToIfxTypeTable.put(new String(IFX_XNAME_CLOB), new Integer(101));
        }
        if (JDBCTypeToNameTable == null) {
            JDBCTypeToNameTable = new Hashtable(49);
            JDBCTypeToNameTable.put(new Integer(-5), new String("java.sql.Types.BIGINT"));
            JDBCTypeToNameTable.put(new Integer(-2), new String("java.sql.Types.BINARY"));
            JDBCTypeToNameTable.put(new Integer(-7), new String("java.sql.Types.BIT"));
            JDBCTypeToNameTable.put(new Integer(1), new String("java.sql.Types.CHAR"));
            JDBCTypeToNameTable.put(new Integer(91), new String("java.sql.Types.DATE"));
            JDBCTypeToNameTable.put(new Integer(3), new String("java.sql.Types.DECIMAL"));
            JDBCTypeToNameTable.put(new Integer(8), new String("java.sql.Types.DOUBLE"));
            JDBCTypeToNameTable.put(new Integer(6), new String("java.sql.Types.FLOAT"));
            JDBCTypeToNameTable.put(new Integer(4), new String("java.sql.Types.INTEGER"));
            JDBCTypeToNameTable.put(new Integer(-4), new String("java.sql.Types.LONGVARBINARY"));
            JDBCTypeToNameTable.put(new Integer(-1), new String("java.sql.Types.LONGVARCHAR"));
            JDBCTypeToNameTable.put(new Integer(0), new String("java.sql.Types.NULL"));
            JDBCTypeToNameTable.put(new Integer(2), new String("java.sql.Types.NUMERIC"));
            JDBCTypeToNameTable.put(new Integer(7), new String("java.sql.Types.REAL"));
            JDBCTypeToNameTable.put(new Integer(5), new String("java.sql.Types.SMALLINT"));
            JDBCTypeToNameTable.put(new Integer(92), new String("java.sql.Types.TIME"));
            JDBCTypeToNameTable.put(new Integer(93), new String("java.sql.Types.TIMESTAMP"));
            JDBCTypeToNameTable.put(new Integer(-6), new String("java.sql.Types.TINYINT"));
            JDBCTypeToNameTable.put(new Integer(1111), new String("java.sql.Types.OTHER"));
            JDBCTypeToNameTable.put(new Integer(-3), new String("java.sql.Types.VARBINARY"));
            JDBCTypeToNameTable.put(new Integer(12), new String("java.sql.Types.VARCHAR"));
            JDBCTypeToNameTable.put(new Integer(2003), new String("java.sql.Types.ARRAY"));
            JDBCTypeToNameTable.put(new Integer(2004), new String("java.sql.Types.BLOB"));
            JDBCTypeToNameTable.put(new Integer(2005), new String("java.sql.Types.CLOB"));
            JDBCTypeToNameTable.put(new Integer(2001), new String("java.sql.Types.DISTINCT"));
            JDBCTypeToNameTable.put(new Integer(2000), new String("java.sql.Types.JAVA_OBJECT"));
            JDBCTypeToNameTable.put(new Integer(2002), new String("java.sql.Types.STRUCT"));
        }
    }
}

